/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import erogenousbeef.bigreactors.common.BRLoader;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorAccessPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorComputerPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorCoolantPort;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPowerTap;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import erogenousbeef.core.multiblock.rectangular.PartPosition;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft"), @Optional.Interface(iface="powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode", modid="MineFactoryReloaded")})
public class BlockReactorPart
extends BlockContainer
implements IRedNetOmniNode,
IPeripheralProvider {
    public static final int METADATA_CASING = 0;
    public static final int METADATA_CONTROLLER = 1;
    public static final int METADATA_CONTROLROD = 2;
    public static final int METADATA_POWERTAP = 3;
    public static final int METADATA_ACCESSPORT = 4;
    public static final int METADATA_COOLANTPORT = 5;
    public static final int METADATA_REDNETPORT = 6;
    public static final int METADATA_COMPUTERPORT = 7;
    private static final int PORT_INLET = 0;
    private static final int PORT_OUTLET = 1;
    private static final int TAP_DISCONNECTED = 0;
    private static final int TAP_CONNECTED = 1;
    private static final int CONTROLLER_OFF = 0;
    private static final int CONTROLLER_IDLE = 1;
    private static final int CONTROLLER_ACTIVE = 2;
    private static String[] _subBlocks = new String[]{"casing", "controller", "controlRod", "powerTap", "accessPort", "coolantPort", "redNetPort", "computerPort"};
    private static String[][] _states = new String[][]{{"default", "face", "corner", "eastwest", "northsouth", "vertical"}, {"off", "idle", "active"}, {"top"}, {"disconnected", "connected"}, {"inlet", "outlet"}, {"inlet", "outlet"}, {"default"}, {"default"}};
    private IIcon[][] _icons = new IIcon[_states.length][];
    private IIcon[] _redNetPortConfigIcons = new IIcon[TileEntityReactorRedNetPort.CircuitType.values().length - 1];
    private static final int DEFAULT = 0;
    private static final int FACE = 1;
    private static final int CORNER = 2;
    private static final int EASTWEST = 3;
    private static final int NORTHSOUTH = 4;
    private static final int VERTICAL = 5;

    public static boolean isCasing(int metadata) {
        return metadata == 0;
    }

    public static boolean isController(int metadata) {
        return metadata == 1;
    }

    public static boolean isPowerTap(int metadata) {
        return metadata == 3;
    }

    public static boolean isAccessPort(int metadata) {
        return metadata == 4;
    }

    public static boolean isRedNetPort(int metadata) {
        return metadata == 6;
    }

    public static boolean isComputerPort(int metadata) {
        return metadata == 7;
    }

    public static boolean isCoolantPort(int metadata) {
        return metadata == 5;
    }

    public static boolean isControlRod(int metadata) {
        return metadata == 2;
    }

    public BlockReactorPart(Material material) {
        super(material);
        this.func_149672_a(field_149777_j);
        this.func_149711_c(2.0f);
        this.func_149663_c("blockReactorPart");
        this.func_149658_d("bigreactors:blockReactorPart");
        this.func_149647_a(BigReactors.TAB);
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        IIcon icon = null;
        int metadata = blockAccess.func_72805_g(x, y, z);
        if (metadata == 2) {
            return this.func_149691_a(side, metadata);
        }
        switch (metadata) {
            case 0: {
                icon = this.getCasingIcon(blockAccess, x, y, z, side);
                break;
            }
            case 1: {
                icon = this.getControllerIcon(blockAccess, x, y, z, side);
                break;
            }
            case 3: {
                icon = this.getPowerTapIcon(blockAccess, x, y, z, side);
                break;
            }
            case 4: {
                icon = this.getAccessPortIcon(blockAccess, x, y, z, side);
                break;
            }
            case 5: {
                icon = this.getCoolantPortIcon(blockAccess, x, y, z, side);
                break;
            }
            case 6: 
            case 7: {
                icon = this.getFaceOrBlockIcon(blockAccess, x, y, z, side, metadata);
            }
        }
        return icon != null ? icon : this.func_149691_a(side, metadata);
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (metadata == 2 ? side == 1 : side > 1 && metadata >= 0 && metadata < this._icons.length) {
            return this._icons[metadata][0];
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        String prefix = "bigreactors:" + this.func_149739_a() + ".";
        for (int metadata = 0; metadata < _states.length; ++metadata) {
            String[] blockStates = _states[metadata];
            this._icons[metadata] = new IIcon[blockStates.length];
            for (int state = 0; state < blockStates.length; ++state) {
                this._icons[metadata][state] = par1IconRegister.func_94245_a(prefix + _subBlocks[metadata] + "." + blockStates[state]);
            }
        }
        this.field_149761_L = par1IconRegister.func_94245_a("bigreactors:" + this.func_149739_a());
        TileEntityReactorRedNetPort.CircuitType[] circuitTypes = TileEntityReactorRedNetPort.CircuitType.values();
        String rednetPrefix = "bigreactors:redNet/";
        for (int i = 1; i < circuitTypes.length; ++i) {
            this._redNetPortConfigIcons[i - 1] = par1IconRegister.func_94245_a(rednetPrefix + circuitTypes[i].name());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getRedNetConfigIcon(TileEntityReactorRedNetPort.CircuitType circuitType) {
        if (circuitType == TileEntityReactorRedNetPort.CircuitType.DISABLED) {
            return null;
        }
        return this._redNetPortConfigIcons[circuitType.ordinal() - 1];
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (metadata) {
            case 3: {
                return new TileEntityReactorPowerTap();
            }
            case 4: {
                return new TileEntityReactorAccessPort();
            }
            case 6: {
                return new TileEntityReactorRedNetPort();
            }
            case 7: {
                return new TileEntityReactorComputerPort();
            }
            case 5: {
                return new TileEntityReactorCoolantPort();
            }
            case 2: {
                return new TileEntityReactorControlRod();
            }
        }
        return new TileEntityReactorPart();
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        TileEntity te = StaticUtils.TE.getTileEntityUnsafe(world, x, y, z);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborBlockChange(world, x, y, z, neighborBlock);
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int neighborX, int neighborY, int neighborZ) {
        TileEntity te = StaticUtils.TE.getTileEntityUnsafe(world, x, y, z);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborTileChange(world, x, y, z, neighborX, neighborY, neighborZ);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            return false;
        }
        int metadata = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        IMultiblockPart part = null;
        MultiblockControllerBase controller = null;
        if (te instanceof IMultiblockPart) {
            part = (IMultiblockPart)te;
            controller = part.getMultiblockController();
        }
        if (BlockReactorPart.isCasing(metadata) || BlockReactorPart.isPowerTap(metadata) || BlockReactorPart.isComputerPort(metadata)) {
            if (player.func_71045_bC() == null) {
                if (controller != null) {
                    MultiblockValidationException e = controller.getLastValidationException();
                    if (e != null) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(e.getMessage()));
                        return true;
                    }
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Block is not connected to a reactor. This could be due to lag, or a bug. If the problem persists, try breaking and re-placing the block."));
                    return true;
                }
            }
            return false;
        }
        if (!world.field_72995_K && (BlockReactorPart.isAccessPort(metadata) || BlockReactorPart.isCoolantPort(metadata))) {
            ItemStack currentEquippedItem = player.func_71045_bC();
            if (StaticUtils.Inventory.isPlayerHoldingWrench(player)) {
                if (te instanceof TileEntityReactorCoolantPort) {
                    TileEntityReactorCoolantPort cp;
                    cp.setInlet(!(cp = (TileEntityReactorCoolantPort)te).isInlet(), true);
                    return true;
                }
                if (te instanceof TileEntityReactorAccessPort) {
                    TileEntityReactorAccessPort cp;
                    cp.setInlet(!(cp = (TileEntityReactorAccessPort)te).isInlet());
                    return true;
                }
            } else if (BlockReactorPart.isCoolantPort(metadata)) {
                return false;
            }
        }
        if (BlockReactorPart.isController(metadata) && (controller == null || !controller.isAssembled())) {
            return false;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)BRLoader.instance, 0, world, x, y, z);
        }
        return true;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public ItemStack getReactorCasingItemStack() {
        return new ItemStack((Block)this, 1, 0);
    }

    public ItemStack getReactorControllerItemStack() {
        return new ItemStack((Block)this, 1, 1);
    }

    public ItemStack getReactorPowerTapItemStack() {
        return new ItemStack((Block)this, 1, 3);
    }

    public ItemStack getAccessPortItemStack() {
        return new ItemStack((Block)this, 1, 4);
    }

    public ItemStack getRedNetPortItemStack() {
        return new ItemStack((Block)this, 1, 6);
    }

    public ItemStack getComputerPortItemStack() {
        return new ItemStack((Block)this, 1, 7);
    }

    public ItemStack getCoolantPortItemStack() {
        return new ItemStack((Block)this, 1, 5);
    }

    public ItemStack getControlRodItemStack() {
        return new ItemStack((Block)this, 1, 2);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int metadata = 0; metadata < _subBlocks.length; ++metadata) {
            par3List.add(new ItemStack((Block)this, 1, metadata));
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = inventory.func_70301_a(i);
                if (itemstack == null) continue;
                float xOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float yOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float zOffset = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int amountToDrop = world.field_73012_v.nextInt(21) + 10;
                    if (amountToDrop > itemstack.field_77994_a) {
                        amountToDrop = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= amountToDrop;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new ItemStack(itemstack.func_77973_b(), amountToDrop, itemstack.func_77960_j()));
                    if (itemstack.func_77978_p() != null) {
                        entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p());
                    }
                    float motionMultiplier = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * motionMultiplier + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * motionMultiplier;
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorRedNetPort) {
            return RedNetConnectionType.CableAll;
        }
        return RedNetConnectionType.None;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public int[] getOutputValues(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorRedNetPort) {
            return ((TileEntityReactorRedNetPort)te).getOutputValues();
        }
        int[] values = new int[16];
        for (int i = 0; i < 16; ++i) {
            values[i] = 0;
        }
        return values;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public int getOutputValue(World world, int x, int y, int z, ForgeDirection side, int subnet) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorRedNetPort) {
            return ((TileEntityReactorRedNetPort)te).getValueForChannel(subnet);
        }
        return 0;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public void onInputsChanged(World world, int x, int y, int z, ForgeDirection side, int[] inputValues) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorRedNetPort) {
            ((TileEntityReactorRedNetPort)te).onInputValuesChanged(inputValues);
        }
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public void onInputChanged(World world, int x, int y, int z, ForgeDirection side, int inputValue) {
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorComputerPort) {
            return (IPeripheral)te;
        }
        return null;
    }

    private IIcon getCoolantPortIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityReactorCoolantPort port;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorCoolantPort && (!this.isReactorAssembled(port = (TileEntityReactorCoolantPort)te) || this.isOutwardsSide(port, side))) {
            if (port.isInlet()) {
                return this._icons[5][0];
            }
            return this._icons[5][1];
        }
        return this.field_149761_L;
    }

    private IIcon getAccessPortIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityReactorAccessPort port;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorAccessPort && (!this.isReactorAssembled(port = (TileEntityReactorAccessPort)te) || this.isOutwardsSide(port, side))) {
            if (port.isInlet()) {
                return this._icons[4][0];
            }
            return this._icons[4][1];
        }
        return this.field_149761_L;
    }

    private IIcon getPowerTapIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityReactorPowerTap tap;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorPowerTap && (!this.isReactorAssembled(tap = (TileEntityReactorPowerTap)te) || this.isOutwardsSide(tap, side))) {
            if (tap.hasEnergyConnection()) {
                return this._icons[3][1];
            }
            return this._icons[3][0];
        }
        return this.field_149761_L;
    }

    private IIcon getControllerIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorPart) {
            TileEntityReactorPart controller = (TileEntityReactorPart)te;
            MultiblockReactor reactor = controller.getReactorController();
            if (reactor == null || !reactor.isAssembled()) {
                return this._icons[1][0];
            }
            if (!this.isOutwardsSide(controller, side)) {
                return this.field_149761_L;
            }
            if (reactor.getActive()) {
                return this._icons[1][2];
            }
            return this._icons[1][1];
        }
        return this.field_149761_L;
    }

    private IIcon getCasingIcon(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorPart) {
            TileEntityReactorPart part = (TileEntityReactorPart)te;
            PartPosition position = part.getPartPosition();
            MultiblockReactor reactor = part.getReactorController();
            if (reactor == null || !reactor.isAssembled()) {
                return this._icons[0][0];
            }
            switch (position) {
                case BottomFace: 
                case TopFace: 
                case EastFace: 
                case WestFace: 
                case NorthFace: 
                case SouthFace: {
                    return this._icons[0][1];
                }
                case FrameCorner: {
                    return this._icons[0][2];
                }
                case Frame: {
                    return this.getCasingEdgeIcon(part, reactor, side);
                }
            }
            return this._icons[0][0];
        }
        return this._icons[0][0];
    }

    private IIcon getCasingEdgeIcon(TileEntityReactorPart part, MultiblockReactor reactor, int side) {
        if (reactor == null || !reactor.isAssembled()) {
            return this._icons[0][0];
        }
        CoordTriplet minCoord = reactor.getMinimumCoord();
        CoordTriplet maxCoord = reactor.getMaximumCoord();
        boolean zExtreme = false;
        boolean yExtreme = false;
        boolean xExtreme = false;
        if (part.field_145851_c == minCoord.x || part.field_145851_c == maxCoord.x) {
            xExtreme = true;
        }
        if (part.field_145848_d == minCoord.y || part.field_145848_d == maxCoord.y) {
            yExtreme = true;
        }
        if (part.field_145849_e == minCoord.z || part.field_145849_e == maxCoord.z) {
            zExtreme = true;
        }
        int idx = 0;
        if (!xExtreme) {
            if (side < 4) {
                idx = 3;
            }
        } else if (!yExtreme) {
            if (side > 1) {
                idx = 5;
            }
        } else if (side < 2) {
            idx = 4;
        } else if (side > 3) {
            idx = 3;
        }
        return this._icons[0][idx];
    }

    private IIcon getFaceOrBlockIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int metadata) {
        TileEntityReactorPart part;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityReactorPart && (!this.isReactorAssembled(part = (TileEntityReactorPart)te) || this.isOutwardsSide(part, side))) {
            return this._icons[metadata][0];
        }
        return this.field_149761_L;
    }

    private boolean isOutwardsSide(TileEntityReactorPart part, int side) {
        ForgeDirection outDir = part.getOutwardsDir();
        return outDir.ordinal() == side;
    }

    private boolean isReactorAssembled(TileEntityReactorPart part) {
        MultiblockReactor reactor = part.getReactorController();
        return reactor != null && reactor.isAssembled();
    }
}

