/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.core.common.CoordTriplet;
import java.util.HashMap;
import java.util.Map;
import li.cil.oc.api.network.Arguments;
import li.cil.oc.api.network.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class TileEntityReactorComputerPort
extends TileEntityReactorPart
implements IPeripheral,
SimpleComponent,
ManagedPeripheral {
    public static final int numMethods;
    public static final String[] methodNames;
    public static final Map<String, Integer> methodIds;

    public Object[] callMethod(int method, Object[] arguments) throws Exception {
        if (method < 0 || method >= numMethods) {
            throw new IllegalArgumentException("Invalid method number");
        }
        if (method == 0) {
            return new Object[]{this.isConnected()};
        }
        if (!this.isConnected()) {
            throw new Exception("Unable to access reactor - port is not connected");
        }
        MultiblockReactor reactor = this.getReactorController();
        ComputerMethod computerMethod = ComputerMethod.values()[method];
        switch (computerMethod) {
            case getEnergyStored: {
                return new Object[]{(int)reactor.getEnergyStored()};
            }
            case getNumberOfControlRods: {
                return new Object[]{reactor.getFuelRodCount()};
            }
            case getActive: {
                return new Object[]{reactor.getActive()};
            }
            case getFuelTemperature: {
                return new Object[]{Float.valueOf(reactor.getFuelHeat())};
            }
            case getCasingTemperature: {
                return new Object[]{Float.valueOf(reactor.getReactorHeat())};
            }
            case getFuelAmount: {
                return new Object[]{reactor.getFuelAmount()};
            }
            case getWasteAmount: {
                return new Object[]{reactor.getWasteAmount()};
            }
            case getFuelAmountMax: {
                return new Object[]{reactor.getCapacity()};
            }
            case getControlRodName: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                TileEntityReactorControlRod controlRod = this.getControlRodFromArguments(reactor, arguments, 0);
                return new Object[]{controlRod.getName()};
            }
            case getControlRodLevel: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                TileEntityReactorControlRod controlRod = this.getControlRodFromArguments(reactor, arguments, 0);
                return new Object[]{(int)controlRod.getControlRodInsertion()};
            }
            case getEnergyProducedLastTick: {
                return new Object[]{Float.valueOf(reactor.getEnergyGeneratedLastTick())};
            }
            case getHotFluidProducedLastTick: {
                if (reactor.isPassivelyCooled()) {
                    return new Object[]{Float.valueOf(0.0f)};
                }
                return new Object[]{Float.valueOf(reactor.getEnergyGeneratedLastTick())};
            }
            case isActivelyCooled: {
                return new Object[]{!reactor.isPassivelyCooled()};
            }
            case getCoolantAmount: {
                return new Object[]{reactor.getCoolantContainer().getCoolantAmount()};
            }
            case getCoolantAmountMax: {
                return new Object[]{reactor.getCoolantContainer().getCapacity()};
            }
            case getCoolantType: {
                Fluid fluidType = reactor.getCoolantContainer().getCoolantType();
                if (fluidType == null) {
                    return null;
                }
                return new Object[]{fluidType.getName()};
            }
            case getHotFluidAmount: {
                return new Object[]{reactor.getCoolantContainer().getVaporAmount()};
            }
            case getHotFluidAmountMax: {
                return new Object[]{reactor.getCoolantContainer().getCapacity()};
            }
            case getHotFluidType: {
                Fluid fluidType = reactor.getCoolantContainer().getVaporType();
                if (fluidType == null) {
                    return null;
                }
                return new Object[]{fluidType.getName()};
            }
            case getFuelReactivity: {
                return new Object[]{Float.valueOf(reactor.getFuelFertility() * 100.0f)};
            }
            case getFuelConsumedLastTick: {
                return new Object[]{Float.valueOf(reactor.getFuelConsumedLastTick())};
            }
            case getMinimumCoordinate: {
                CoordTriplet coord = reactor.getMinimumCoord();
                return new Object[]{coord.x, coord.y, coord.z};
            }
            case getMaximumCoordinate: {
                CoordTriplet coord = reactor.getMaximumCoord();
                return new Object[]{coord.x, coord.y, coord.z};
            }
            case setActive: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                if (!(arguments[0] instanceof Boolean)) {
                    throw new IllegalArgumentException("Invalid argument 0, expected Boolean");
                }
                boolean newState = (Boolean)arguments[0];
                reactor.setActive(newState);
                return null;
            }
            case setAllControlRodLevels: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new IllegalArgumentException("Invalid argument 0, expected Number");
                }
                int newLevel = (int)Math.round((Double)arguments[0]);
                reactor.setAllControlRodInsertionValues(newLevel);
                return null;
            }
            case setControlRodLevel: {
                if (arguments.length < 2) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 2 (control rod index, level)");
                }
                if (!(arguments[1] instanceof Double)) {
                    throw new IllegalArgumentException("Invalid argument 0, expected Number");
                }
                int newLevel = (int)Math.round((Double)arguments[1]);
                if (newLevel < 0 || newLevel > 100) {
                    throw new IllegalArgumentException("Invalid argument 1, valid range is 0-100");
                }
                TileEntityReactorControlRod controlRod = this.getControlRodFromArguments(reactor, arguments, 0);
                controlRod.setControlRodInsertion((short)newLevel);
                return null;
            }
            case doEjectWaste: {
                reactor.ejectWaste(false, null);
                return null;
            }
            case doEjectFuel: {
                reactor.ejectFuel(false, null);
                return null;
            }
        }
        throw new Exception("Method unimplemented - yell at Beef");
    }

    private TileEntityReactorControlRod getControlRodFromArguments(MultiblockReactor reactor, Object[] arguments, int index) throws Exception {
        if (!(arguments[index] instanceof Double)) {
            throw new IllegalArgumentException(String.format("Invalid argument %d, expected Number", index));
        }
        int rodIndex = (int)Math.round((Double)arguments[index]);
        if (index < 0 || index >= reactor.getFuelRodCount()) {
            throw new IndexOutOfBoundsException(String.format("Invalid argument %d, control rod index is out of bounds", index));
        }
        CoordTriplet coord = reactor.getControlRodLocations()[rodIndex];
        TileEntity te = this.field_145850_b.func_147438_o(coord.x, coord.y, coord.z);
        if (!(te instanceof TileEntityReactorControlRod)) {
            throw new Exception("Encountered an invalid tile entity when seeking a control rod. That's weird.");
        }
        return (TileEntityReactorControlRod)te;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "BigReactors-Reactor";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return methodNames;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        try {
            return this.callMethod(method, arguments);
        }
        catch (Exception e) {
            BRLog.info("Exception received when calling computercraft method: %s", e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "br_reactor";
    }

    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return methodNames;
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        Object[] arguments = new Object[args.count()];
        for (int i = 0; i < args.count(); ++i) {
            arguments[i] = args.checkAny(i);
        }
        Integer methodId = methodIds.get(method);
        if (methodId == null) {
            throw new NoSuchMethodError();
        }
        return this.callMethod(methodId, arguments);
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this.hashCode() == other.hashCode();
    }

    static {
        ComputerMethod[] methods;
        numMethods = ComputerMethod.values().length;
        methodNames = new String[numMethods];
        for (ComputerMethod method : methods = ComputerMethod.values()) {
            TileEntityReactorComputerPort.methodNames[method.ordinal()] = method.toString();
        }
        methodIds = new HashMap<String, Integer>();
        for (int i = 0; i < numMethods; ++i) {
            methodIds.put(methodNames[i], i);
        }
    }

    public static enum ComputerMethod {
        getConnected,
        getActive,
        getFuelTemperature,
        getCasingTemperature,
        getEnergyStored,
        getFuelAmount,
        getWasteAmount,
        getFuelAmountMax,
        getControlRodName,
        getNumberOfControlRods,
        getControlRodLevel,
        getEnergyProducedLastTick,
        getHotFluidProducedLastTick,
        getCoolantAmount,
        getCoolantAmountMax,
        getCoolantType,
        getHotFluidAmount,
        getHotFluidAmountMax,
        getHotFluidType,
        getFuelReactivity,
        getFuelConsumedLastTick,
        getMinimumCoordinate,
        getMaximumCoordinate,
        isActivelyCooled,
        setActive,
        setControlRodLevel,
        setAllControlRodLevels,
        doEjectWaste,
        doEjectFuel;

    }
}

