/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import cofh.lib.util.helpers.BlockHelper;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityBeefBase;
import erogenousbeef.bigreactors.utils.AdjacentInventoryHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityInventory
extends TileEntityBeefBase
implements IInventory,
ISidedInventory {
    protected ItemStack[] _inventories = new ItemStack[this.func_70302_i_()];
    protected int[][] invSlotExposures = new int[this.func_70302_i_()][1];
    private AdjacentInventoryHelper[] adjacentInvs;
    protected static final int SLOT_NONE = -1;

    public TileEntityInventory() {
        for (int i = 0; i < this.invSlotExposures.length; ++i) {
            this.invSlotExposures[i][0] = i;
        }
        this.adjacentInvs = new AdjacentInventoryHelper[ForgeDirection.VALID_DIRECTIONS.length];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.adjacentInvs[dir.ordinal()] = new AdjacentInventoryHelper(dir);
        }
        this.resetAdjacentInventories();
    }

    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.checkAdjacentInventories();
    }

    public void onNeighborTileChange(int x, int y, int z) {
        super.onNeighborTileChange(x, y, z);
        int side = BlockHelper.determineAdjacentSide((TileEntity)this, (int)x, (int)y, (int)z);
        this.checkAdjacentInventory(ForgeDirection.getOrientation((int)side));
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this._inventories = new ItemStack[this.func_70302_i_()];
        if (tag.func_74764_b("Items")) {
            NBTTagList tagList = tag.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = tagList.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot > this._inventories.length) continue;
                ItemStack itemStack = new ItemStack((Block)null, 0, 0);
                itemStack.func_77963_c(itemTag);
                this._inventories[slot] = itemStack;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this._inventories.length; ++i) {
            if (this._inventories[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this._inventories[i].func_77955_b(itemTag);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        if (tagList.func_74745_c() > 0) {
            tag.func_74782_a("Items", (NBTBase)tagList);
        }
    }

    public abstract int func_70302_i_();

    public ItemStack func_70301_a(int slot) {
        return this._inventories[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this._inventories[slot] != null) {
            if (this._inventories[slot].field_77994_a <= amount) {
                ItemStack itemstack = this._inventories[slot];
                this._inventories[slot] = null;
                return itemstack;
            }
            ItemStack newStack = this._inventories[slot].func_77979_a(amount);
            if (this._inventories[slot].field_77994_a == 0) {
                this._inventories[slot] = null;
            }
            return newStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this._inventories[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public abstract String func_145825_b();

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public abstract boolean func_94041_b(int var1, ItemStack var2);

    protected abstract int getExposedInventorySlotFromSide(int var1);

    public int[] func_94128_d(int side) {
        int exposedSlot = this.getExposedInventorySlotFromSide(side);
        if (exposedSlot >= 0 && exposedSlot < this.invSlotExposures.length) {
            return this.invSlotExposures[exposedSlot];
        }
        return kEmptyIntArray;
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean canConduitConnect(ForgeDirection from) {
        return from != ForgeDirection.UNKNOWN;
    }

    protected void distributeItems() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.distributeSide(dir);
        }
    }

    protected void distributeItemsFromSlot(int slot) {
        if (slot == -1) {
            return;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int sideSlot = this.getExposedInventorySlotFromSide(dir.ordinal());
            if (slot == sideSlot) {
                this._inventories[slot] = this.distributeItemToSide(dir, this._inventories[slot]);
            }
            if (this._inventories[slot] == null) break;
        }
    }

    protected void distributeSide(ForgeDirection dir) {
        int slot = this.getExposedInventorySlotFromSide(dir.ordinal());
        if (slot == -1) {
            return;
        }
        if (this._inventories[slot] == null) {
            return;
        }
        this._inventories[slot] = this.distributeItemToSide(dir, this._inventories[slot]);
    }

    protected ItemStack distributeItemToSide(ForgeDirection dir, ItemStack itemstack) {
        return this.adjacentInvs[dir.ordinal()].distribute(itemstack);
    }

    private void checkAdjacentInventories() {
        boolean changed = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.checkAdjacentInventory(dir);
        }
    }

    private void checkAdjacentInventory(ForgeDirection dir) {
        int side = dir.ordinal();
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (this.adjacentInvs[dir.ordinal()].set(te)) {
            this.distributeSide(dir);
        }
    }

    private void resetAdjacentInventories() {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.adjacentInvs[i].set(null);
        }
    }
}

