/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.BeefGuiControlBase;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;

@SideOnly(value=Side.CLIENT)
public class BeefGuiLabel
extends BeefGuiControlBase
implements IBeefTooltipControl {
    protected int xMax;
    protected String labelText;
    protected String labelTooltip;
    protected boolean dropShadow;
    protected int color;

    public String getLabelText() {
        return this.labelText;
    }

    public String getLabelTooltip() {
        return this.labelTooltip;
    }

    public void setLabelText(String newText) {
        if (newText == this.labelText) {
            return;
        }
        this.labelText = newText;
        this.recalculateSize();
    }

    public void setLabelTooltip(String newTooltip) {
        this.labelTooltip = newTooltip;
    }

    public void setDropShadow(boolean shadow) {
        this.dropShadow = shadow;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setWordWrapLength(int pixels) {
        this.xMax = pixels;
    }

    public BeefGuiLabel(BeefGuiBase container, String text, int x, int y) {
        super(container, x, y, 0, 0);
        this.labelText = text;
        this.recalculateSize();
    }

    private void recalculateSize() {
        FontRenderer fontRenderer = this.guiContainer.getFontRenderer();
        if (this.xMax > 0) {
            this.width = fontRenderer.func_78267_b(this.labelText, this.xMax);
            int totalWidth = fontRenderer.func_78256_a(this.labelText);
            this.height = fontRenderer.field_78288_b * Math.max(1, totalWidth / this.width);
        } else {
            this.width = fontRenderer.func_78256_a(this.labelText);
            this.height = fontRenderer.field_78288_b;
        }
    }

    @Override
    public void drawBackground(TextureManager renderEngine, int mouseX, int mouseY) {
    }

    @Override
    public void drawForeground(TextureManager renderEngine, int mouseX, int mouseY) {
        FontRenderer fontRenderer = this.guiContainer.getFontRenderer();
        if (this.xMax > 0) {
            fontRenderer.func_78279_b(this.labelText, this.relativeX, this.relativeY, this.color, this.xMax);
        } else {
            fontRenderer.func_85187_a(this.labelText, this.relativeX, this.relativeY, this.color, this.dropShadow);
        }
    }

    @Override
    public String[] getTooltip() {
        if (this.labelTooltip == null || this.labelTooltip.isEmpty()) {
            return null;
        }
        return new String[]{this.labelTooltip};
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.absoluteX && mouseX <= this.absoluteX + this.width && mouseY >= this.absoluteY && mouseY <= this.absoluteY + this.height;
    }
}

