/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.data;

import net.minecraftforge.fluids.Fluid;

public class FluidStateData {
    private String m_Name;
    private Fluid m_Liquid;
    private Fluid m_Gas;
    private int m_BoilingPoint;
    private int m_HeatOfVaporization;
    private int m_CoefficientOfExpansion;

    public FluidStateData(String name, Fluid liquid, Fluid gas, int bp, int hov, int coe) {
        assert (name != null);
        assert (liquid != null);
        assert (gas != null);
        assert (bp > 0);
        assert (hov > 0);
        assert (coe > 0);
        this.m_Name = name;
        this.m_Liquid = liquid;
        this.m_Gas = gas;
        this.m_BoilingPoint = bp;
        this.m_HeatOfVaporization = hov;
        this.m_CoefficientOfExpansion = coe;
    }

    public String getName() {
        return this.m_Name;
    }

    public Fluid getLiquid() {
        return this.m_Liquid;
    }

    public Fluid getGas() {
        return this.m_Gas;
    }

    public int getBoilingPoint() {
        return this.m_BoilingPoint;
    }

    public int getHeatOfVaporization() {
        return this.m_HeatOfVaporization;
    }

    public int getCoefficientOfExpansion() {
        return this.m_CoefficientOfExpansion;
    }

    public float getCondensationRf(int unitsOfCondensate) {
        return (float)unitsOfCondensate * (float)this.m_HeatOfVaporization;
    }

    public float getEvaporationRf(int unitsOfEvaporite) {
        return (float)unitsOfEvaporite * (float)this.m_HeatOfVaporization;
    }
}

