/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.interfaces.IMultipleFluidHandler;
import erogenousbeef.bigreactors.common.multiblock.helpers.CondenserContainer;
import erogenousbeef.bigreactors.common.multiblock.helpers.SteamEvapContainer;
import erogenousbeef.bigreactors.common.multiblock.interfaces.IActivateable;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.core.common.CoordTriplet;
import erogenousbeef.core.multiblock.IMultiblockPart;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import erogenousbeef.core.multiblock.rectangular.RectangularMultiblockControllerBase;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;

public class MultiblockHeatExchanger
extends RectangularMultiblockControllerBase
implements IActivateable,
IMultipleFluidHandler {
    private HashSet<ITickableMultiblockPart> m_TickableParts = new HashSet();
    private boolean m_Active = false;
    private CondenserContainer m_Condenser = new CondenserContainer();
    private SteamEvapContainer m_Evaporator = new SteamEvapContainer();

    public MultiblockHeatExchanger(World world) {
        super(world);
    }

    @Override
    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        Block b = world.func_147439_a(x, y, z);
        if (b == BigReactors.blockExchangerInteriorPart) {
            CoordTriplet center = new CoordTriplet(x, y, z);
            int connectedAdjoiningBlocks = 0;
            int metadata = world.func_72805_g(x, y, z);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                CoordTriplet c = center.copy();
                c.translate(dir);
                Block adjacentBlock = world.func_147439_a(c.x, c.y, c.z);
                if (adjacentBlock != BigReactors.blockExchangerInteriorPart && adjacentBlock != BigReactors.blockExchangerPart) continue;
                int adjacentMetadata = world.func_72805_g(c.x, c.y, c.z);
                if ((adjacentBlock != BigReactors.blockExchangerInteriorPart || adjacentMetadata != metadata) && (adjacentBlock != BigReactors.blockExchangerPart || adjacentMetadata != 2)) continue;
                ++connectedAdjoiningBlocks;
            }
            if (connectedAdjoiningBlocks != 2) {
                throw new MultiblockValidationException(String.format("%d, %d, %d - Exchanger pipes must only connect to two other blocks", x, y, z));
            }
        } else {
            super.isBlockGoodForInterior(world, x, y, z);
        }
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof ITickableMultiblockPart) {
            this.m_TickableParts.add((ITickableMultiblockPart)((Object)newPart));
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        this.m_TickableParts.remove((Object)oldPart);
    }

    @Override
    protected void onMachineAssembled() {
    }

    @Override
    protected void onMachineRestored() {
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.setActive(false);
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 34;
    }

    @Override
    protected int getMaximumXSize() {
        return 15;
    }

    @Override
    protected int getMaximumZSize() {
        return 15;
    }

    @Override
    protected int getMaximumYSize() {
        return 32;
    }

    @Override
    protected void onAssimilate(MultiblockControllerBase assimilated) {
    }

    @Override
    protected void onAssimilated(MultiblockControllerBase assimilator) {
    }

    @Override
    protected boolean updateServer() {
        return false;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        data.func_74757_a("active", this.m_Active);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("active")) {
            this.setActive(data.func_74767_n("active"));
        }
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    public FluidTankInfo[] getTankInfo() {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{this.m_Condenser.getSingleTankInfo(0), this.m_Condenser.getSingleTankInfo(1), this.m_Evaporator.getSingleTankInfo(0), this.m_Evaporator.getSingleTankInfo(1)};
        return tankInfo;
    }

    @Override
    public boolean getActive() {
        return this.m_Active;
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.m_Active) {
            this.m_Active = active;
            this.markReferenceCoordDirty();
        }
    }

    public String getDebugInfo() {
        return "TODO";
    }
}

