/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.api.data.FluidStateData;
import erogenousbeef.bigreactors.api.registry.FluidStates;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.multiblock.helpers.FluidHelper;
import erogenousbeef.bigreactors.common.multiblock.helpers.ThermalHelper;
import erogenousbeef.bigreactors.utils.StaticUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CondenserContainer
extends FluidHelper {
    public static final int HOT = 0;
    public static final int COLD = 1;
    private static final String[] TANK_NAMES = new String[]{"hot", "cold"};
    private static final int NUM_TANKS = 2;
    private int m_CondensedLastTick = 0;
    private float m_RfTransferCoefficient = 0.0f;

    public CondenserContainer() {
        super(true);
    }

    public void setRfTransferCoefficient(float coeff) {
        this.m_RfTransferCoefficient = Math.max(0.0f, coeff);
    }

    @Override
    public int getNumberOfFluidTanks() {
        return 2;
    }

    @Override
    protected String[] getNBTTankNames() {
        return TANK_NAMES;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound destination) {
        super.writeToNBT(destination);
        return destination;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
    }

    public void merge(CondenserContainer other) {
        super.merge(other);
    }

    public float condense(ThermalHelper helper) {
        int hotFluidAmt = this.getFluidAmount(0);
        int condensableFluid = Math.min(this.getCapacity() - this.getFluidAmount(1), hotFluidAmt);
        if (condensableFluid <= 0) {
            return 0.0f;
        }
        Fluid hotFluid = this.getFluidType(0);
        if (hotFluid == null) {
            return 0.0f;
        }
        FluidStateData fsd = FluidStates.get(hotFluid);
        if (fsd == null) {
            BRLog.warning("Unknown fluid for condensing: %s", hotFluid.getName());
            return 0.0f;
        }
        if (!StaticUtils.Fluids.areFluidsEqual(fsd.getGas(), hotFluid)) {
            BRLog.warning("Fluid data not available for condensing %s", hotFluid.getName());
            return 0.0f;
        }
        Fluid coldFluid = this.getFluidType(1);
        if (coldFluid != null || !StaticUtils.Fluids.areFluidsEqual(fsd.getLiquid(), coldFluid)) {
            return 0.0f;
        }
        float hotFluidTemp = fsd.getBoilingPoint();
        float deltaTemp = hotFluidTemp - helper.getTemp();
        if (deltaTemp <= 0.0f) {
            return 0.0f;
        }
        float maximumTransferRfT = deltaTemp * this.m_RfTransferCoefficient;
        float availableRfT = fsd.getCondensationRf(condensableFluid);
        float transferRfT = Math.min(availableRfT, maximumTransferRfT);
        int unitsToCondense = (int)(transferRfT / (float)fsd.getHeatOfVaporization());
        transferRfT = fsd.getCondensationRf(unitsToCondense);
        if (unitsToCondense <= 0) {
            return 0.0f;
        }
        this.drain(0, unitsToCondense, true);
        this.fill(1, new FluidStack(coldFluid, unitsToCondense), true);
        helper.setRf(helper.getRf() + transferRfT);
        return transferRfT;
    }

    @Override
    protected boolean isFluidValidForStack(int stackIdx, Fluid fluid) {
        if (stackIdx == 0) {
            FluidStateData fsd = FluidStates.get(fluid);
            return fsd != null && StaticUtils.Fluids.areFluidsEqual(fluid, fsd.getGas());
        }
        return stackIdx == 1;
    }
}

