/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erogenousbeef.bigreactors.client.gui.GuiReactorRedstonePort;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.gui.container.ContainerBasic;
import erogenousbeef.core.multiblock.MultiblockControllerBase;
import erogenousbeef.core.multiblock.MultiblockValidationException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityReactorRedstonePort
extends TileEntityReactorPartBase
implements ITickableMultiblockPart {
    protected TileEntityReactorRedNetPort.CircuitType circuitType = TileEntityReactorRedNetPort.CircuitType.DISABLED;
    protected int outputLevel;
    protected boolean activeOnPulse;
    protected boolean greaterThan;
    protected int ticksSinceLastUpdate = 0;
    protected boolean isExternallyPowered = false;

    public boolean isRedstoneActive() {
        if (!this.isConnected()) {
            return false;
        }
        MultiblockReactor reactor = (MultiblockReactor)this.getMultiblockController();
        switch (this.circuitType) {
            case outputFuelTemperature: {
                return this.checkVariable((int)reactor.getFuelHeat());
            }
            case outputCasingTemperature: {
                return this.checkVariable((int)reactor.getReactorHeat());
            }
            case outputFuelMix: {
                return this.checkVariable((int)(reactor.getFuelRichness() * 100.0f));
            }
            case outputFuelAmount: {
                return this.checkVariable(reactor.getFuelAmount());
            }
            case outputWasteAmount: {
                return this.checkVariable(reactor.getWasteAmount());
            }
            case outputEnergyAmount: {
                return this.checkVariable(reactor.getEnergyStoredPercentage());
            }
            case DISABLED: {
                return false;
            }
        }
        return this.isExternallyPowered;
    }

    public boolean isInput() {
        return TileEntityReactorRedNetPort.isInput(this.circuitType);
    }

    public boolean isOutput() {
        return TileEntityReactorRedNetPort.isOutput(this.circuitType);
    }

    protected boolean checkVariable(int value) {
        if (this.greaterThan) {
            return value > this.getOutputLevel();
        }
        return value < this.getOutputLevel();
    }

    public void sendRedstoneUpdate() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            int md;
            if (this.isOutput()) {
                md = this.isRedstoneActive() ? 1 : 0;
            } else {
                int n = md = this.isExternallyPowered ? 1 : 0;
            }
            if (md != this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, md, 3);
            }
        }
    }

    public void onNeighborBlockChange(int x, int y, int z, Block neighborBlock) {
        if (!this.isConnected()) {
            return;
        }
        if (this.isInput()) {
            ForgeDirection out = this.getOutwardsDir();
            boolean nowPowered = this.isReceivingRedstonePowerFrom(this.field_145850_b, this.field_145851_c + out.offsetX, this.field_145848_d + out.offsetY, this.field_145849_e + out.offsetZ, out, neighborBlock);
            if (this.isExternallyPowered != nowPowered) {
                this.isExternallyPowered = nowPowered;
                this.onRedstoneInputUpdated();
                this.sendRedstoneUpdate();
            }
        } else {
            this.isExternallyPowered = false;
        }
    }

    protected void onRedstoneInputUpdated() {
        if (!this.isConnected()) {
            return;
        }
        MultiblockReactor reactor = (MultiblockReactor)this.getMultiblockController();
        switch (this.circuitType) {
            case inputActive: {
                if (this.isInputActiveOnPulse()) {
                    if (!this.isExternallyPowered) break;
                    reactor.setActive(!reactor.getActive());
                    break;
                }
                reactor.setActive(this.isExternallyPowered);
                break;
            }
            case inputSetControlRod: {
                if (this.isInputActiveOnPulse()) {
                    if (!this.isExternallyPowered) break;
                    if (this.shouldSetControlRodsInsteadOfChange()) {
                        reactor.setAllControlRodInsertionValues(this.outputLevel);
                        break;
                    }
                    reactor.changeAllControlRodInsertionValues((short)this.outputLevel);
                    break;
                }
                if (this.isExternallyPowered) {
                    reactor.setAllControlRodInsertionValues(this.getControlRodLevelWhileOn());
                    break;
                }
                reactor.setAllControlRodInsertionValues(this.getControlRodLevelWhileOff());
                break;
            }
            case inputEjectWaste: {
                if (!this.isExternallyPowered) break;
                reactor.ejectWaste(false, null);
                break;
            }
        }
    }

    public int getOutputLevel() {
        return this.outputLevel;
    }

    public int getControlRodLevelWhileOff() {
        return (this.outputLevel & 0xFF00) >> 8 & 0xFF;
    }

    public int getControlRodLevelWhileOn() {
        return this.outputLevel & 0xFF;
    }

    public static int packControlRodLevels(byte off, byte on) {
        return off << 8 & 0xFF00 | on & 0xFF;
    }

    public static int unpackControlRodLevelOn(int level) {
        return level & 0xFF;
    }

    public static int unpackControlRodLevelOff(int level) {
        return level % 65280 >> 8 & 0xFF;
    }

    public boolean isInputActiveOnPulse() {
        return this.activeOnPulse;
    }

    public void onReceiveUpdatePacket(int newType, int outputLevel, boolean greaterThan, boolean activeOnPulse) {
        this.circuitType = TileEntityReactorRedNetPort.CircuitType.values()[newType];
        this.outputLevel = outputLevel;
        this.greaterThan = greaterThan;
        this.activeOnPulse = activeOnPulse;
        if (TileEntityReactorRedstonePort.isAlwaysActiveOnPulse(this.circuitType)) {
            this.activeOnPulse = true;
        } else if (TileEntityReactorRedNetPort.isOutput(this.circuitType)) {
            this.activeOnPulse = false;
        }
        if (this.isInput()) {
            ForgeDirection out = this.getOutwardsDir();
            this.isExternallyPowered = this.isReceivingRedstonePowerFrom(this.field_145850_b, this.field_145851_c + out.offsetX, this.field_145848_d + out.offsetY, this.field_145849_e + out.offsetZ, out);
            if (!this.isInputActiveOnPulse()) {
                this.onRedstoneInputUpdated();
            }
        } else {
            this.isExternallyPowered = false;
        }
        this.sendRedstoneUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getGreaterThan() {
        return this.greaterThan;
    }

    public TileEntityReactorRedNetPort.CircuitType getCircuitType() {
        return this.circuitType;
    }

    private boolean shouldSetControlRodsInsteadOfChange() {
        return !this.greaterThan;
    }

    public void onRedNetUpdate(int powerLevel) {
        if (this.isInput()) {
            boolean wasPowered = this.isExternallyPowered;
            boolean bl = this.isExternallyPowered = powerLevel > 0;
            if (wasPowered != this.isExternallyPowered) {
                this.onRedstoneInputUpdated();
                this.sendRedstoneUpdate();
            }
        }
    }

    private boolean isReceivingRedstonePowerFrom(World world, int x, int y, int z, ForgeDirection dir) {
        Block block = world.func_147439_a(x, y, z);
        return this.isReceivingRedstonePowerFrom(world, x, y, z, dir, block);
    }

    private boolean isReceivingRedstonePowerFrom(World world, int x, int y, int z, ForgeDirection dir, Block neighborBlock) {
        if (neighborBlock == Blocks.field_150488_af) {
            return world.func_72805_g(x, y, z) > 0;
        }
        return world.func_94574_k(x, y, z, dir.ordinal()) || world.func_72879_k(x, y, z, dir.ordinal()) > 0;
    }

    public boolean shouldRefresh(Block oldID, Block newID, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldID != newID;
    }

    @Override
    public void onMultiblockServerTick() {
        if (!this.isConnected()) {
            return;
        }
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate < BigReactors.ticksPerRedstoneUpdate) {
            return;
        }
        if (this.isOutput()) {
            this.sendRedstoneUpdate();
        }
        this.ticksSinceLastUpdate = 0;
    }

    private void readData(NBTTagCompound data) {
        if (data.func_74764_b("circuitType")) {
            TileEntityReactorRedstonePort tileEntityReactorRedstonePort = this;
            this.circuitType = tileEntityReactorRedstonePort.circuitType.values()[data.func_74762_e("circuitType")];
        }
        if (data.func_74764_b("outputLevel")) {
            this.outputLevel = data.func_74762_e("outputLevel");
        }
        if (data.func_74764_b("greaterThan")) {
            this.greaterThan = data.func_74767_n("greaterThan");
        }
        if (data.func_74764_b("activeOnPulse")) {
            this.activeOnPulse = data.func_74767_n("activeOnPulse");
        }
    }

    private void writeData(NBTTagCompound data) {
        data.func_74768_a("circuitType", this.circuitType.ordinal());
        data.func_74768_a("outputLevel", this.outputLevel);
        data.func_74757_a("greaterThan", this.greaterThan);
        data.func_74757_a("activeOnPulse", this.activeOnPulse);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.readData(data);
        this.sendRedstoneUpdate();
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.writeData(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        super.decodeDescriptionPacket(data);
        this.readData(data);
    }

    @Override
    public void encodeDescriptionPacket(NBTTagCompound data) {
        super.encodeDescriptionPacket(data);
        this.writeData(data);
    }

    @Override
    public void isGoodForFrame() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Redstone ports may only be placed on a reactor's external side faces, not as part of the frame", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForSides() throws MultiblockValidationException {
    }

    @Override
    public void isGoodForTop() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Redstone ports may only be placed on a reactor's external side faces, not the top", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForBottom() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Redstone ports may only be placed on a reactor's external side faces, not the bottom", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        throw new MultiblockValidationException(String.format("%d, %d, %d - Redstone ports may not be placed in a reactor's interior", this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        this.sendRedstoneUpdate();
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this.sendRedstoneUpdate();
    }

    @Override
    public void onMachineActivated() {
        this.sendRedstoneUpdate();
    }

    @Override
    public void onMachineDeactivated() {
        this.sendRedstoneUpdate();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGuiElement(InventoryPlayer inventoryPlayer) {
        return new GuiReactorRedstonePort(new ContainerBasic(), this);
    }

    @Override
    public Object getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerBasic();
    }

    public static boolean isAlwaysActiveOnPulse(TileEntityReactorRedNetPort.CircuitType circuitType) {
        return circuitType == TileEntityReactorRedNetPort.CircuitType.inputEjectWaste;
    }
}

