/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.altarRecipeRegistry;

import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AltarRecipe {
    public int minTier;
    public int liquidRequired;
    public boolean canBeFilled;
    public int consumptionRate;
    public int drainRate;
    public ItemStack requiredItem;
    public ItemStack result;
    public boolean useTag;

    public AltarRecipe(ItemStack result, ItemStack requiredItem, int minTier, int liquidRequired, int consumptionRate, int drainRate, boolean canBeFilled) {
        this(result, requiredItem, minTier, liquidRequired, consumptionRate, drainRate, canBeFilled, false);
    }

    public AltarRecipe(ItemStack result, ItemStack requiredItem, int minTier, int liquidRequired, int consumptionRate, int drainRate, boolean canBeFilled, boolean useTag) {
        this.result = result;
        this.requiredItem = requiredItem;
        this.minTier = minTier;
        this.liquidRequired = liquidRequired;
        this.consumptionRate = consumptionRate;
        this.drainRate = drainRate;
        this.canBeFilled = canBeFilled;
        this.useTag = useTag;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack getRequiredItem() {
        return this.requiredItem;
    }

    public boolean doesRequiredItemMatch(ItemStack comparedStack, int tierCheck) {
        if (comparedStack == null || this.requiredItem == null) {
            return false;
        }
        return tierCheck >= this.minTier && this.requiredItem.func_77969_a(comparedStack) && (!this.useTag || this.areRequiredTagsEqual(comparedStack));
    }

    public boolean areRequiredTagsEqual(ItemStack comparedStack) {
        if (this.requiredItem.func_77942_o()) {
            NBTTagCompound tag = this.requiredItem.func_77978_p();
            if (!comparedStack.func_77942_o()) {
                return false;
            }
            NBTTagCompound comparedTag = comparedStack.func_77978_p();
            return this.areTagsEqual(tag, comparedTag);
        }
        return true;
    }

    protected boolean areTagsEqual(NBTTagCompound tag, NBTTagCompound comparedTag) {
        Set set = tag.func_150296_c();
        for (Object obj : set) {
            NBTBase comparedBaseTag;
            String str;
            NBTBase baseTag;
            if (!(obj instanceof String) || !((baseTag = comparedTag.func_74781_a(str = (String)obj)) instanceof NBTTagCompound ? (comparedBaseTag = comparedTag.func_74781_a(str)) instanceof NBTTagCompound && !this.areTagsEqual(tag, comparedTag) : baseTag != null && !baseTag.equals((Object)comparedTag.func_74781_a(str)))) continue;
            return false;
        }
        return true;
    }

    public int getMinTier() {
        return this.minTier;
    }

    public int getLiquidRequired() {
        return this.liquidRequired;
    }

    public int getConsumptionRate() {
        return this.consumptionRate;
    }

    public int getDrainRate() {
        return this.drainRate;
    }

    public boolean getCanBeFilled() {
        return this.canBeFilled;
    }
}

