/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BoundShovel
extends ItemSpade
implements IBindable {
    public float field_77864_a = 12.0f;
    public float field_77865_bY;
    private static IIcon activeIcon;
    private static IIcon passiveIcon;
    private int energyUsed;

    public BoundShovel() {
        super(AlchemicalWizardry.bloodBoundToolMaterial);
        this.field_77777_bU = 1;
        this.field_77864_a = 12.0f;
        this.field_77865_bY = 5.0f;
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.setEnergyUsed(5);
    }

    public void setEnergyUsed(int i) {
        this.energyUsed = i;
    }

    public int getEnergyUsed() {
        return this.energyUsed;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add("No, not that type of spade.");
        if (par1ItemStack.func_77978_p() != null) {
            if (par1ItemStack.func_77978_p().func_74767_n("isActive")) {
                par3List.add("Activated");
            } else {
                par3List.add("Deactivated");
            }
            if (!par1ItemStack.func_77978_p().func_74779_i("ownerName").equals("")) {
                par3List.add("Current owner: " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:BoundShovel_activated");
        activeIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundShovel_activated");
        passiveIcon = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.func_77978_p()).func_74767_n("isActive")) {
            return activeIcon;
        }
        return passiveIcon;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer);
        if (par3EntityPlayer.func_70093_af()) {
            this.setActivated(par1ItemStack, !this.getActivated(par1ItemStack));
            par1ItemStack.func_77978_p().func_74768_a("worldTimeDelay", (int)(par2World.func_72820_D() - 1L) % 200);
            return par1ItemStack;
        }
        if (!this.getActivated(par1ItemStack) || SpellHelper.isFakePlayer(par2World, par3EntityPlayer)) {
            return par1ItemStack;
        }
        if (par3EntityPlayer.func_70644_a(AlchemicalWizardry.customPotionInhibit)) {
            return par1ItemStack;
        }
        if (!EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, 10000)) {
            return par1ItemStack;
        }
        Vec3 blockVec = SpellHelper.getEntityBlockVector((Entity)par3EntityPlayer);
        int posX = (int)blockVec.field_72450_a;
        int posY = (int)blockVec.field_72448_b;
        int posZ = (int)blockVec.field_72449_c;
        boolean silkTouch = EnchantmentHelper.func_77502_d((EntityLivingBase)par3EntityPlayer);
        int fortuneLvl = EnchantmentHelper.func_77517_e((EntityLivingBase)par3EntityPlayer);
        for (int i = -5; i <= 5; ++i) {
            for (int j = 0; j <= 10; ++j) {
                for (int k = -5; k <= 5; ++k) {
                    float str;
                    Block block = par2World.func_147439_a(posX + i, posY + j, posZ + k);
                    int meta = par2World.func_72805_g(posX + i, posY + j, posZ + k);
                    if (block == null || !((str = this.func_150893_a(par1ItemStack, block)) > 1.1f) || !par2World.func_72962_a(par3EntityPlayer, posX + i, posY + j, posZ + k)) continue;
                    if (silkTouch && block.canSilkHarvest(par2World, par3EntityPlayer, posX + i, posY + j, posZ + k, meta)) {
                        ItemStack droppedItem = new ItemStack(block, 1, meta);
                        if (!par2World.field_72995_K) {
                            par2World.func_72838_d((Entity)new EntityItem(par2World, (double)posX, (double)((float)posY + par3EntityPlayer.func_70047_e()), (double)posZ, droppedItem));
                        }
                    } else {
                        ArrayList itemDropList = block.getDrops(par2World, posX + i, posY + j, posZ + k, meta, fortuneLvl);
                        if (itemDropList != null) {
                            for (ItemStack item : itemDropList) {
                                if (par2World.field_72995_K) continue;
                                par2World.func_72838_d((Entity)new EntityItem(par2World, (double)posX, (double)((float)posY + par3EntityPlayer.func_70047_e()), (double)posZ, item));
                            }
                        }
                    }
                    par2World.func_147468_f(posX + i, posY + j, posZ + k);
                }
            }
        }
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        if (par2World.func_72820_D() % 200L == (long)par1ItemStack.func_77978_p().func_74762_e("worldTimeDelay") && par1ItemStack.func_77978_p().func_74767_n("isActive") && !par3EntityPlayer.field_71075_bZ.field_75098_d && !EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, 20)) {
            this.setActivated(par1ItemStack, false);
        }
        par1ItemStack.func_77964_b(0);
    }

    public void setActivated(ItemStack par1ItemStack, boolean newActivated) {
        NBTTagCompound itemTag = par1ItemStack.func_77978_p();
        if (itemTag == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        itemTag.func_74757_a("isActive", newActivated);
    }

    public boolean getActivated(ItemStack par1ItemStack) {
        NBTTagCompound itemTag = par1ItemStack.func_77978_p();
        if (itemTag == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        return itemTag.func_74767_n("isActive");
    }

    public float func_150893_a(ItemStack par1ItemStack, Block par2Block) {
        if (!this.getActivated(par1ItemStack)) {
            return 0.0f;
        }
        return super.func_150893_a(par1ItemStack, par2Block);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        return this.getActivated(par1ItemStack);
    }

    public boolean onBlockDestroyed(ItemStack par1ItemStack, World par2World, int par3, int par4, int par5, int par6, EntityLivingBase par7EntityLivingBase) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 30;
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.field_77865_bY, 0));
        return multimap;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!this.getActivated(stack)) {
            return 0.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return this.field_77864_a;
        }
        return this.func_150893_a(stack, block);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return !this.getActivated(stack);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if ("shovel".equals(toolClass)) {
            return 5;
        }
        return 0;
    }
}

