/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.armour;

import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.items.armour.BoundArmour;
import WayofTime.alchemicalWizardry.common.omega.OmegaParadigm;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class OmegaArmour
extends BoundArmour {
    public OmegaParadigm paradigm;
    public Reagent reagent;
    ModelBiped model1 = null;
    ModelBiped model2 = null;
    ModelBiped model = null;

    public OmegaArmour(int armorType) {
        super(armorType);
    }

    public void setParadigm(OmegaParadigm paradigm) {
        this.paradigm = paradigm;
    }

    public void setReagent(Reagent reagent) {
        this.reagent = reagent;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (this.field_77881_a == 1) {
            this.paradigm.onUpdate(world, player, itemStack);
            int duration = this.getOmegaStallingDuration(itemStack);
            if (duration > 0) {
                this.setOmegaStallingDuration(itemStack, duration - 1);
            }
        }
    }

    public void revertArmour(EntityPlayer player, ItemStack itemStack) {
        ItemStack stack;
        player.field_71071_by.field_70460_b[3 - this.field_77881_a] = stack = this.getContainedArmourStack(itemStack);
    }

    public ItemStack getSubstituteStack(ItemStack boundStack) {
        ItemStack omegaStack = new ItemStack((Item)this);
        if (boundStack != null && boundStack.func_77942_o()) {
            NBTTagCompound tag = (NBTTagCompound)boundStack.func_77978_p().func_74737_b();
            omegaStack.func_77982_d(tag);
        }
        this.setContainedArmourStack(omegaStack, boundStack);
        SoulNetworkHandler.checkAndSetItemOwner(omegaStack, SoulNetworkHandler.getOwnerName(boundStack));
        return omegaStack;
    }

    public void setContainedArmourStack(ItemStack omegaStack, ItemStack boundStack) {
        if (omegaStack == null || boundStack == null) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        boundStack.func_77955_b(tag);
        NBTTagCompound omegaTag = omegaStack.func_77978_p();
        if (omegaTag == null) {
            omegaTag = new NBTTagCompound();
            omegaStack.func_77982_d(omegaTag);
        }
        omegaTag.func_74782_a("armour", (NBTBase)tag);
    }

    public ItemStack getContainedArmourStack(ItemStack omegaStack) {
        NBTTagCompound omegaTag = omegaStack.func_77978_p();
        if (omegaTag == null) {
            return null;
        }
        NBTTagCompound tag = omegaTag.func_74775_l("armour");
        ItemStack armourStack = ItemStack.func_77949_a((NBTTagCompound)tag);
        return armourStack;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "alchemicalwizardry:models/armor/OmegaWater.png";
    }

    public abstract ModelBiped getChestModel();

    public abstract ModelBiped getLegsModel();

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (tryComplexRendering) {
            int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
            if (this.model1 == null) {
                this.model1 = this.getChestModel();
            }
            if (this.model2 == null) {
                this.model2 = this.getLegsModel();
            }
            this.model = type == 1 || type == 3 || type == 0 ? this.model1 : this.model2;
            if (this.model != null) {
                this.model.field_78116_c.field_78806_j = type == 0;
                this.model.field_78114_d.field_78806_j = type == 0;
                this.model.field_78115_e.field_78806_j = type == 1 || type == 2;
                this.model.field_78113_g.field_78806_j = type == 1;
                this.model.field_78112_f.field_78806_j = type == 1;
                this.model.field_78124_i.field_78806_j = type == 2 || type == 3;
                this.model.field_78123_h.field_78806_j = type == 2 || type == 3;
                this.model.field_78117_n = entityLiving.func_70093_af();
                this.model.field_78093_q = entityLiving.func_70115_ae();
                this.model.field_78091_s = entityLiving.func_70631_g_();
                this.model.field_78118_o = false;
                int n = this.model.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
                if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                    EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                    if (enumaction == EnumAction.block) {
                        this.model.field_78120_m = 3;
                    } else if (enumaction == EnumAction.bow) {
                        this.model.field_78118_o = true;
                    }
                }
            }
            return this.model;
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot);
    }

    public void onOmegaKeyPressed(EntityPlayer player, ItemStack stack) {
        if (this.paradigm != null) {
            this.paradigm.onOmegaKeyPressed(player, stack);
        }
    }

    public void setOmegaStallingDuration(ItemStack stack, int duration) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a("OmegaStallDuration", duration);
    }

    public int getOmegaStallingDuration(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag.func_74762_e("OmegaStallDuration");
    }

    public boolean hasOmegaStalling(ItemStack stack) {
        return this.getOmegaStallingDuration(stack) > 0;
    }
}

