/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.block.BlockTeleposer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class RitualEffectMagnetic
extends RitualEffect {
    private static final int potentiaDrain = 10;
    private static final int terraeDrain = 10;
    private static final int orbisTerraeDrain = 10;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        boolean hasPotentia = this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, false);
        if (world.func_72820_D() % (long)(hasPotentia ? 10 : 40) != 0L) {
            return;
        }
        boolean hasTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 10, false);
        boolean hasOrbisTerrae = this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 10, false);
        int radius = this.getRadiusForReagents(hasTerrae, hasOrbisTerrae);
        if (currentEssence < this.getCostPerRefresh()) {
            SoulNetworkHandler.causeNauseaToPlayer(owner);
        } else {
            int k;
            int i;
            int j;
            int xRep = 0;
            int yRep = 0;
            int zRep = 0;
            boolean replace = false;
            for (j = 1; j <= 3; ++j) {
                for (i = -1; i <= 1; ++i) {
                    for (k = -1; k <= 1; ++k) {
                        if (replace || !world.func_147437_c(x + i, y + j, z + k)) continue;
                        xRep = x + i;
                        yRep = y + j;
                        zRep = z + k;
                        replace = true;
                    }
                }
            }
            if (replace) {
                for (j = y - 1; j >= 0; --j) {
                    for (i = -radius; i <= radius; ++i) {
                        for (k = -radius; k <= radius; ++k) {
                            String oreName;
                            ItemStack itemStack;
                            int id;
                            Block block = world.func_147439_a(x + i, j, z + k);
                            int meta = world.func_72805_g(x + i, j, z + k);
                            if (block == null || (id = OreDictionary.getOreID((ItemStack)(itemStack = new ItemStack(block, 1, meta)))) == -1 || !(oreName = OreDictionary.getOreName((int)id)).contains("ore")) continue;
                            BlockTeleposer.swapBlocks(this, world, world, x + i, j, z + k, xRep, yRep, zRep);
                            SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
                            if (hasPotentia) {
                                this.canDrainReagent(ritualStone, ReagentRegistry.potentiaReagent, 10, true);
                            }
                            if (hasTerrae) {
                                this.canDrainReagent(ritualStone, ReagentRegistry.terraeReagent, 10, true);
                            }
                            if (hasOrbisTerrae) {
                                this.canDrainReagent(ritualStone, ReagentRegistry.orbisTerraeReagent, 10, true);
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return 50;
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> magneticRitual = new ArrayList<RitualComponent>();
        magneticRitual.add(new RitualComponent(1, 0, 1, 3));
        magneticRitual.add(new RitualComponent(1, 0, -1, 3));
        magneticRitual.add(new RitualComponent(-1, 0, 1, 3));
        magneticRitual.add(new RitualComponent(-1, 0, -1, 3));
        magneticRitual.add(new RitualComponent(2, 1, 0, 3));
        magneticRitual.add(new RitualComponent(0, 1, 2, 3));
        magneticRitual.add(new RitualComponent(-2, 1, 0, 3));
        magneticRitual.add(new RitualComponent(0, 1, -2, 3));
        magneticRitual.add(new RitualComponent(2, 1, 2, 4));
        magneticRitual.add(new RitualComponent(2, 1, -2, 4));
        magneticRitual.add(new RitualComponent(-2, 1, 2, 4));
        magneticRitual.add(new RitualComponent(-2, 1, -2, 4));
        magneticRitual.add(new RitualComponent(2, 2, 0, 2));
        magneticRitual.add(new RitualComponent(0, 2, 2, 2));
        magneticRitual.add(new RitualComponent(-2, 2, 0, 2));
        magneticRitual.add(new RitualComponent(0, 2, -2, 2));
        return magneticRitual;
    }

    public int getRadiusForReagents(boolean hasTerrae, boolean hasOrbisTerrae) {
        if (hasTerrae) {
            if (hasOrbisTerrae) {
                return 31;
            }
            return 7;
        }
        if (hasOrbisTerrae) {
            return 12;
        }
        return 3;
    }
}

