/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.summoning.meteor;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorParadigmComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MeteorParadigm {
    public List<MeteorParadigmComponent> componentList = new ArrayList<MeteorParadigmComponent>();
    public ItemStack focusStack;
    public int radius;
    public static int maxChance = 1000;
    public static Random rand = new Random();

    public MeteorParadigm(ItemStack focusStack, int radius) {
        this.focusStack = focusStack;
        this.radius = radius;
    }

    public void parseStringArray(String[] oreArray) {
        int i = 0;
        while (i + 1 < oreArray.length) {
            String oreName = oreArray[i];
            int oreChance = Integer.parseInt(oreArray[i + 1]);
            MeteorParadigmComponent mpc = new MeteorParadigmComponent(oreName, oreChance);
            this.componentList.add(mpc);
            i += 2;
        }
    }

    public void createMeteorImpact(World world, int x, int y, int z, boolean[] flags) {
        boolean hasTerrae = false;
        boolean hasOrbisTerrae = false;
        boolean hasCrystallos = false;
        boolean hasIncendium = false;
        boolean hasTennebrae = false;
        if (flags != null && flags.length >= 5) {
            hasTerrae = flags[0];
            hasOrbisTerrae = flags[1];
            hasCrystallos = flags[2];
            hasIncendium = flags[3];
            hasTennebrae = flags[4];
        }
        int newRadius = this.radius;
        int chance = maxChance;
        if (hasOrbisTerrae) {
            newRadius += 2;
            chance += 200;
        } else if (hasTerrae) {
            ++newRadius;
            chance += 100;
        }
        world.func_72876_a(null, (double)x, (double)y, (double)z, (float)(newRadius * 4), AlchemicalWizardry.doMeteorsDestroyBlocks);
        float iceChance = hasCrystallos ? 1.0f : 0.0f;
        float soulChance = hasIncendium ? 1.0f : 0.0f;
        float obsidChance = hasTennebrae ? 1.0f : 0.0f;
        float totalChance = iceChance + soulChance + obsidChance;
        for (int i = -newRadius; i <= newRadius; ++i) {
            for (int j = -newRadius; j <= newRadius; ++j) {
                for (int k = -newRadius; k <= newRadius; ++k) {
                    if ((float)(i * i + j * j + k * k) >= ((float)newRadius + 0.5f) * ((float)newRadius + 0.5f) || !world.func_147437_c(x + i, y + j, z + k)) continue;
                    int randNum = world.field_73012_v.nextInt(chance);
                    boolean hasPlacedBlock = false;
                    for (MeteorParadigmComponent mpc : this.componentList) {
                        if (mpc == null || !mpc.isValidBlockParadigm() || (randNum -= mpc.getChance()) >= 0) continue;
                        ItemStack blockStack = mpc.getValidBlockParadigm();
                        world.func_147465_d(x + i, y + j, z + k, Block.func_149729_e((int)Item.func_150891_b((Item)blockStack.func_77973_b())), blockStack.func_77960_j(), 3);
                        hasPlacedBlock = true;
                        break;
                    }
                    if (hasPlacedBlock) continue;
                    float randChance = rand.nextFloat() * totalChance;
                    if (randChance < iceChance) {
                        world.func_147465_d(x + i, y + j, z + k, Blocks.field_150432_aD, 0, 3);
                        continue;
                    }
                    if ((randChance -= iceChance) < soulChance) {
                        switch (rand.nextInt(3)) {
                            case 0: {
                                world.func_147465_d(x + i, y + j, z + k, Blocks.field_150425_aM, 0, 3);
                                break;
                            }
                            case 1: {
                                world.func_147465_d(x + i, y + j, z + k, Blocks.field_150426_aN, 0, 3);
                                break;
                            }
                            case 2: {
                                world.func_147465_d(x + i, y + j, z + k, Blocks.field_150424_aL, 0, 3);
                            }
                        }
                        continue;
                    }
                    if ((randChance -= soulChance) < obsidChance) {
                        world.func_147465_d(x + i, y + j, z + k, Blocks.field_150343_Z, 0, 3);
                        continue;
                    }
                    randChance -= obsidChance;
                    world.func_147465_d(x + i, y + j, z + k, Blocks.field_150348_b, 0, 3);
                }
            }
        }
    }
}

