/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import vazkii.botania.common.core.handler.SheddingHandler;

public final class ConfigHandler {
    public static Configuration config;
    private static final String CATEGORY_POTIONS = "potions";
    public static boolean useShaders;
    public static boolean lexiconRotatingItems;
    public static boolean lexiconJustifiedText;
    public static boolean subtlePowerSystem;
    public static boolean staticWandBeam;
    public static boolean boundBlockWireframe;
    public static boolean lexicon3dModel;
    public static boolean oldPylonModel;
    public static double flowerParticleFrequency;
    public static boolean blockBreakParticles;
    public static boolean blockBreakParticlesTool;
    public static boolean elfPortalParticlesEnabled;
    public static boolean chargingAnimationEnabled;
    public static boolean useVanillaParticleLimiter;
    public static boolean silentSpreaders;
    public static boolean renderBaubles;
    public static boolean altFlowerTextures;
    public static boolean matrixMode;
    public static boolean referencesEnabled;
    public static boolean versionCheckEnabled;
    public static int spreaderPositionShift;
    public static boolean flowerForceCheck;
    public static boolean enderPickpocketEnabled;
    public static int hardcorePassiveGeneration;
    public static boolean fallenKanadeEnabled;
    public static boolean darkQuartzEnabled;
    public static boolean enchanterEnabled;
    public static boolean fluxfieldEnabled;
    public static int flowerQuantity;
    public static int flowerDensity;
    public static int mushroomQuantity;
    public static int potionIDSoulCross;
    public static int potionIDFeatherfeet;
    public static int potionIDEmptiness;
    public static int potionIDBloodthirst;
    public static int potionIDAllure;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.load();
        FMLCommonHandler.instance().bus().register((Object)new ChangeListener());
    }

    public static void load() {
        String desc = "Set this to false to disable the use of shaders for some of the mod's renders.";
        useShaders = ConfigHandler.loadPropBool("shaders.enabled", desc, useShaders);
        desc = "Set this to false to disable the rotating items in the petal and rune entries in the Lexica Botania.";
        lexiconRotatingItems = ConfigHandler.loadPropBool("lexicon.enable.rotatingItems", desc, lexiconRotatingItems);
        desc = "Set this to true to enable justified text in the Lexica Botania's text pages.";
        lexiconJustifiedText = ConfigHandler.loadPropBool("lexicon.enable.justifiedText", desc, lexiconJustifiedText);
        desc = "Set this to true to set the power system's particles to be a lot more subtle. Good for low-end systems, if the particles are causing lag.";
        subtlePowerSystem = ConfigHandler.loadPropBool("powerSystem.subtle", desc, subtlePowerSystem);
        desc = "Set this to true to use a static wand beam that shows every single position of the burst, similar to the way it used to work on old Botania versions. Warning: Disabled by default because it may be laggy.";
        staticWandBeam = ConfigHandler.loadPropBool("wandBeam.static", desc, staticWandBeam);
        desc = "Set this to false to disable the wireframe when looking a block bound to something (spreaders, flowers, etc).";
        boundBlockWireframe = ConfigHandler.loadPropBool("boundBlock.wireframe.enabled", desc, boundBlockWireframe);
        desc = "Set this to false to disable the animated 3D render for the Lexica Botania.";
        lexicon3dModel = ConfigHandler.loadPropBool("lexicon.render.3D", desc, lexicon3dModel);
        desc = "Set this to true to use the old (non-.obj, pre beta18) pylon model";
        oldPylonModel = ConfigHandler.loadPropBool("pylonModel.old", desc, oldPylonModel);
        desc = "The frequency in which particles spawn from normal (worldgen) mystical flowers";
        flowerParticleFrequency = ConfigHandler.loadPropDouble("flowerParticles.frequency", desc, flowerParticleFrequency);
        desc = "Set this to false to remove the block breaking particles from the flowers and other items in the mod.";
        blockBreakParticles = ConfigHandler.loadPropBool("blockBreakingParticles.enabled", desc, blockBreakParticles);
        desc = "Set this to false to remove the block breaking particles from the Mana Shatterer, as there can be a good amount in higher levels.";
        blockBreakParticlesTool = ConfigHandler.loadPropBool("blockBreakingParticlesTool.enabled", desc, blockBreakParticlesTool);
        desc = "Set this to false to disable the particles in the elven portal.";
        elfPortalParticlesEnabled = ConfigHandler.loadPropBool("elfPortal.particles.enabled", desc, elfPortalParticlesEnabled);
        desc = "Set this to false to disable the animation when an item is charging on top of a mana pool.";
        chargingAnimationEnabled = ConfigHandler.loadPropBool("chargeAnimation.enabled", desc, chargingAnimationEnabled);
        desc = "Set this to false to always display all particles regardless of the \"Particles\" setting in the Vanilla options menu.";
        useVanillaParticleLimiter = ConfigHandler.loadPropBool("vanillaParticleConfig.enabled", desc, useVanillaParticleLimiter);
        desc = "Set this to true to disable the mana spreader shooting sound.";
        silentSpreaders = ConfigHandler.loadPropBool("manaSpreaders.silent", desc, silentSpreaders);
        desc = "Set this to false to disable rendering of baubles in the player.";
        renderBaubles = ConfigHandler.loadPropBool("baubleRender.enabled", desc, renderBaubles);
        desc = "Set this to true to use alternate flower textures by Futureazoo, not all flowers are textured. http://redd.it/2b3o3f";
        altFlowerTextures = ConfigHandler.loadPropBool("flowerTextures.alt", desc, altFlowerTextures);
        desc = "Set this to true if you are the chosen one. For lovers of glitch art and just general mad people.";
        matrixMode = ConfigHandler.loadPropBool("matrixMode.enabled", desc, matrixMode);
        desc = "Set this to false to disable the references in the flower tooltips. (You monster D:)";
        referencesEnabled = ConfigHandler.loadPropBool("references.enabled", desc, referencesEnabled);
        desc = "Set this to false to disable checking and alerting when new Botania versions come out.";
        versionCheckEnabled = ConfigHandler.loadPropBool("versionChecking.enabled", desc, versionCheckEnabled);
        desc = "Do not ever touch this value if not asked to. Possible symptoms of doing so include your head turning backwards, the appearance of Titans near the walls or you being trapped in a game of Sword Art Online.";
        spreaderPositionShift = ConfigHandler.loadPropInt("spreader.posShift", desc, spreaderPositionShift);
        desc = "Turn this off ONLY IF you're on an extremely large world with an exaggerated count of Mana Spreaders/Mana Pools and are experiencing TPS lag. This toggles whether flowers are strict with their checking for connecting to pools/spreaders or just check whenever possible.";
        flowerForceCheck = ConfigHandler.loadPropBool("flower.forceCheck", desc, flowerForceCheck);
        desc = "Set to false to disable the ability for the Hand of Ender to pickpocket other players' ender chests.";
        enderPickpocketEnabled = ConfigHandler.loadPropBool("enderPickpocket.enabled", desc, enderPickpocketEnabled);
        desc = "Set to anything other than -1 for passive generation flowers (dayblooms, nightshades, hydroangeas) to die after a specific amount of ticks. 24000 is 2 Minecraft days, that's a recomended value.";
        hardcorePassiveGeneration = ConfigHandler.loadPropInt("passiveWither.time", desc, hardcorePassiveGeneration);
        desc = "Set this to false to disable the Fallen Kanade flower (gives Regeneration). This config option is here for those using Blood Magic. Note: Turning this off will not remove ones already in the world, it'll simply prevent the crafting.";
        fallenKanadeEnabled = ConfigHandler.loadPropBool("fallenKanade.enabled", desc, fallenKanadeEnabled);
        desc = "Set this to false to disable the Smokey Quartz blocks. This config option is here for those using Thaumic Tinkerer";
        darkQuartzEnabled = ConfigHandler.loadPropBool("darkQuartz.enabled", desc, darkQuartzEnabled);
        desc = "Set this to false to disable the Mana Enchanter. Since some people find it OP or something. This only disables the entry and creation. Old ones that are already in the world will stay.";
        enchanterEnabled = ConfigHandler.loadPropBool("manaEnchanter.enabled", desc, enchanterEnabled);
        desc = "Set this to false to disable the Mana Fluxfield (generates RF from mana). This only disables the entry and creation. Old ones that are already in the world will stay.";
        fluxfieldEnabled = ConfigHandler.loadPropBool("manaFluxfield.enabled", desc, fluxfieldEnabled);
        desc = "The quantity of Botania flower patches to generate in the world, defaults to 2, the lower the number the less patches generate.";
        flowerQuantity = ConfigHandler.loadPropInt("worldgen.flower.quantity", desc, flowerQuantity);
        desc = "The density of each Botania flower patch generated, defaults to 16, the lower the number, the less each patch will have.";
        flowerDensity = ConfigHandler.loadPropInt("worldgen.flower.density", desc, flowerDensity);
        desc = "The quantity of Botania mushrooms to generate underground, in the world, defaults to 40, the lower the number the less patches generate.";
        mushroomQuantity = ConfigHandler.loadPropInt("worldgen.mushroom.quantity", desc, mushroomQuantity);
        potionIDSoulCross = ConfigHandler.loadPropPotionId("soulCross", potionIDSoulCross);
        potionIDFeatherfeet = ConfigHandler.loadPropPotionId("featherFeet", potionIDFeatherfeet);
        potionIDEmptiness = ConfigHandler.loadPropPotionId("emptiness", potionIDEmptiness);
        potionIDBloodthirst = ConfigHandler.loadPropPotionId("bloodthirst", potionIDBloodthirst);
        potionIDAllure = ConfigHandler.loadPropPotionId("allure", potionIDAllure);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void loadPostInit() {
        SheddingHandler.loadFromConfig(config);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadPropInt(String propName, String desc, int default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getInt(default_);
    }

    public static double loadPropDouble(String propName, String desc, double default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getDouble(default_);
    }

    public static boolean loadPropBool(String propName, String desc, boolean default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getBoolean(default_);
    }

    public static int loadPropPotionId(String propName, int default_) {
        Property prop = config.get(CATEGORY_POTIONS, propName, default_);
        int val = prop.getInt(default_);
        if (val > 127) {
            val = default_;
            prop.set(default_);
        }
        return val;
    }

    static {
        useShaders = true;
        lexiconRotatingItems = true;
        lexiconJustifiedText = false;
        subtlePowerSystem = false;
        staticWandBeam = false;
        boundBlockWireframe = true;
        lexicon3dModel = true;
        oldPylonModel = false;
        flowerParticleFrequency = 0.75;
        blockBreakParticles = true;
        blockBreakParticlesTool = true;
        elfPortalParticlesEnabled = true;
        chargingAnimationEnabled = true;
        useVanillaParticleLimiter = true;
        silentSpreaders = false;
        renderBaubles = true;
        altFlowerTextures = false;
        matrixMode = false;
        referencesEnabled = true;
        versionCheckEnabled = true;
        spreaderPositionShift = 1;
        flowerForceCheck = true;
        enderPickpocketEnabled = true;
        hardcorePassiveGeneration = -1;
        fallenKanadeEnabled = true;
        darkQuartzEnabled = true;
        enchanterEnabled = true;
        fluxfieldEnabled = true;
        flowerQuantity = 2;
        flowerDensity = 16;
        mushroomQuantity = 40;
        potionIDSoulCross = 91;
        potionIDFeatherfeet = 92;
        potionIDEmptiness = 93;
        potionIDBloodthirst = 94;
        potionIDAllure = 95;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.modID.equals("Botania")) {
                ConfigHandler.load();
            }
        }
    }
}

