/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import vazkii.botania.api.item.ICosmeticAttachable;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.item.ItemMod;

public abstract class ItemBauble
extends ItemMod
implements IBauble,
ICosmeticAttachable {
    private static final String TAG_HASHCODE = "playerHashcode";
    private static final String TAG_COSMETIC_ITEM = "cosmeticItem";

    public ItemBauble(String name) {
        this.func_77625_d(1);
        this.func_77655_b(name);
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EntityDoppleganger.isTruePlayer((Entity)par3EntityPlayer)) {
            return par1ItemStack;
        }
        InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)par3EntityPlayer);
        for (int i = 0; i < baubles.func_70302_i_(); ++i) {
            ItemStack stackInSlot;
            if (!baubles.func_94041_b(i, par1ItemStack) || (stackInSlot = baubles.func_70301_a(i)) != null && !((IBauble)stackInSlot.func_77973_b()).canUnequip(stackInSlot, (EntityLivingBase)par3EntityPlayer)) continue;
            if (!par2World.field_72995_K) {
                baubles.func_70299_a(i, par1ItemStack.func_77946_l());
                if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
                    par3EntityPlayer.field_71071_by.func_70299_a(par3EntityPlayer.field_71071_by.field_70461_c, null);
                }
            }
            this.onEquipped(par1ItemStack, (EntityLivingBase)par3EntityPlayer);
            if (stackInSlot == null) break;
            ((IBauble)stackInSlot.func_77973_b()).onUnequipped(stackInSlot, (EntityLivingBase)par3EntityPlayer);
            return stackInSlot.func_77946_l();
        }
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (GuiScreen.func_146272_n()) {
            this.addHiddenTooltip(par1ItemStack, par2EntityPlayer, par3List, par4);
        } else {
            this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.shiftinfo"), par3List);
        }
    }

    public void addHiddenTooltip(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        ItemStack cosmetic;
        BaubleType type = this.getBaubleType(par1ItemStack);
        this.addStringToTooltip(StatCollector.func_74838_a((String)("botania.baubletype." + type.name().toLowerCase())), par3List);
        String key = RenderHelper.getKeyDisplayString("Baubles Inventory");
        if (key != null) {
            this.addStringToTooltip(StatCollector.func_74838_a((String)"botania.baubletooltip").replaceAll("%key%", key), par3List);
        }
        if ((cosmetic = this.getCosmeticItem(par1ItemStack)) != null) {
            this.addStringToTooltip(String.format(StatCollector.func_74838_a((String)"botaniamisc.hasCosmetic"), cosmetic.func_82833_r()), par3List);
        }
    }

    void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public boolean canEquip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (this.getLastPlayerHashcode(stack) != player.hashCode()) {
            this.onEquippedOrLoadedIntoWorld(stack, player);
            this.setLastPlayerHashcode(stack, player.hashCode());
        }
    }

    public void onEquipped(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72956_a((Entity)player, "botania:equipBauble", 0.1f, 1.3f);
        }
        if (player instanceof EntityPlayer) {
            ((EntityPlayer)player).func_71064_a((StatBase)ModAchievements.baubleWear, 1);
        }
        this.onEquippedOrLoadedIntoWorld(stack, player);
        this.setLastPlayerHashcode(stack, player.hashCode());
    }

    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
    }

    @Override
    public ItemStack getCosmeticItem(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_COSMETIC_ITEM, true);
        if (cmp == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)cmp);
    }

    @Override
    public void setCosmeticItem(ItemStack stack, ItemStack cosmetic) {
        NBTTagCompound cmp = new NBTTagCompound();
        if (cosmetic != null) {
            cosmetic.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_COSMETIC_ITEM, cmp);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getContainerItem(stack) != null;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return this.getCosmeticItem(itemStack);
    }

    public boolean func_77630_h(ItemStack p_77630_1_) {
        return false;
    }

    public int getLastPlayerHashcode(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_HASHCODE, 0);
    }

    public void setLastPlayerHashcode(ItemStack stack, int hash) {
        ItemNBTHelper.setInt(stack, TAG_HASHCODE, hash);
    }
}

