/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.power;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.mj.BatteryObject;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.IBatteryProvider;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.power.IPowerReceptor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public final class PowerHandler
implements IBatteryProvider {
    public static final PerditionCalculator DEFAULT_PERDITION = new PerditionCalculator();
    public static final double ROLLING_AVERAGE_WEIGHT = 100.0;
    public static final double ROLLING_AVERAGE_NUMERATOR = 99.0;
    public static final double ROLLING_AVERAGE_DENOMINATOR = 0.01;
    public final int[] powerSources = new int[6];
    public final IPowerReceptor receptor;
    private double activationEnergy;
    private final SafeTimeTracker doWorkTracker = new SafeTimeTracker(1L);
    private final SafeTimeTracker sourcesTracker = new SafeTimeTracker(1L);
    private final SafeTimeTracker perditionTracker = new SafeTimeTracker(1L);
    private PerditionCalculator perdition;
    private final PowerReceiver receiver;
    private final Type type;
    private IBatteryObject battery;
    private double averageLostPower = 0.0;
    private double averageReceivedPower = 0.0;
    private double averageUsedPower = 0.0;

    public PowerHandler(IPowerReceptor receptor, Type type) {
        this(receptor, type, null);
    }

    public PowerHandler(IPowerReceptor receptor, Type type, Object battery) {
        this.receptor = receptor;
        this.type = type;
        this.receiver = new PowerReceiver();
        this.perdition = DEFAULT_PERDITION;
        this.battery = battery instanceof IBatteryObject ? (BatteryObject)battery : (battery != null ? MjAPI.getMjBattery(battery) : MjAPI.getMjBattery(new AnonymousBattery()));
    }

    public PowerReceiver getPowerReceiver() {
        return this.receiver;
    }

    public double getMinEnergyReceived() {
        return this.battery.minimumConsumption();
    }

    public double getMaxEnergyReceived() {
        return this.battery.getEnergyRequested();
    }

    public double getMaxEnergyStored() {
        return this.battery.maxCapacity();
    }

    public double getActivationEnergy() {
        return this.activationEnergy;
    }

    public double getEnergyStored() {
        return this.battery.getEnergyStored();
    }

    @Override
    public IBatteryObject getMjBattery(String kind) {
        return this.battery.kind().equals(kind) ? this.battery : null;
    }

    public void configure(double minEnergyReceived, double maxEnergyReceived, double activationEnergy, double maxStoredEnergy) {
        double localMaxEnergyReceived = maxEnergyReceived;
        if (minEnergyReceived > localMaxEnergyReceived) {
            localMaxEnergyReceived = minEnergyReceived;
        }
        this.activationEnergy = activationEnergy;
        this.battery.reconfigure(maxStoredEnergy, localMaxEnergyReceived, minEnergyReceived);
    }

    public void configurePowerPerdition(int powerLoss, int powerLossRegularity) {
        if (powerLoss == 0 || powerLossRegularity == 0) {
            this.perdition = new PerditionCalculator(0.0);
            return;
        }
        this.perdition = new PerditionCalculator((float)powerLoss / (float)powerLossRegularity);
    }

    public void setPerdition(PerditionCalculator perdition) {
        this.perdition = perdition == null ? DEFAULT_PERDITION : perdition;
    }

    public PerditionCalculator getPerdition() {
        if (this.perdition == null) {
            return DEFAULT_PERDITION;
        }
        return this.perdition;
    }

    public void update() {
        this.applyPerdition();
        this.applyWork();
        this.validateEnergy();
    }

    private void applyPerdition() {
        double energyStored = this.getEnergyStored();
        if (this.perditionTracker.markTimeIfDelay(this.receptor.getWorld()) && energyStored > 0.0) {
            double prev = energyStored;
            double newEnergy = this.getPerdition().applyPerdition(this, energyStored, this.perditionTracker.durationOfLastDelay());
            if (newEnergy == 0.0 || newEnergy < energyStored) {
                energyStored = newEnergy;
                this.battery.setEnergyStored(energyStored);
            } else {
                energyStored = DEFAULT_PERDITION.applyPerdition(this, energyStored, this.perditionTracker.durationOfLastDelay());
                this.battery.setEnergyStored(energyStored);
            }
            this.validateEnergy();
            this.averageLostPower = (this.averageLostPower * 99.0 + (prev - energyStored)) * 0.01;
        }
    }

    private void applyWork() {
        if (this.getEnergyStored() >= this.activationEnergy && this.doWorkTracker.markTimeIfDelay(this.receptor.getWorld())) {
            this.receptor.doWork(this);
        }
    }

    private void updateSources(ForgeDirection source) {
        if (this.sourcesTracker.markTimeIfDelay(this.receptor.getWorld())) {
            for (int i = 0; i < 6; ++i) {
                int n = i;
                this.powerSources[n] = (int)((long)this.powerSources[n] - this.sourcesTracker.durationOfLastDelay());
                if (this.powerSources[i] >= 0) continue;
                this.powerSources[i] = 0;
            }
        }
        if (source != null) {
            this.powerSources[source.ordinal()] = 10;
        }
    }

    public double useEnergy(double min, double max, boolean doUse) {
        this.applyPerdition();
        double result = 0.0;
        double energyStored = this.getEnergyStored();
        if (energyStored >= min) {
            if (energyStored <= max) {
                result = energyStored;
                if (doUse) {
                    energyStored = 0.0;
                }
            } else {
                result = max;
                if (doUse) {
                    energyStored -= max;
                }
            }
        }
        if (energyStored != this.getEnergyStored()) {
            this.battery.setEnergyStored(energyStored);
        }
        this.validateEnergy();
        if (doUse) {
            this.averageUsedPower = (this.averageUsedPower * 99.0 + result) * 0.01;
        }
        return result;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.readFromNBT(data, "powerProvider");
    }

    public void readFromNBT(NBTTagCompound data, String tag) {
        NBTTagCompound nbt = data.func_74775_l(tag);
        this.battery.setEnergyStored(nbt.func_74769_h("energyStored"));
    }

    public void writeToNBT(NBTTagCompound data) {
        this.writeToNBT(data, "powerProvider");
    }

    public void writeToNBT(NBTTagCompound data, String tag) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("energyStored", this.battery.getEnergyStored());
        data.func_74782_a(tag, (NBTBase)nbt);
    }

    public double addEnergy(double quantity) {
        double used = this.battery.addEnergy(quantity);
        this.applyPerdition();
        return used;
    }

    public void setEnergy(double quantity) {
        this.battery.setEnergyStored(quantity);
        this.validateEnergy();
    }

    public boolean isPowerSource(ForgeDirection from) {
        return this.powerSources[from.ordinal()] != 0;
    }

    private void validateEnergy() {
        double energyStored = this.getEnergyStored();
        double maxEnergyStored = this.getMaxEnergyStored();
        if (energyStored < 0.0) {
            energyStored = 0.0;
        }
        if (energyStored > maxEnergyStored) {
            energyStored = maxEnergyStored;
        }
        if (energyStored != this.battery.getEnergyStored()) {
            this.battery.setEnergyStored(energyStored);
        }
    }

    private static class AnonymousBattery {
        @MjBattery
        public double mjStored;

        private AnonymousBattery() {
        }
    }

    public final class PowerReceiver {
        private PowerReceiver() {
        }

        public double getMinEnergyReceived() {
            return PowerHandler.this.getMinEnergyReceived();
        }

        public double getMaxEnergyReceived() {
            return PowerHandler.this.getMaxEnergyReceived();
        }

        public double getMaxEnergyStored() {
            return PowerHandler.this.getMaxEnergyStored();
        }

        public double getActivationEnergy() {
            return PowerHandler.this.activationEnergy;
        }

        public double getEnergyStored() {
            return PowerHandler.this.getEnergyStored();
        }

        public double getAveragePowerReceived() {
            return PowerHandler.this.averageReceivedPower;
        }

        public double getAveragePowerUsed() {
            return PowerHandler.this.averageUsedPower;
        }

        public double getAveragePowerLost() {
            return PowerHandler.this.averageLostPower;
        }

        public Type getType() {
            return PowerHandler.this.type;
        }

        public void update() {
            PowerHandler.this.update();
        }

        public double powerRequest() {
            this.update();
            return PowerHandler.this.battery.getEnergyRequested();
        }

        public double receiveEnergy(Type source, double quantity, ForgeDirection from) {
            double used = quantity;
            if (source == Type.ENGINE) {
                if (used < this.getMinEnergyReceived()) {
                    return 0.0;
                }
                if (used > this.getMaxEnergyReceived()) {
                    used = this.getMaxEnergyReceived();
                }
            }
            PowerHandler.this.updateSources(from);
            used -= used * PowerHandler.this.getPerdition().getTaxPercent();
            used = PowerHandler.this.addEnergy(used);
            PowerHandler.this.applyWork();
            if (source == Type.ENGINE && PowerHandler.this.type.eatsEngineExcess()) {
                used = Math.min(quantity, this.getMaxEnergyReceived());
            }
            PowerHandler.this.averageReceivedPower = (PowerHandler.this.averageReceivedPower * 99.0 + used) * 0.01;
            return used;
        }
    }

    public static class PerditionCalculator {
        public static final float DEFAULT_POWERLOSS = 1.0f;
        public static final float MIN_POWERLOSS = 0.01f;
        private final double powerLoss;

        public PerditionCalculator() {
            this.powerLoss = 1.0;
        }

        public PerditionCalculator(double powerLoss) {
            this.powerLoss = powerLoss < (double)0.01f ? (double)0.01f : powerLoss;
        }

        public double applyPerdition(PowerHandler powerHandler, double current, long ticksPassed) {
            double newPower = current - this.powerLoss * (double)ticksPassed;
            if (newPower < 0.0) {
                newPower = 0.0;
            }
            return newPower;
        }

        public double getTaxPercent() {
            return 0.0;
        }
    }

    public static enum Type {
        ENGINE,
        GATE,
        MACHINE,
        PIPE,
        STORAGE;


        public boolean canReceiveFromPipes() {
            switch (this) {
                case MACHINE: 
                case STORAGE: {
                    return true;
                }
            }
            return false;
        }

        public boolean eatsEngineExcess() {
            switch (this) {
                case MACHINE: 
                case STORAGE: {
                    return true;
                }
            }
            return false;
        }
    }
}

