/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.filler;

import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.filler.IFillerRegistry;
import buildcraft.builders.filler.pattern.FillerPattern;
import buildcraft.builders.triggers.ActionFiller;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FillerRegistry
implements IFillerRegistry {
    private TreeMap<String, IFillerPattern> patterns = new TreeMap();
    private Set<ActionFiller> patternActions = new HashSet<ActionFiller>();

    @Override
    public void addPattern(IFillerPattern pattern) {
        this.patterns.put(pattern.getUniqueTag(), pattern);
        this.patternActions.add(new ActionFiller((FillerPattern)pattern));
    }

    @Override
    public IFillerPattern getPattern(String patternName) {
        return this.patterns.get(patternName);
    }

    @Override
    public IFillerPattern getNextPattern(IFillerPattern currentPattern) {
        Map.Entry<String, IFillerPattern> pattern = this.patterns.higherEntry(currentPattern.getUniqueTag());
        if (pattern == null) {
            pattern = this.patterns.firstEntry();
        }
        return pattern.getValue();
    }

    @Override
    public IFillerPattern getPreviousPattern(IFillerPattern currentPattern) {
        Map.Entry<String, IFillerPattern> pattern = this.patterns.lowerEntry(currentPattern.getUniqueTag());
        if (pattern == null) {
            pattern = this.patterns.lastEntry();
        }
        return pattern.getValue();
    }

    public Set<ActionFiller> getActions() {
        return this.patternActions;
    }
}

