/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.BCLog;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.blueprints.Template;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class BlueprintBase {
    public SchematicBlockBase[][][] contents;
    public int anchorX;
    public int anchorY;
    public int anchorZ;
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    public BlueprintId id = new BlueprintId();
    public String author;
    public boolean rotate = true;
    public boolean excavate = true;
    public BuildingPermission buildingPermission = BuildingPermission.ALL;
    public boolean isComplete = true;
    protected MappingRegistry mapping = new MappingRegistry();
    private String version = "";
    private ComputeDataThread computeData;
    private byte[] data;

    public BlueprintBase() {
    }

    public BlueprintBase(int sizeX, int sizeY, int sizeZ) {
        this.contents = new SchematicBlockBase[sizeX][sizeY][sizeZ];
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.anchorX = 0;
        this.anchorY = 0;
        this.anchorZ = 0;
    }

    public void translateToBlueprint(Translation transform) {
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    if (this.contents[x][y][z] == null) continue;
                    this.contents[x][y][z].translateToBlueprint(transform);
                }
            }
        }
    }

    public void translateToWorld(Translation transform) {
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    if (this.contents[x][y][z] == null) continue;
                    this.contents[x][y][z].translateToWorld(transform);
                }
            }
        }
    }

    public void rotateLeft(BptContext context) {
        SchematicBlockBase[][][] newContents = new SchematicBlockBase[this.sizeZ][this.sizeY][this.sizeX];
        for (int x = 0; x < this.sizeZ; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeX; ++z) {
                    newContents[x][y][z] = this.contents[z][y][this.sizeZ - 1 - x];
                    if (newContents[x][y][z] == null) continue;
                    try {
                        newContents[x][y][z].rotateLeft(context);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        BCLog.logger.throwing("BptBase", "rotateLeft", t);
                    }
                }
            }
        }
        int newAnchorX = this.sizeZ - 1 - this.anchorZ;
        int newAnchorY = this.anchorY;
        int newAnchorZ = this.anchorX;
        this.contents = newContents;
        int tmp = this.sizeX;
        this.sizeX = this.sizeZ;
        this.sizeZ = tmp;
        this.anchorX = newAnchorX;
        this.anchorY = newAnchorY;
        this.anchorZ = newAnchorZ;
        context.rotateLeft();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("version", "6.0.18");
        if (this instanceof Template) {
            nbt.func_74778_a("kind", "template");
        } else {
            nbt.func_74778_a("kind", "blueprint");
        }
        nbt.func_74768_a("sizeX", this.sizeX);
        nbt.func_74768_a("sizeY", this.sizeY);
        nbt.func_74768_a("sizeZ", this.sizeZ);
        nbt.func_74768_a("anchorX", this.anchorX);
        nbt.func_74768_a("anchorY", this.anchorY);
        nbt.func_74768_a("anchorZ", this.anchorZ);
        nbt.func_74757_a("rotate", this.rotate);
        nbt.func_74757_a("excavate", this.excavate);
        if (this.author != null) {
            nbt.func_74778_a("author", this.author);
        }
        this.saveContents(nbt);
    }

    public static BlueprintBase loadBluePrint(NBTTagCompound nbt) {
        String kind = nbt.func_74779_i("kind");
        BlueprintBase bpt = "template".equals(kind) ? new Template() : new Blueprint();
        bpt.readFromNBT(nbt);
        return bpt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        Object result = null;
        String versionRead = nbt.func_74779_i("version");
        this.sizeX = nbt.func_74762_e("sizeX");
        this.sizeY = nbt.func_74762_e("sizeY");
        this.sizeZ = nbt.func_74762_e("sizeZ");
        this.anchorX = nbt.func_74762_e("anchorX");
        this.anchorY = nbt.func_74762_e("anchorY");
        this.anchorZ = nbt.func_74762_e("anchorZ");
        this.author = nbt.func_74779_i("author");
        this.rotate = nbt.func_74764_b("rotate") ? nbt.func_74767_n("rotate") : true;
        this.excavate = nbt.func_74764_b("excavate") ? nbt.func_74767_n("excavate") : true;
        this.contents = new SchematicBlockBase[this.sizeX][this.sizeY][this.sizeZ];
        try {
            this.loadContents(nbt);
        }
        catch (BptError e) {
            e.printStackTrace();
        }
    }

    protected void copyTo(BlueprintBase base) {
    }

    public Box getBoxForPos(int x, int y, int z) {
        int xMin = x - this.anchorX;
        int yMin = y - this.anchorY;
        int zMin = z - this.anchorZ;
        int xMax = x + this.sizeX - this.anchorX - 1;
        int yMax = y + this.sizeY - this.anchorY - 1;
        int zMax = z + this.sizeZ - this.anchorZ - 1;
        Box res = new Box();
        res.initialize(xMin, yMin, zMin, xMax, yMax, zMax);
        res.reorder();
        return res;
    }

    public BptContext getContext(World world, Box box) {
        return new BptContext(world, box, this.mapping);
    }

    public synchronized byte[] getData() {
        if (this.data != null) {
            return this.data;
        }
        if (this.computeData == null) {
            this.computeData = new ComputeDataThread();
            this.computeData.nbt = new NBTTagCompound();
            this.writeToNBT(this.computeData.nbt);
            this.computeData.start();
        }
        return null;
    }

    public synchronized void setData(byte[] b) {
        this.data = b;
    }

    public abstract void loadContents(NBTTagCompound var1) throws BptError;

    public abstract void saveContents(NBTTagCompound var1);

    public abstract void readFromWorld(IBuilderContext var1, TileEntity var2, int var3, int var4, int var5);

    public abstract ItemStack getStack();

    public void readEntitiesFromWorld(IBuilderContext context, TileEntity anchorTile) {
    }

    class ComputeDataThread
    extends Thread {
        public NBTTagCompound nbt;

        ComputeDataThread() {
        }

        @Override
        public void run() {
            try {
                BlueprintBase.this.setData(CompressedStreamTools.func_74798_a((NBTTagCompound)this.nbt));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

