/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.utils.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class Template
extends BlueprintBase {
    public Template() {
        this.id.kind = BlueprintId.Kind.Template;
    }

    public Template(int sizeX, int sizeY, int sizeZ) {
        super(sizeX, sizeY, sizeZ);
        this.id.kind = BlueprintId.Kind.Template;
    }

    @Override
    public void readFromWorld(IBuilderContext context, TileEntity anchorTile, int x, int y, int z) {
        Block block = anchorTile.func_145831_w().func_147439_a(x, y, z);
        int posX = (int)((double)x - context.surroundingBox().pMin().x);
        int posY = (int)((double)y - context.surroundingBox().pMin().y);
        int posZ = (int)((double)z - context.surroundingBox().pMin().z);
        if (!BuildCraftAPI.isSoftBlock((IBlockAccess)anchorTile.func_145831_w(), x, y, z)) {
            this.contents[posX][posY][posZ] = new SchematicMask(true);
        }
    }

    @Override
    public void saveContents(NBTTagCompound nbt) {
        byte[] data = new byte[this.sizeX * this.sizeY * this.sizeZ];
        int ind = 0;
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    data[ind] = (byte)(this.contents[x][y][z] != null ? 1 : 0);
                    ++ind;
                }
            }
        }
        nbt.func_74773_a("mask", data);
    }

    @Override
    public void loadContents(NBTTagCompound nbt) throws BptError {
        byte[] data = nbt.func_74770_j("mask");
        int ind = 0;
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    if (data[ind] == 1) {
                        this.contents[x][y][z] = new SchematicMask(true);
                    }
                    ++ind;
                }
            }
        }
    }

    @Override
    public ItemStack getStack() {
        ItemStack stack = new ItemStack((Item)BuildCraftBuilders.templateItem, 1);
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        this.id.write(nbt);
        nbt.func_74778_a("author", this.author);
        nbt.func_74778_a("name", this.id.name);
        return stack;
    }
}

