/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.PacketPayload;
import io.netty.buffer.ByteBuf;

public class PacketUpdate
extends BuildCraftPacket {
    public int posX;
    public int posY;
    public int posZ;
    public PacketPayload payload;
    private int packetId;

    public PacketUpdate() {
    }

    public PacketUpdate(int packetId, PacketPayload payload) {
        this(packetId, 0, 0, 0, payload);
    }

    public PacketUpdate(int packetId, int posX, int posY, int posZ, PacketPayload payload) {
        this(packetId);
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.payload = payload;
    }

    public PacketUpdate(int packetId) {
        this.packetId = packetId;
        this.isChunkDataPacket = true;
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte(this.packetId);
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
        if (this.payload != null) {
            this.payload.writeData(data);
        } else {
            data.writeByte(0);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        this.packetId = data.readByte();
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
        this.payload = new PacketPayload();
        if (this.payload != null) {
            this.payload.readData(data);
        }
    }

    @Override
    public int getID() {
        return this.packetId;
    }
}

