/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.DefaultProps;
import buildcraft.core.inventory.TransactorSimple;
import buildcraft.core.robots.AIDocked;
import buildcraft.core.robots.AIMoveAround;
import buildcraft.core.robots.AIReturnToDock;
import buildcraft.core.robots.EntityRobot;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityRobotPicker
extends EntityRobot
implements IInventory {
    private static ResourceLocation texture = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_picker.png");
    private static Set<Integer> targettedItems = new HashSet<Integer>();
    SafeTimeTracker scanTracker = new SafeTimeTracker(40L, 10L);
    SafeTimeTracker pickTracker = new SafeTimeTracker(20L, 0L);
    SafeTimeTracker unloadTracker = new SafeTimeTracker(20L, 0L);
    TransactorSimple inventoryInsert = new TransactorSimple(this);
    int pickTime = -1;
    ItemStack[] inv = new ItemStack[6];
    private EntityItem target;

    public EntityRobotPicker(World par1World) {
        super(par1World);
    }

    @Override
    public ResourceLocation getTexture() {
        return texture;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.target != null) {
            if (this.target.field_70128_L) {
                targettedItems.remove(this.target.func_145782_y());
                this.target = null;
                this.currentAI = new AIReturnToDock();
                this.hideLaser();
                this.scan();
            } else if (this.pickTime == -1) {
                if (this.func_70011_f(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v) < 10.0) {
                    this.setLaserDestination((float)this.target.field_70165_t, (float)this.target.field_70163_u, (float)this.target.field_70161_v);
                    this.showLaser();
                    this.pickTracker = new SafeTimeTracker(200L);
                    this.pickTime = 0;
                }
            } else {
                ++this.pickTime;
                if (this.pickTime > 20) {
                    this.target.func_92059_d().field_77994_a -= this.inventoryInsert.inject(this.target.func_92059_d(), ForgeDirection.UNKNOWN, true);
                    if (this.target.func_92059_d().field_77994_a <= 0) {
                        this.target.func_70106_y();
                    }
                }
            }
        } else {
            if (this.currentAI instanceof AIDocked) {
                TileGenericPipe pipe = (TileGenericPipe)this.field_70170_p.func_147438_o(this.dockingStation.x, this.dockingStation.y, this.dockingStation.z);
                if (pipe.pipe.transport instanceof PipeTransportItems && this.unloadTracker.markTimeIfDelay(this.field_70170_p)) {
                    for (int i = 0; i < this.inv.length; ++i) {
                        if (this.inv[i] == null) continue;
                        float cx = (float)this.dockingStation.x + 0.5f + 0.2f * (float)this.dockingStation.side.offsetX;
                        float cy = (float)this.dockingStation.y + 0.5f + 0.2f * (float)this.dockingStation.side.offsetY;
                        float cz = (float)this.dockingStation.z + 0.5f + 0.2f * (float)this.dockingStation.side.offsetZ;
                        TravelingItem item = TravelingItem.make(cx, cy, cz, this.inv[i]);
                        ((PipeTransportItems)pipe.pipe.transport).injectItem(item, this.dockingStation.side.getOpposite());
                        this.inv[i] = null;
                        break;
                    }
                }
            }
            if (this.scanTracker.markTimeIfDelay(this.field_70170_p)) {
                this.scan();
            }
        }
    }

    public void scan() {
        for (Object o : this.field_70170_p.field_72996_f) {
            EntityItem item;
            double maxDistance;
            double dz;
            double dy;
            double dx;
            double sqrDistance;
            Entity e = (Entity)o;
            if (e.field_70128_L || !(e instanceof EntityItem) || targettedItems.contains(e.func_145782_y()) || !((sqrDistance = (dx = e.field_70165_t - this.field_70165_t) * dx + (dy = e.field_70163_u - this.field_70163_u) * dy + (dz = e.field_70161_v - this.field_70161_v) * dz) <= (maxDistance = 10000.0)) || this.inventoryInsert.inject((item = (EntityItem)e).func_92059_d(), ForgeDirection.UNKNOWN, false) <= 0) continue;
            this.target = item;
            targettedItems.add(e.func_145782_y());
            this.currentAI = new AIMoveAround(this, (float)e.field_70165_t, (float)e.field_70163_u, (float)e.field_70161_v);
            this.pickTime = -1;
            break;
        }
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.inv[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack result = this.inv[var1].func_77979_a(var2);
        if (this.inv[var1].field_77994_a == 0) {
            this.inv[var1] = null;
        }
        return result;
    }

    public ItemStack func_70304_b(int var1) {
        return this.inv[var1].func_77979_a(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inv[var1] = var2;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return this.inv[var1] == null || this.inv[var1].func_77969_a(var2) && this.inv[var1].func_77985_e() && this.inv[var1].field_77994_a + var2.field_77994_a <= this.inv[var1].func_77976_d();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        for (int i = 0; i < this.inv.length; ++i) {
            NBTTagCompound stackNbt = new NBTTagCompound();
            if (this.inv[i] == null) continue;
            nbt.func_74782_a("inv[" + i + "]", (NBTBase)this.inv[i].func_77955_b(stackNbt));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("inv[" + i + "]"));
        }
    }
}

