/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.core.NetworkData;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.TileBuffer;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.utils.StringUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyConverter
extends TileBuildCraft
implements IPowerReceptor,
IPowerEmitter {
    @MjBattery(maxCapacity=1000.0, maxReceivedPerCycle=64.0, minimumConsumption=1.0)
    @NetworkData
    private double mjStored = 0.0;
    @NetworkData
    private Mode mode = Mode.FromOldToNew;
    private TileBuffer[] tileCache;
    private PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE, MjAPI.getMjBattery(this));
    private PowerHandler zeroPowerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);

    public TileEnergyConverter() {
        this.zeroPowerHandler.configure(0.0, 0.0, 0.0, 0.0);
    }

    public static String getLocalizedModeName(ItemStack stack) {
        int mode = 0;
        if (stack != null && stack.func_77978_p() != null && ((mode = stack.func_77978_p().func_74762_e("converterMode")) >= Mode.values().length || mode < 0)) {
            mode = 0;
        }
        return StringUtils.localize("chat.pipe.power.energyConverter." + Mode.values()[mode].localizeName);
    }

    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (!this.getWorld().field_72995_K) {
            Item equipped;
            Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.mode = this.mode.next();
                player.func_145747_a((IChatComponent)new ChatComponentText(String.format(StringUtils.localize("chat.pipe.power.energyConverter"), StringUtils.localize("chat.pipe.power.energyConverter." + this.mode.localizeName))));
                this.sendNetworkUpdate();
                ((IToolWrench)equipped).wrenchUsed(player, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
        }
        return !player.func_70093_af();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("mjStored", this.mjStored);
        nbt.func_74768_a("converterMode", this.mode.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mjStored = nbt.func_74769_h("mjStored");
        this.mode = Mode.values()[nbt.func_74762_e("converterMode")];
    }

    public TileBuffer getTileBuffer(ForgeDirection side) {
        if (this.tileCache == null) {
            this.tileCache = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
        return this.tileCache[side.ordinal()];
    }

    @Override
    public void func_145845_h() {
        block3: {
            block2: {
                super.func_145845_h();
                if (this.mode != Mode.FromOldToNew) break block2;
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    IBatteryObject object;
                    TileEntity tile = this.getTileBuffer(side).getTile();
                    if (tile instanceof TileEnergyConverter || (object = MjAPI.getMjBattery(tile, "buildcraft.kinesis", side.getOpposite())) == null || !(this.mjStored > 0.0)) continue;
                    double wantToUse = Math.min(this.mjStored, object.getEnergyRequested());
                    object.addEnergy(wantToUse);
                    this.mjStored -= wantToUse;
                }
                break block3;
            }
            if (this.mode != Mode.FromNewToOld) break block3;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                double wantToUse;
                IPowerReceptor receptor;
                PowerHandler.PowerReceiver powerReceiver;
                TileEntity tile = this.getTileBuffer(side).getTile();
                if (tile instanceof TileEnergyConverter || !(tile instanceof IPowerReceptor) || !(this.mjStored > 0.0) || (powerReceiver = (receptor = (IPowerReceptor)tile).getPowerReceiver(side.getOpposite())) == null || !((wantToUse = Math.min(this.mjStored, powerReceiver.getMaxEnergyReceived())) > powerReceiver.getMinEnergyReceived())) continue;
                powerReceiver.receiveEnergy(PowerHandler.Type.MACHINE, wantToUse, side);
                this.mjStored -= wantToUse;
            }
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return (this.mode == Mode.FromOldToNew ? this.powerHandler : this.zeroPowerHandler).getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return this.mode == Mode.FromOldToNew;
    }

    private static enum Mode {
        FromOldToNew("from_old_to_new"),
        FromNewToOld("from_new_to_old");

        private final String localizeName;

        private Mode(String localizeName) {
            this.localizeName = localizeName;
        }

        public Mode next() {
            if (this == FromOldToNew) {
                return FromNewToOld;
            }
            return FromOldToNew;
        }
    }
}

