/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.gates.ITrigger;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.utils.MathUtils;
import buildcraft.energy.TileEngineWithInventory;
import buildcraft.energy.gui.ContainerEngine;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEngineStone
extends TileEngineWithInventory {
    static final float MAX_OUTPUT = 1.0f;
    static final float MIN_OUTPUT = 0.33333334f;
    static final float TARGET_OUTPUT = 0.375f;
    final float kp = 1.0f;
    final float ki = 0.05f;
    final double eLimit = 13.333332061767578;
    int burnTime = 0;
    int totalBurnTime = 0;
    double esum = 0.0;

    public TileEngineStone() {
        super(1);
    }

    @Override
    public ResourceLocation getBaseTexture() {
        return BASE_TEXTURES[1];
    }

    @Override
    public ResourceLocation getChamberTexture() {
        return CHAMBER_TEXTURES[1];
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)BuildCraftEnergy.instance, 21, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public float explosionRange() {
        return 2.0f;
    }

    @Override
    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void burn() {
        if (this.burnTime > 0) {
            double output;
            --this.burnTime;
            this.currentOutput = output = this.getCurrentOutput();
            this.addEnergy(output);
        }
        if (this.burnTime == 0 && this.isRedstonePowered) {
            this.burnTime = this.totalBurnTime = this.getItemBurnTime(this.func_70301_a(0));
            if (this.burnTime > 0) {
                this.func_70299_a(0, InvUtils.consumeItem(this.func_70301_a(0)));
            }
        }
    }

    @Override
    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    private int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.burnTime = data.func_74762_e("burnTime");
        this.totalBurnTime = data.func_74762_e("totalBurnTime");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("totalBurnTime", this.totalBurnTime);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        switch (id) {
            case 15: {
                this.burnTime = value;
                break;
            }
            case 16: {
                this.totalBurnTime = value;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        super.sendGUINetworkData(containerEngine, iCrafting);
        iCrafting.func_71112_a((Container)containerEngine, 15, this.burnTime);
        iCrafting.func_71112_a((Container)containerEngine, 16, this.totalBurnTime);
    }

    @Override
    public double maxEnergyReceived() {
        return 200.0;
    }

    @Override
    public double maxEnergyExtracted() {
        return 100.0;
    }

    @Override
    public double getMaxEnergy() {
        return 1000.0;
    }

    @Override
    public double getCurrentOutput() {
        double e = 0.375 * this.getMaxEnergy() - this.energy;
        this.esum = MathUtils.clamp(this.esum + e, -13.333332061767578, 13.333332061767578);
        return MathUtils.clamp(e * 1.0 + this.esum * (double)0.05f, 0.3333333432674408, 1.0);
    }

    @Override
    public LinkedList<ITrigger> getTriggers() {
        LinkedList<ITrigger> triggers = super.getTriggers();
        triggers.add(BuildCraftCore.triggerEmptyInventory);
        triggers.add(BuildCraftCore.triggerContainsInventory);
        triggers.add(BuildCraftCore.triggerSpaceInventory);
        triggers.add(BuildCraftCore.triggerFullInventory);
        return triggers;
    }

    public boolean func_145818_k_() {
        return false;
    }
}

