/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.transport.Pipe;
import buildcraft.transport.pipes.PipeFluidsCobblestone;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeFluidsStone;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsQuartz;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipePowerWood;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;

public final class PipeConnectionBans {
    private static final SetMultimap<Class<? extends Pipe>, Class<? extends Pipe>> connectionBans = HashMultimap.create();

    private PipeConnectionBans() {
    }

    public static void banConnection(Class<? extends Pipe> ... types) {
        if (types.length == 0) {
            return;
        }
        if (types.length == 1) {
            connectionBans.put(types[0], types[0]);
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < types.length; ++j) {
                if (i == j) continue;
                connectionBans.put(types[i], types[j]);
            }
        }
    }

    public static boolean canPipesConnect(Class<? extends Pipe> type1, Class<? extends Pipe> type2) {
        return !connectionBans.containsEntry(type1, type2);
    }

    static {
        PipeConnectionBans.banConnection(PipeFluidsStone.class, PipeFluidsCobblestone.class);
        PipeConnectionBans.banConnection(PipeFluidsWood.class);
        PipeConnectionBans.banConnection(PipeFluidsEmerald.class);
        PipeConnectionBans.banConnection(PipeFluidsWood.class, PipeFluidsEmerald.class);
        PipeConnectionBans.banConnection(PipeFluidsEmerald.class);
        PipeConnectionBans.banConnection(PipeItemsStone.class, PipeItemsCobblestone.class, PipeItemsQuartz.class);
        PipeConnectionBans.banConnection(PipeItemsWood.class);
        PipeConnectionBans.banConnection(PipeItemsEmerald.class);
        PipeConnectionBans.banConnection(PipeItemsEmzuli.class);
        PipeConnectionBans.banConnection(PipeItemsWood.class, PipeItemsEmerald.class, PipeItemsEmzuli.class);
        PipeConnectionBans.banConnection(PipeItemsObsidian.class);
        PipeConnectionBans.banConnection(PipePowerWood.class);
    }
}

