/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.TriggerParameter;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.GateDefinition;
import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerGateInterface
extends BuildCraftContainer {
    public boolean[] triggerState = new boolean[8];
    IInventory playerIInventory;
    Pipe pipe;
    private final NavigableSet<ITrigger> potentialTriggers = new TreeSet<ITrigger>(new Comparator<ITrigger>(){

        @Override
        public int compare(ITrigger o1, ITrigger o2) {
            return o1.getUniqueTag().compareTo(o2.getUniqueTag());
        }
    });
    private final NavigableSet<IAction> potentialActions = new TreeSet<IAction>(new Comparator<IAction>(){

        @Override
        public int compare(IAction o1, IAction o2) {
            return o1.getUniqueTag().compareTo(o2.getUniqueTag());
        }
    });
    private boolean isSynchronized = false;
    private boolean isNetInitialized = false;
    private int lastTriggerState = 0;

    public ContainerGateInterface(IInventory playerInventory, Pipe pipe) {
        super(0);
        this.playerIInventory = playerInventory;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(playerInventory, x + y * 9 + 9, 8 + x * 18, pipe.gate.material.guiHeight - 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot(playerInventory, x, 8 + x * 18, pipe.gate.material.guiHeight - 26));
        }
        this.pipe = pipe;
        if (!pipe.container.func_145831_w().field_72995_K) {
            this.potentialActions.addAll(pipe.getActions());
            this.potentialTriggers.addAll(ActionManager.getPipeTriggers(pipe.container));
            if (pipe.container instanceof IOverrideDefaultTriggers) {
                this.potentialTriggers.addAll(pipe.container.getTriggers());
            }
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                if (!pipe.hasGate(o)) continue;
                TileEntity tile = pipe.container.getTile(o);
                Block block = pipe.container.getBlock(o);
                this.potentialTriggers.addAll(ActionManager.getNeighborTriggers(block, tile));
                this.potentialActions.addAll(ActionManager.getNeighborActions(block, tile));
            }
            if (!pipe.gate.material.hasParameterSlot) {
                Iterator<ITrigger> it = this.potentialTriggers.iterator();
                while (it.hasNext()) {
                    ITrigger trigger = it.next();
                    if (!trigger.requiresParameter()) continue;
                    it.remove();
                }
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.pipe != null && this.pipe.gate != null;
    }

    public void markDirty() {
        this.isSynchronized = false;
    }

    public void updateActions(PacketUpdate packet) {
        this.potentialActions.clear();
        PacketPayload payload = packet.payload;
        int length = payload.stream.readInt();
        for (int i = 0; i < length; ++i) {
            this.potentialActions.add(ActionManager.actions.get(Utils.readUTF(payload.stream)));
        }
    }

    public void updateTriggers(PacketUpdate packet) {
        this.potentialTriggers.clear();
        PacketPayload payload = packet.payload;
        int length = payload.stream.readInt();
        for (int i = 0; i < length; ++i) {
            String trigger = Utils.readUTF(payload.stream);
            this.potentialTriggers.add(ActionManager.triggers.get(trigger));
        }
    }

    public void setSelection(PacketUpdate packet, boolean notify) {
        PacketPayload payload = packet.payload;
        ByteBuf data = payload.stream;
        int position = data.readInt();
        this.setTrigger(position, ActionManager.triggers.get(Utils.readUTF(data)), notify);
        this.setAction(position, ActionManager.actions.get(Utils.readUTF(data)), notify);
        ItemStack parameter = Utils.readStack(data);
        if (parameter != null) {
            TriggerParameter param = new TriggerParameter();
            param.set(parameter);
            this.setTriggerParameter(position, param, notify);
        } else {
            this.setTriggerParameter(position, null, notify);
        }
    }

    private PacketPayload getSelectionPayload(final int position) {
        PacketPayload payload = new PacketPayload(new PacketPayload.StreamWriter(){

            @Override
            public void writeData(ByteBuf data) {
                data.writeInt(position);
                if (ContainerGateInterface.this.pipe.gate.triggers[position] != null) {
                    Utils.writeUTF(data, ContainerGateInterface.this.pipe.gate.triggers[position].getUniqueTag());
                } else {
                    Utils.writeUTF(data, "");
                }
                if (ContainerGateInterface.this.pipe.gate.actions[position] != null) {
                    Utils.writeUTF(data, ContainerGateInterface.this.pipe.gate.actions[position].getUniqueTag());
                } else {
                    Utils.writeUTF(data, "");
                }
                if (ContainerGateInterface.this.pipe.gate.triggerParameters[position] != null && ContainerGateInterface.this.pipe.gate.triggerParameters[position].getItemStack() != null) {
                    Utils.writeStack(data, ContainerGateInterface.this.pipe.gate.triggerParameters[position].getItemStack());
                } else {
                    Utils.writeStack(data, null);
                }
            }
        });
        return payload;
    }

    public void sendSelectionChange(int position) {
        if (this.pipe.container.getWorld().field_72995_K) {
            BuildCraftTransport.instance.sendToServer(new PacketUpdate(44, this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e, this.getSelectionPayload(position)));
        }
    }

    public void synchronize() {
        if (!this.isNetInitialized && this.pipe.container.func_145831_w().field_72995_K) {
            this.isNetInitialized = true;
            BuildCraftTransport.instance.sendToServer(new PacketCoordinates(41, this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e));
        }
        if (!this.isSynchronized && this.pipe.container.func_145831_w().field_72995_K) {
            this.isSynchronized = true;
            BuildCraftTransport.instance.sendToServer(new PacketCoordinates(42, this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e));
        }
    }

    public void func_75137_b(int id, int state) {
        if (id == 0) {
            for (int i = 0; i < 8; ++i) {
                this.triggerState[i] = (state >> i & 1) == 1;
            }
        }
    }

    private int calculateTriggerState() {
        if (this.pipe.gate == null) {
            return 0;
        }
        int state = 0;
        for (int i = 0; i < this.triggerState.length; ++i) {
            if (this.pipe.gate.triggers[i] != null) {
                this.triggerState[i] = this.isNearbyTriggerActive(this.pipe.gate.triggers[i], this.pipe.gate.getTriggerParameter(i));
            }
            state |= this.triggerState[i] ? 1 << i : 0;
        }
        return state;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        int state = this.calculateTriggerState();
        if (state != this.lastTriggerState) {
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                ICrafting viewingPlayer = (ICrafting)this.field_75149_d.get(i);
                viewingPlayer.func_71112_a((Container)this, 0, state);
            }
            this.lastTriggerState = state;
        }
    }

    public void handleInitRequest(EntityPlayer player) {
        this.sendActions(player);
        this.sendTriggers(player);
        this.sendSelection(player);
    }

    private void sendActions(EntityPlayer player) {
        PacketPayload payload = new PacketPayload(new PacketPayload.StreamWriter(){

            @Override
            public void writeData(ByteBuf data) {
                int length = ContainerGateInterface.this.potentialActions.size();
                data.writeInt(length);
                for (IAction action : ContainerGateInterface.this.potentialActions) {
                    Utils.writeUTF(data, action.getUniqueTag());
                }
            }
        });
        PacketUpdate packet = new PacketUpdate(40, this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e, payload);
        BuildCraftTransport.instance.sendToPlayer(player, packet);
    }

    private void sendTriggers(EntityPlayer player) {
        PacketPayload payload = new PacketPayload(new PacketPayload.StreamWriter(){

            @Override
            public void writeData(ByteBuf data) {
                int length = ContainerGateInterface.this.potentialTriggers.size();
                data.writeInt(length);
                for (ITrigger trigger : ContainerGateInterface.this.potentialTriggers) {
                    Utils.writeUTF(data, trigger.getUniqueTag());
                }
            }
        });
        PacketUpdate packet = new PacketUpdate(45, this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e, payload);
        BuildCraftTransport.instance.sendToPlayer(player, packet);
    }

    public void sendSelection(EntityPlayer player) {
        if (this.pipe == null || this.pipe.gate == null) {
            return;
        }
        for (int position = 0; position < this.pipe.gate.material.numSlots; ++position) {
            BuildCraftTransport.instance.sendToPlayer(player, new PacketUpdate(43, this.pipe.container.field_145851_c, this.pipe.container.field_145848_d, this.pipe.container.field_145849_e, this.getSelectionPayload(position)));
        }
    }

    public boolean hasTriggers() {
        return this.potentialTriggers.size() > 0;
    }

    public ITrigger getFirstTrigger() {
        if (this.potentialTriggers.isEmpty()) {
            return null;
        }
        return (ITrigger)this.potentialTriggers.first();
    }

    public ITrigger getLastTrigger() {
        if (this.potentialTriggers.isEmpty()) {
            return null;
        }
        return (ITrigger)this.potentialTriggers.last();
    }

    public Iterator<ITrigger> getTriggerIterator(boolean descending) {
        return descending ? this.potentialTriggers.descendingIterator() : this.potentialTriggers.iterator();
    }

    public boolean isNearbyTriggerActive(ITrigger trigger, ITriggerParameter parameter) {
        if (this.pipe.gate == null) {
            return false;
        }
        return this.pipe.gate.isNearbyTriggerActive(trigger, parameter);
    }

    public void setTrigger(int position, ITrigger trigger, boolean notify) {
        if (this.pipe.gate == null) {
            return;
        }
        this.pipe.gate.setTrigger(position, trigger);
        if (this.pipe.container.func_145831_w().field_72995_K && notify) {
            this.sendSelectionChange(position);
        }
    }

    public void setTriggerParameter(int position, ITriggerParameter parameter, boolean notify) {
        if (this.pipe.gate == null) {
            return;
        }
        this.pipe.gate.setTriggerParameter(position, parameter);
        if (this.pipe.container.func_145831_w().field_72995_K && notify) {
            this.sendSelectionChange(position);
        }
    }

    public boolean hasActions() {
        return !this.potentialActions.isEmpty();
    }

    public IAction getFirstAction() {
        if (this.potentialActions.isEmpty()) {
            return null;
        }
        return (IAction)this.potentialActions.first();
    }

    public IAction getLastAction() {
        if (this.potentialActions.isEmpty()) {
            return null;
        }
        return (IAction)this.potentialActions.last();
    }

    public Iterator<IAction> getActionIterator(boolean descending) {
        return descending ? this.potentialActions.descendingIterator() : this.potentialActions.iterator();
    }

    public void setAction(int position, IAction action, boolean notify) {
        this.pipe.gate.setAction(position, action);
        if (this.pipe.container.func_145831_w().field_72995_K && notify) {
            this.sendSelectionChange(position);
        }
    }

    public ResourceLocation getGateGuiFile() {
        return this.pipe.gate.material.guiFile;
    }

    public String getGateName() {
        return GateDefinition.getLocalizedName(this.pipe.gate.material, this.pipe.gate.logic);
    }
}

