/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.gui.buttons.GuiImageButton;
import buildcraft.core.gui.buttons.IButtonClickEventListener;
import buildcraft.core.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.network.PacketGuiReturn;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.gui.ContainerEmeraldPipe;
import buildcraft.transport.pipes.PipeItemsEmerald;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiEmeraldPipe
extends GuiBuildCraft
implements IButtonClickEventListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/pipe_emerald.png");
    private static final int WHITE_LIST_BUTTON_ID = 1;
    private static final int BLACK_LIST_BUTTON_ID = 2;
    private static final int ROUND_ROBIN_BUTTON_ID = 3;
    private GuiImageButton whiteListButton;
    private GuiImageButton blackListButton;
    private GuiImageButton roundRobinButton;
    private IInventory playerInventory;
    private IInventory filterInventory;
    private PipeItemsEmerald pipe;

    public GuiEmeraldPipe(IInventory playerInventory, PipeItemsEmerald pipe) {
        super(new ContainerEmeraldPipe(playerInventory, pipe), pipe.getFilters(), TEXTURE);
        this.pipe = pipe;
        this.playerInventory = playerInventory;
        this.filterInventory = pipe.getFilters();
        this.field_146999_f = 175;
        this.field_147000_g = 161;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.whiteListButton = new GuiImageButton(1, this.field_147003_i + 7, this.field_147009_r + 41, GuiImageButton.ButtonImage.WHITE_LIST);
        this.whiteListButton.registerListener(this);
        this.field_146292_n.add(this.whiteListButton);
        this.blackListButton = new GuiImageButton(2, this.field_147003_i + 7 + 18, this.field_147009_r + 41, GuiImageButton.ButtonImage.BLACK_LIST);
        this.blackListButton.registerListener(this);
        this.field_146292_n.add(this.blackListButton);
        this.roundRobinButton = new GuiImageButton(3, this.field_147003_i + 7 + 36, this.field_147009_r + 41, GuiImageButton.ButtonImage.ROUND_ROBIN);
        this.roundRobinButton.registerListener(this);
        this.field_146292_n.add(this.roundRobinButton);
        switch (this.pipe.getSettings().getFilterMode()) {
            case WHITE_LIST: {
                this.whiteListButton.activate();
                break;
            }
            case BLACK_LIST: {
                this.blackListButton.activate();
                break;
            }
            case ROUND_ROBIN: {
                this.roundRobinButton.activate();
            }
        }
    }

    public void func_146281_b() {
        if (this.pipe.getWorld().field_72995_K) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.pipe.getContainer());
            pkt.sendPacket();
        }
        super.func_146281_b();
    }

    @Override
    public void handleButtonClick(IButtonClickEventTrigger sender, int buttonId) {
        switch (buttonId) {
            case 1: {
                this.whiteListButton.activate();
                this.blackListButton.deActivate();
                this.roundRobinButton.deActivate();
                this.pipe.getSettings().setFilterMode(PipeItemsEmerald.FilterMode.WHITE_LIST);
                break;
            }
            case 2: {
                this.whiteListButton.deActivate();
                this.blackListButton.activate();
                this.roundRobinButton.deActivate();
                this.pipe.getSettings().setFilterMode(PipeItemsEmerald.FilterMode.BLACK_LIST);
                break;
            }
            case 3: {
                this.whiteListButton.deActivate();
                this.blackListButton.deActivate();
                this.roundRobinButton.activate();
                this.pipe.getSettings().setFilterMode(PipeItemsEmerald.FilterMode.ROUND_ROBIN);
            }
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = StringUtils.localize("gui.pipes.emerald.title");
        this.field_146289_q.func_78276_b(title, (this.field_146999_f - this.field_146289_q.func_78256_a(title)) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_147000_g - 93, 0x404040);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(j, k, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

