/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.IAction;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeLogicIron;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import buildcraft.transport.triggers.ActionPipeDirection;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidsIron
extends Pipe<PipeTransportFluids> {
    protected int standardIconIndex = PipeIconProvider.TYPE.PipeFluidsIron_Standard.ordinal();
    protected int solidIconIndex = PipeIconProvider.TYPE.PipeAllIron_Solid.ordinal();
    private PipeLogicIron logic = new PipeLogicIron(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof TileGenericPipe) {
                Pipe otherPipe = ((TileGenericPipe)tile).pipe;
                if (otherPipe instanceof PipeFluidsWood || otherPipe instanceof PipeStructureCobblestone) {
                    return false;
                }
                return otherPipe.transport instanceof PipeTransportFluids;
            }
            return tile instanceof IFluidHandler;
        }
    };

    public PipeFluidsIron(Item item) {
        super(new PipeTransportFluids(), item);
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        return this.logic.blockActivated(entityplayer);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.switchOnRedstone();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        super.onBlockPlaced();
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        return super.outputOpen(to) && this.logic.outputOpen(to);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        if (this.container != null && this.container.func_145832_p() == direction.ordinal()) {
            return this.standardIconIndex;
        }
        return this.solidIconIndex;
    }

    @Override
    protected void actionsActivated(Map<IAction, Boolean> actions) {
        super.actionsActivated(actions);
        for (Map.Entry<IAction, Boolean> action : actions.entrySet()) {
            if (!(action.getKey() instanceof ActionPipeDirection) || action.getValue() == null || !action.getValue().booleanValue()) continue;
            this.logic.setFacing(((ActionPipeDirection)action.getKey()).direction);
            break;
        }
    }

    @Override
    public LinkedList<IAction> getActions() {
        LinkedList<IAction> action = super.getActions();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(direction)) continue;
            action.add(BuildCraftTransport.actionPipeDirection[direction.ordinal()]);
        }
        return action;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }
}

