/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.network.IClientState;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsDiamond
extends Pipe<PipeTransportItems>
implements IClientState {
    private SimpleInventory filters = new SimpleInventory(54, "Filters", 1);

    public PipeItemsDiamond(Item item) {
        super(new PipeTransportItems(), item);
    }

    public IInventory getFilters() {
        return this.filters;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        switch (direction) {
            case UNKNOWN: {
                return PipeIconProvider.TYPE.PipeItemsDiamond_Center.ordinal();
            }
            case DOWN: {
                return PipeIconProvider.TYPE.PipeItemsDiamond_Down.ordinal();
            }
            case UP: {
                return PipeIconProvider.TYPE.PipeItemsDiamond_Up.ordinal();
            }
            case NORTH: {
                return PipeIconProvider.TYPE.PipeItemsDiamond_North.ordinal();
            }
            case SOUTH: {
                return PipeIconProvider.TYPE.PipeItemsDiamond_South.ordinal();
            }
            case WEST: {
                return PipeIconProvider.TYPE.PipeItemsDiamond_West.ordinal();
            }
            case EAST: {
                return PipeIconProvider.TYPE.PipeItemsDiamond_East.ordinal();
            }
        }
        throw new IllegalArgumentException("direction out of bounds");
    }

    @Override
    public int getIconIndexForItem() {
        return PipeIconProvider.TYPE.PipeItemsDiamond_Item.ordinal();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && Block.func_149634_a((Item)entityplayer.func_71045_bC().func_77973_b()) instanceof BlockGenericPipe) {
            return false;
        }
        if (!this.container.func_145831_w().field_72995_K) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 50, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        }
        return true;
    }

    public void eventHandler(PipeEventItem.FindDest event) {
        LinkedList<ForgeDirection> filteredOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> defaultOrientations = new LinkedList<ForgeDirection>();
        for (ForgeDirection dir : event.destinations) {
            boolean foundFilter = false;
            for (int slot = 0; slot < 9; ++slot) {
                ItemStack filter = this.getFilters().func_70301_a(dir.ordinal() * 9 + slot);
                if (filter != null) {
                    foundFilter = true;
                }
                if (!StackHelper.isMatchingItem(filter, event.item.getItemStack(), true, false)) continue;
                filteredOrientations.add(dir);
            }
            if (foundFilter) continue;
            defaultOrientations.add(dir);
        }
        event.destinations.clear();
        if (!filteredOrientations.isEmpty()) {
            event.destinations.addAll(filteredOrientations);
        } else {
            event.destinations.addAll(defaultOrientations);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
    }

    @Override
    public void writeData(ByteBuf data) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        Utils.writeNBT(data, nbt);
    }

    @Override
    public void readData(ByteBuf data) {
        NBTTagCompound nbt = Utils.readNBT(data);
        this.readFromNBT(nbt);
    }
}

