/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftTransport;
import buildcraft.core.render.RenderUtils;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.PipeIconProvider;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class FacadeItemRenderer
implements IItemRenderer {
    private long lastTime = 0L;
    private boolean renderState = false;

    private void renderFacadeItem(RenderBlocks render, ItemStack item, float translateX, float translateY, float translateZ) {
        if (this.lastTime < System.currentTimeMillis()) {
            this.renderState = !this.renderState;
            this.lastTime = System.currentTimeMillis() + 1000L;
        }
        Object block = null;
        int decodedMeta = 0;
        int type = ItemFacade.getType(item);
        Block[] blocks = ItemFacade.getBlocks(item);
        int[] metas = ItemFacade.getMetaValues(item);
        if (blocks == null || blocks.length == 0 || metas == null || metas.length != blocks.length) {
            return;
        }
        if (type == 0 || type == 1 && this.renderState) {
            block = blocks[0];
            decodedMeta = metas[0];
        } else if (type == 1 && blocks.length >= 2) {
            block = blocks[1];
            decodedMeta = metas[1];
        }
        try {
            int color = item.func_77973_b().func_82790_a(new ItemStack(block, 1, decodedMeta), 0);
            RenderUtils.setGLColorFromInt(color);
        }
        catch (Throwable error) {
            // empty catch block
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        if (block == null) {
            return;
        }
        if (this.tryGetBlockIcon((Block)block, 0, decodedMeta) == null) {
            return;
        }
        GL11.glPushMatrix();
        if (block.func_149701_w() > 0) {
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        }
        block.func_149676_a(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
        render.func_147775_a(block);
        GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        render.func_147768_a(block, 0.0, 0.0, 0.0, this.tryGetBlockIcon((Block)block, 0, decodedMeta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        render.func_147806_b(block, 0.0, 0.0, 0.0, this.tryGetBlockIcon((Block)block, 1, decodedMeta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        render.func_147761_c(block, 0.0, 0.0, 0.0, this.tryGetBlockIcon((Block)block, 2, decodedMeta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        render.func_147734_d(block, 0.0, 0.0, 0.0, this.tryGetBlockIcon((Block)block, 3, decodedMeta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        render.func_147798_e(block, 0.0, 0.0, 0.0, this.tryGetBlockIcon((Block)block, 4, decodedMeta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        render.func_147764_f(block, 0.0, 0.0, 0.0, this.tryGetBlockIcon((Block)block, 5, decodedMeta));
        tessellator.func_78381_a();
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (block.func_149701_w() > 0) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
        block = BuildCraftTransport.genericPipeBlock;
        IIcon textureID = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        block.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.6875f);
        block.func_149683_g();
        render.func_147775_a(block);
        GL11.glTranslatef((float)translateX, (float)translateY, (float)(translateZ + 0.25f));
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -0.0f, 0.0f);
        render.func_147768_a(block, 0.0, 0.0, 0.0, textureID);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        render.func_147806_b(block, 0.0, 0.0, 0.0, textureID);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        render.func_147761_c(block, 0.0, 0.0, 0.0, textureID);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        render.func_147734_d(block, 0.0, 0.0, 0.0, textureID);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        render.func_147798_e(block, 0.0, 0.0, 0.0, textureID);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        render.func_147764_f(block, 0.0, 0.0, 0.0, textureID);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    private IIcon tryGetBlockIcon(Block block, int side, int decodedMeta) {
        try {
            IIcon icon = block.func_149691_a(side, decodedMeta);
            if (icon != null) {
                return icon;
            }
            return Blocks.field_150347_e.func_149691_a(0, 0);
        }
        catch (Throwable t) {
            try {
                return block.func_149733_h(side);
            }
            catch (Throwable t2) {
                return Blocks.field_150347_e.func_149691_a(0, 0);
            }
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                this.renderFacadeItem((RenderBlocks)data[0], item, -0.6f, 0.0f, -0.6f);
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                this.renderFacadeItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                break;
            }
            case INVENTORY: {
                GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                this.renderFacadeItem((RenderBlocks)data[0], item, -0.3f, -0.35f, -0.7f);
                break;
            }
        }
    }
}

