/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.core.utils.MatrixTranformations;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.render.FacadeRenderHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeRendererWorld
implements ISimpleBlockRenderingHandler {
    public static int renderPass = -1;

    public void renderPipe(RenderBlocks renderblocks, IBlockAccess iblockaccess, BlockGenericPipe block, TileGenericPipe tile, int x, int y, int z) {
        PipeRenderState state = tile.renderState;
        IIconProvider icons = tile.getPipeIcons();
        if (icons == null) {
            return;
        }
        if (renderPass == 0) {
            int connectivity = state.pipeConnectionMatrix.getMask();
            float[] dim = new float[6];
            if (connectivity != 63) {
                this.resetToCenterDimensions(dim);
                state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.UNKNOWN));
                this.renderTwoWayBlock(renderblocks, block, x, y, z, dim, connectivity ^ 0x3F);
            }
            for (int dir = 0; dir < 6; ++dir) {
                int mask = 1 << dir;
                if ((connectivity & mask) == 0) continue;
                this.resetToCenterDimensions(dim);
                dim[dir / 2] = dir % 2 == 0 ? 0.0f : 0.75f;
                dim[dir / 2 + 3] = dir % 2 == 0 ? 0.25f : 1.0f;
                int renderMask = 3 << dir / 2 * 2 ^ 0x3F;
                state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.VALID_DIRECTIONS[dir]));
                this.renderTwoWayBlock(renderblocks, block, x, y, z, dim, renderMask);
            }
        }
        renderblocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.pipeFacadeRenderer(renderblocks, block, state, x, y, z);
        if (renderPass == 0) {
            this.pipePlugRenderer(renderblocks, (Block)block, state, x, y, z);
            this.pipeRobotStationRenderer(renderblocks, (Block)block, state, x, y, z);
        }
    }

    private void resetToCenterDimensions(float[] dim) {
        int i;
        for (i = 0; i < 3; ++i) {
            dim[i] = 0.25f;
        }
        for (i = 3; i < 6; ++i) {
            dim[i] = 0.75f;
        }
    }

    private void renderTwoWayBlock(RenderBlocks renderblocks, BlockGenericPipe block, int x, int y, int z, float[] dim, int mask) {
        assert (mask != 0);
        block.setRenderMask(mask);
        renderblocks.func_147782_a((double)dim[2], (double)dim[0], (double)dim[1], (double)dim[5], (double)dim[3], (double)dim[4]);
        renderblocks.func_147784_q((Block)block, x, y, z);
        block.setRenderMask((mask & 0x15) << 1 | (mask & 0x2A) >> 1);
        renderblocks.func_147782_a((double)dim[5], (double)dim[3], (double)dim[4], (double)dim[2], (double)dim[0], (double)dim[1]);
        renderblocks.func_147784_q((Block)block, x, y, z);
    }

    private void pipeFacadeRenderer(RenderBlocks renderblocks, BlockGenericPipe block, PipeRenderState state, int x, int y, int z) {
        FacadeRenderHelper.pipeFacadeRenderer(renderblocks, block, state, x, y, z);
    }

    private void pipePlugRenderer(RenderBlocks renderblocks, Block block, PipeRenderState state, int x, int y, int z) {
        float[][] rotated;
        float zFightOffset = 2.4414062E-4f;
        float[][] zeroState = new float[3][2];
        zeroState[0][0] = 0.25f + zFightOffset;
        zeroState[0][1] = 0.75f - zFightOffset;
        zeroState[1][0] = 0.125f;
        zeroState[1][1] = 0.251f;
        zeroState[2][0] = 0.25f + zFightOffset;
        zeroState[2][1] = 0.75f - zFightOffset;
        state.currentTexture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.plugMatrix.isConnected(direction)) continue;
            rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, direction);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(block, x, y, z);
        }
        zeroState[0][0] = 0.3125f + zFightOffset;
        zeroState[0][1] = 0.6875f + zFightOffset;
        zeroState[1][0] = 0.25f;
        zeroState[1][1] = 0.375f;
        zeroState[2][0] = 0.3125f;
        zeroState[2][1] = 0.6875f;
        state.currentTexture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.plugMatrix.isConnected(direction)) continue;
            rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, direction);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(block, x, y, z);
        }
    }

    private void pipeRobotStationPartRender(RenderBlocks renderblocks, Block block, PipeRenderState state, int x, int y, int z, float xStart, float xEnd, float yStart, float yEnd, float zStart, float zEnd) {
        float zFightOffset = 2.4414062E-4f;
        float[][] zeroState = new float[3][2];
        zeroState[0][0] = xStart + zFightOffset;
        zeroState[0][1] = xEnd - zFightOffset;
        zeroState[1][0] = yStart;
        zeroState[1][1] = yEnd;
        zeroState[2][0] = zStart + zFightOffset;
        zeroState[2][1] = zEnd - zFightOffset;
        state.currentTexture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStation.ordinal());
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.robotStationMatrix.isConnected(direction)) continue;
            float[][] rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, direction);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(block, x, y, z);
        }
    }

    private void pipeRobotStationRenderer(RenderBlocks renderblocks, Block block, PipeRenderState state, int x, int y, int z) {
        float width = 0.075f;
        this.pipeRobotStationPartRender(renderblocks, block, state, x, y, z, 0.45f, 0.55f, 0.0f, 0.224f, 0.45f, 0.55f);
        float zFightOffset = 2.4414062E-4f;
        float[][] zeroState = new float[3][2];
        zeroState[0][0] = 0.25f + zFightOffset;
        zeroState[0][1] = 0.75f - zFightOffset;
        zeroState[1][0] = 0.225f;
        zeroState[1][1] = 0.251f;
        zeroState[2][0] = 0.25f + zFightOffset;
        zeroState[2][1] = 0.75f - zFightOffset;
        state.currentTexture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeRobotStation.ordinal());
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.robotStationMatrix.isConnected(direction)) continue;
            float[][] rotated = MatrixTranformations.deepClone(zeroState);
            MatrixTranformations.transform(rotated, direction);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(block, x, y, z);
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_147438_o(x, y, z);
        renderer.func_147782_a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        renderer.func_147784_q(Blocks.field_150348_b, x, y, z);
        renderer.func_147775_a(block);
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe pipeTile = (TileGenericPipe)tile;
            this.renderPipe(renderer, world, (BlockGenericPipe)block, pipeTile, x, y, z);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return TransportProxy.pipeModel;
    }
}

