/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.triggers;

import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.IPipeTrigger;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipePowerWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TriggerPipeContents
extends BCTrigger
implements IPipeTrigger {
    private PipeContents kind;
    private IIcon icon;

    public TriggerPipeContents(PipeContents kind) {
        super("buildcraft:pipe.contents." + kind.name().toLowerCase(Locale.ENGLISH), "buildcraft.pipe.contents." + kind.name());
        this.kind = kind;
        kind.trigger = this;
    }

    @Override
    public boolean hasParameter() {
        switch (this.kind) {
            case containsItems: 
            case containsFluids: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.pipe." + this.kind.name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        if (pipe.transport instanceof PipeTransportItems) {
            PipeTransportItems transportItems = (PipeTransportItems)pipe.transport;
            if (this.kind == PipeContents.empty) {
                return transportItems.items.isEmpty();
            }
            if (this.kind != PipeContents.containsItems) return false;
            if (parameter != null && parameter.getItemStack() != null) {
                TravelingItem item;
                Iterator<TravelingItem> i$ = transportItems.items.iterator();
                do {
                    if (!i$.hasNext()) return false;
                } while ((item = i$.next()).getItemStack().func_77973_b() != parameter.getItemStack().func_77973_b() || item.getItemStack().func_77960_j() != parameter.getItemStack().func_77960_j());
                return true;
            }
            if (transportItems.items.isEmpty()) return false;
            return true;
        }
        if (pipe.transport instanceof PipeTransportFluids) {
            PipeTransportFluids transportFluids = (PipeTransportFluids)pipe.transport;
            FluidStack searchedFluid = null;
            if (parameter != null && parameter.getItemStack() != null) {
                searchedFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)parameter.getItemStack());
            }
            if (this.kind == PipeContents.empty) {
                FluidTankInfo[] arr$ = transportFluids.getTankInfo(ForgeDirection.UNKNOWN);
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    FluidTankInfo b = arr$[i$];
                    if (b.fluid != null && b.fluid.amount != 0) {
                        return false;
                    }
                    ++i$;
                }
                return true;
            }
            FluidTankInfo[] arr$ = transportFluids.getTankInfo(ForgeDirection.UNKNOWN);
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                FluidTankInfo b = arr$[i$];
                if (b.fluid != null && b.fluid.amount != 0) {
                    if (searchedFluid == null) return true;
                    if (searchedFluid.isFluidEqual(b.fluid)) {
                        return true;
                    }
                }
                ++i$;
            }
            return false;
        }
        if (!(pipe.transport instanceof PipeTransportPower)) return false;
        PipeTransportPower transportPower = (PipeTransportPower)pipe.transport;
        switch (this.kind) {
            case empty: {
                float[] arr$ = transportPower.displayPower;
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    double s = arr$[i$];
                    if (s > 1.0E-4) {
                        return false;
                    }
                    ++i$;
                }
                return true;
            }
            case containsEnergy: {
                float[] arr$ = transportPower.displayPower;
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    double s = arr$[i$];
                    if (s > 1.0E-4) {
                        return true;
                    }
                    ++i$;
                }
                return false;
            }
            case requestsEnergy: {
                PipePowerWood wood = (PipePowerWood)pipe;
                return wood.requestsPower();
            }
        }
        return transportPower.isOverloaded();
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_pipecontents_" + this.kind.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public ITrigger rotateLeft() {
        return this;
    }

    public static enum PipeContents {
        empty,
        containsItems,
        containsFluids,
        containsEnergy,
        requestsEnergy,
        tooMuchEnergy;

        public BCTrigger trigger;
    }
}

