/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class FacadeMatrix {
    private final Block[] blocks = new Block[ForgeDirection.VALID_DIRECTIONS.length];
    private final int[] blockMetas = new int[ForgeDirection.VALID_DIRECTIONS.length];
    private boolean dirty = false;

    public void setFacade(ForgeDirection direction, Block block, int blockMeta) {
        if (this.blocks[direction.ordinal()] != block || this.blockMetas[direction.ordinal()] != blockMeta) {
            this.blocks[direction.ordinal()] = block;
            this.blockMetas[direction.ordinal()] = blockMeta;
            this.dirty = true;
        }
    }

    public Block getFacadeBlock(ForgeDirection direction) {
        return this.blocks[direction.ordinal()];
    }

    public int getFacadeMetaId(ForgeDirection direction) {
        return this.blockMetas[direction.ordinal()];
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(ByteBuf data) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (this.blocks[i] == null) {
                data.writeShort(0);
            } else {
                data.writeShort(Block.field_149771_c.func_148757_b((Object)this.blocks[i]));
            }
            data.writeByte(this.blockMetas[i]);
        }
    }

    public void readData(ByteBuf data) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            byte meta;
            short id = data.readShort();
            Block block = id == 0 ? null : (Block)Block.field_149771_c.func_148754_a((int)id);
            if (this.blocks[i] != block) {
                this.blocks[i] = block;
                this.dirty = true;
            }
            if (this.blockMetas[i] == (meta = data.readByte())) continue;
            this.blockMetas[i] = meta;
            this.dirty = true;
        }
    }
}

