/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.BuildCraftTransport;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.builders.schematics.SchematicIgnoreMeta;
import buildcraft.compat.CompatHooks;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.ConfigUtils;
import buildcraft.factory.BlockAutoWorkbench;
import buildcraft.factory.BlockFloodGate;
import buildcraft.factory.BlockFrame;
import buildcraft.factory.BlockHopper;
import buildcraft.factory.BlockMiningWell;
import buildcraft.factory.BlockPlainPipe;
import buildcraft.factory.BlockPump;
import buildcraft.factory.BlockQuarry;
import buildcraft.factory.BlockRefinery;
import buildcraft.factory.BlockTank;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.FactoryProxyClient;
import buildcraft.factory.GuiHandler;
import buildcraft.factory.PumpDimensionList;
import buildcraft.factory.TileAutoWorkbench;
import buildcraft.factory.TileFloodGate;
import buildcraft.factory.TileHopper;
import buildcraft.factory.TileMiningWell;
import buildcraft.factory.TilePump;
import buildcraft.factory.TileQuarry;
import buildcraft.factory.TileRefinery;
import buildcraft.factory.TileTank;
import buildcraft.factory.network.PacketHandlerFactory;
import buildcraft.factory.schematics.SchematicAutoWorkbench;
import buildcraft.factory.schematics.SchematicPump;
import buildcraft.factory.schematics.SchematicRefinery;
import buildcraft.factory.schematics.SchematicTileIgnoreState;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;

@Mod(name="BuildCraft Factory", version="6.3.6", useMetadata=false, modid="BuildCraft|Factory", dependencies="required-after:BuildCraft|Core@6.3.6")
public class BuildCraftFactory
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Factory")
    public static BuildCraftFactory instance;
    public static BlockQuarry quarryBlock;
    public static BlockMiningWell miningWellBlock;
    public static BlockAutoWorkbench autoWorkbenchBlock;
    public static BlockFrame frameBlock;
    public static BlockPlainPipe plainPipeBlock;
    public static BlockPump pumpBlock;
    public static BlockFloodGate floodGateBlock;
    public static BlockTank tankBlock;
    public static BlockRefinery refineryBlock;
    public static BlockHopper hopperBlock;
    public static boolean quarryLoadsChunks;
    public static boolean allowMining;
    public static boolean quarryOneTimeUse;
    public static float miningMultiplier;
    public static int miningDepth;
    public static PumpDimensionList pumpDimensionList;

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        FactoryProxy.proxy.initializeNEIIntegration();
        if (quarryLoadsChunks) {
            ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new QuarryChunkloadCallback());
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CoreProxy.proxy.registerTileEntity(TileQuarry.class, "Machine");
        CoreProxy.proxy.registerTileEntity(TileMiningWell.class, "MiningWell");
        CoreProxy.proxy.registerTileEntity(TileAutoWorkbench.class, "AutoWorkbench");
        CoreProxy.proxy.registerTileEntity(TilePump.class, "net.minecraft.src.buildcraft.factory.TilePump");
        CoreProxy.proxy.registerTileEntity(TileFloodGate.class, "net.minecraft.src.buildcraft.factory.TileFloodGate");
        CoreProxy.proxy.registerTileEntity(TileTank.class, "net.minecraft.src.buildcraft.factory.TileTank");
        CoreProxy.proxy.registerTileEntity(TileRefinery.class, "net.minecraft.src.buildcraft.factory.Refinery");
        CoreProxy.proxy.registerTileEntity(TileHopper.class, "net.minecraft.src.buildcraft.factory.TileHopper");
        FactoryProxy.proxy.initializeTileEntities();
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)refineryBlock, SchematicRefinery.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)tankBlock, SchematicTileIgnoreState.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)frameBlock, SchematicIgnoreMeta.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)pumpBlock, SchematicPump.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)miningWellBlock, SchematicTileIgnoreState.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)floodGateBlock, SchematicTileIgnoreState.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)autoWorkbenchBlock, SchematicAutoWorkbench.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)hopperBlock, SchematicTile.class, new Object[0]);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftFactory.loadRecipes();
        }
    }

    @Mod.EventHandler
    public void initialize(FMLPreInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-FACTORY", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandlerFactory()});
        ConfigUtils genCat = new ConfigUtils(BuildCraftCore.mainConfiguration, "general");
        allowMining = genCat.get("mining.enabled", true, "disables the recipes for automated mining machines");
        quarryOneTimeUse = genCat.get("quarry.one.time.use", false, "Quarry cannot be picked back up after placement");
        miningMultiplier = genCat.get("mining.cost.multipler", 1.0f, 1.0f, 10.0f, "cost multiplier for mining operations, range (1.0 - 10.0)\nhigh values may render engines incapable of powering machines directly");
        miningDepth = genCat.get("mining.depth", 2, 256, 256, "how far below the machine can mining machines dig, range (2 - 256), default 256");
        quarryLoadsChunks = genCat.get("quarry.loads.chunks", true, "Quarry loads chunks required for mining");
        Property pumpList = BuildCraftCore.mainConfiguration.get("general", "pumping.controlList", DefaultProps.PUMP_DIMENSION_LIST);
        pumpList.comment = "Allows admins to whitelist or blacklist pumping of specific fluids in specific dimensions.\nEg. \"-/-1/Lava\" will disable lava in the nether. \"-/*/Lava\" will disable lava in any dimension. \"+/0/*\" will enable any fluid in the overworld.\nEntries are comma seperated, banned fluids have precedence over allowed ones.Default is \"+/*/*,+/-1/Lava\" - the second redundant entry (\"+/-1/lava\") is there to show the format.";
        pumpDimensionList = new PumpDimensionList(pumpList.getString());
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        miningWellBlock = (BlockMiningWell)CompatHooks.INSTANCE.getBlock(BlockMiningWell.class);
        CoreProxy.proxy.registerBlock(miningWellBlock.func_149663_c("miningWellBlock"));
        plainPipeBlock = new BlockPlainPipe();
        CoreProxy.proxy.registerBlock(plainPipeBlock.func_149663_c("plainPipeBlock"));
        autoWorkbenchBlock = (BlockAutoWorkbench)CompatHooks.INSTANCE.getBlock(BlockAutoWorkbench.class);
        CoreProxy.proxy.registerBlock(autoWorkbenchBlock.func_149663_c("autoWorkbenchBlock"));
        frameBlock = new BlockFrame();
        CoreProxy.proxy.registerBlock(frameBlock.func_149663_c("frameBlock"));
        quarryBlock = (BlockQuarry)CompatHooks.INSTANCE.getBlock(BlockQuarry.class);
        CoreProxy.proxy.registerBlock(quarryBlock.func_149663_c("machineBlock"));
        tankBlock = (BlockTank)CompatHooks.INSTANCE.getBlock(BlockTank.class);
        CoreProxy.proxy.registerBlock(tankBlock.func_149663_c("tankBlock"));
        pumpBlock = (BlockPump)CompatHooks.INSTANCE.getBlock(BlockPump.class);
        CoreProxy.proxy.registerBlock(pumpBlock.func_149663_c("pumpBlock"));
        floodGateBlock = (BlockFloodGate)CompatHooks.INSTANCE.getBlock(BlockFloodGate.class);
        CoreProxy.proxy.registerBlock(floodGateBlock.func_149663_c("floodGateBlock"));
        refineryBlock = (BlockRefinery)CompatHooks.INSTANCE.getBlock(BlockRefinery.class);
        CoreProxy.proxy.registerBlock(refineryBlock.func_149663_c("refineryBlock"));
        hopperBlock = (BlockHopper)CompatHooks.INSTANCE.getBlock(BlockHopper.class);
        CoreProxy.proxy.registerBlock(hopperBlock.func_149663_c("blockHopper"));
        FactoryProxy.proxy.initializeEntityRenders();
        if (BuildCraftCore.mainConfiguration.hasChanged()) {
            BuildCraftCore.mainConfiguration.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void loadRecipes() {
        if (allowMining) {
            if (miningWellBlock != null) {
                CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)miningWellBlock, 1), "ipi", "igi", "iPi", Character.valueOf('p'), "dustRedstone", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "gearIron", Character.valueOf('P'), Items.field_151035_b);
            }
            if (quarryBlock != null) {
                CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)quarryBlock), "ipi", "gig", "dDd", Character.valueOf('i'), "gearIron", Character.valueOf('p'), "dustRedstone", Character.valueOf('g'), "gearGold", Character.valueOf('d'), "gearDiamond", Character.valueOf('D'), Items.field_151046_w);
            }
            if (pumpBlock != null && miningWellBlock != null) {
                CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)pumpBlock), new Object[]{"T", "W", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('W'), miningWellBlock});
            }
        }
        if (!(allowMining && miningWellBlock != null || pumpBlock == null)) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)pumpBlock), "iri", "iTi", "gpg", Character.valueOf('r'), "dustRedstone", Character.valueOf('i'), "ingotIron", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('g'), "gearIron", Character.valueOf('p'), BuildCraftTransport.pipeFluidsGold);
        }
        if (autoWorkbenchBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)autoWorkbenchBlock), " g ", "gwg", " g ", Character.valueOf('w'), Blocks.field_150462_ai, Character.valueOf('g'), "gearWood");
        }
        if (tankBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)tankBlock), "ggg", "g g", "ggg", Character.valueOf('g'), "blockGlass");
        }
        if (refineryBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)refineryBlock), "RTR", "TGT", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('G'), "gearDiamond", Character.valueOf('R'), Blocks.field_150429_aA);
        }
        if (hopperBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)hopperBlock), "ICI", "IGI", " I ", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('G'), "gearStone");
            CoreProxy.proxy.addShapelessRecipe(new ItemStack((Block)hopperBlock), Blocks.field_150438_bZ, "gearStone");
        }
        if (floodGateBlock != null) {
            CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)floodGateBlock), "IGI", "FTF", "IFI", Character.valueOf('I'), "ingotIron", Character.valueOf('T'), tankBlock != null ? tankBlock : "blockGlass", Character.valueOf('G'), "gearIron", Character.valueOf('F'), new ItemStack(Blocks.field_150411_aY));
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre evt) {
        if (evt.map.func_130086_a() == 0) {
            TextureMap terrainTextures = evt.map;
            FactoryProxyClient.pumpTexture = terrainTextures.func_94245_a("buildcraft:pump_tube");
            FactoryProxyClient.drillTexture = terrainTextures.func_94245_a("buildcraft:blockDrillTexture");
            FactoryProxyClient.drillHeadTexture = terrainTextures.func_94245_a("buildcraft:blockDrillHeadTexture");
        }
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAutoWorkbench.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileFloodGate.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileTank.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileRefinery.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileHopper.class.getCanonicalName());
    }

    static {
        quarryLoadsChunks = true;
        allowMining = true;
        quarryOneTimeUse = false;
        miningMultiplier = 1.0f;
        miningDepth = 256;
    }

    public class QuarryChunkloadCallback
    implements ForgeChunkManager.OrderedLoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                Block block;
                int quarryZ;
                int quarryY;
                int quarryX = ticket.getModData().func_74762_e("quarryX");
                if (!world.func_72899_e(quarryX, quarryY = ticket.getModData().func_74762_e("quarryY"), quarryZ = ticket.getModData().func_74762_e("quarryZ")) || (block = world.func_147439_a(quarryX, quarryY, quarryZ)) != quarryBlock) continue;
                TileQuarry tq = (TileQuarry)world.func_147438_o(quarryX, quarryY, quarryZ);
                tq.forceChunkLoading(ticket);
            }
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
            ArrayList validTickets = Lists.newArrayList();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                Block block;
                int quarryZ;
                int quarryY;
                int quarryX = ticket.getModData().func_74762_e("quarryX");
                if (!world.func_72899_e(quarryX, quarryY = ticket.getModData().func_74762_e("quarryY"), quarryZ = ticket.getModData().func_74762_e("quarryZ")) || (block = world.func_147439_a(quarryX, quarryY, quarryZ)) != quarryBlock) continue;
                validTickets.add(ticket);
            }
            return validTickets;
        }
    }
}

