/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.builders.schematics.SchematicRotateMeta;
import buildcraft.commander.BlockRequester;
import buildcraft.commander.BlockZonePlan;
import buildcraft.commander.TileRequester;
import buildcraft.commander.TileZonePlan;
import buildcraft.compat.CompatHooks;
import buildcraft.core.InterModComms;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.ItemRobot;
import buildcraft.core.network.BuildCraftChannelHandler;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.robots.RobotIntegrationRecipe;
import buildcraft.core.robots.boards.BoardRobotBomberNBT;
import buildcraft.core.robots.boards.BoardRobotBuilderNBT;
import buildcraft.core.robots.boards.BoardRobotButcherNBT;
import buildcraft.core.robots.boards.BoardRobotCarrierNBT;
import buildcraft.core.robots.boards.BoardRobotCrafterNBT;
import buildcraft.core.robots.boards.BoardRobotDeliveryNBT;
import buildcraft.core.robots.boards.BoardRobotFarmerNBT;
import buildcraft.core.robots.boards.BoardRobotFluidCarrierNBT;
import buildcraft.core.robots.boards.BoardRobotHarvesterNBT;
import buildcraft.core.robots.boards.BoardRobotKnightNBT;
import buildcraft.core.robots.boards.BoardRobotLeaveCutterNBT;
import buildcraft.core.robots.boards.BoardRobotLumberjackNBT;
import buildcraft.core.robots.boards.BoardRobotMinerNBT;
import buildcraft.core.robots.boards.BoardRobotPickerNBT;
import buildcraft.core.robots.boards.BoardRobotPlanterNBT;
import buildcraft.core.robots.boards.BoardRobotPumpNBT;
import buildcraft.core.robots.boards.BoardRobotShovelmanNBT;
import buildcraft.silicon.BlockLaser;
import buildcraft.silicon.BlockLaserTable;
import buildcraft.silicon.GuiHandler;
import buildcraft.silicon.ItemLaserTable;
import buildcraft.silicon.ItemRedstoneBoard;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.silicon.SiliconProxy;
import buildcraft.silicon.TileAdvancedCraftingTable;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.TileChargingTable;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.silicon.TileLaser;
import buildcraft.silicon.boards.BoardRecipe;
import buildcraft.silicon.boards.ImplRedstoneBoardRegistry;
import buildcraft.silicon.network.PacketHandlerSilicon;
import buildcraft.silicon.statements.ActionRobotFilter;
import buildcraft.silicon.statements.ActionRobotGotoStation;
import buildcraft.silicon.statements.ActionRobotWakeUp;
import buildcraft.silicon.statements.ActionRobotWorkInArea;
import buildcraft.silicon.statements.ActionStationAcceptFluids;
import buildcraft.silicon.statements.ActionStationAcceptItemsInv;
import buildcraft.silicon.statements.ActionStationAcceptItemsPipe;
import buildcraft.silicon.statements.ActionStationAllowCraft;
import buildcraft.silicon.statements.ActionStationForbidRobot;
import buildcraft.silicon.statements.ActionStationProvideFluids;
import buildcraft.silicon.statements.ActionStationProvideItems;
import buildcraft.silicon.statements.ActionStationRequestItems;
import buildcraft.silicon.statements.ActionStationRequestItemsMachine;
import buildcraft.silicon.statements.RobotsActionProvider;
import buildcraft.silicon.statements.RobotsTriggerProvider;
import buildcraft.silicon.statements.TriggerRobotSleep;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.channel.ChannelHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

@Mod(name="BuildCraft Silicon", version="6.3.6", useMetadata=false, modid="BuildCraft|Silicon", dependencies="required-after:BuildCraft|Transport@6.3.6")
public class BuildCraftSilicon
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Silicon")
    public static BuildCraftSilicon instance;
    public static ItemRedstoneChipset redstoneChipset;
    public static ItemRedstoneBoard redstoneBoard;
    public static BlockLaser laserBlock;
    public static BlockLaserTable assemblyTableBlock;
    public static BlockZonePlan zonePlanBlock;
    public static BlockRequester requesterBlock;
    public static Item redstoneCrystal;
    public static Item robotItem;
    public static ITriggerInternal triggerRobotSleep;
    public static IActionInternal actionRobotGotoStation;
    public static IActionInternal actionRobotWakeUp;
    public static IActionInternal actionRobotWorkInArea;
    public static IActionInternal actionRobotFilter;
    public static IActionInternal actionRobotAllowCraft;
    public static IActionInternal actionStationRequestItems;
    public static IActionInternal actionStationAcceptItems;
    public static IActionInternal actionStationProvideItems;
    public static IActionInternal actionStationAcceptFluids;
    public static IActionInternal actionStationProvideFluids;
    public static IActionInternal actionStationForbidRobot;
    public static IActionInternal actionStationDropInPipe;
    public static IActionInternal actionStationMachineRequestItems;
    public static float chipsetCostMultiplier;
    public static List<String> blacklistedRobots;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        chipsetCostMultiplier = BuildCraftCore.mainConfiguration.getFloat("chipset.costMultiplier", "general", 1.0f, 0.001f, 1000.0f, "The multiplier for chipset recipe cost.");
        blacklistedRobots = new ArrayList<String>();
        blacklistedRobots.addAll(Arrays.asList(BuildCraftCore.mainConfiguration.get("general", "boards.blacklist", new String[0]).getStringList()));
        BuildCraftCore.mainConfiguration.save();
        laserBlock = (BlockLaser)CompatHooks.INSTANCE.getBlock(BlockLaser.class);
        laserBlock.func_149663_c("laserBlock");
        CoreProxy.proxy.registerBlock((Block)laserBlock);
        assemblyTableBlock = (BlockLaserTable)CompatHooks.INSTANCE.getBlock(BlockLaserTable.class);
        assemblyTableBlock.func_149663_c("laserTableBlock");
        CoreProxy.proxy.registerBlock((Block)assemblyTableBlock, ItemLaserTable.class);
        zonePlanBlock = (BlockZonePlan)CompatHooks.INSTANCE.getBlock(BlockZonePlan.class);
        zonePlanBlock.func_149663_c("zonePlan");
        CoreProxy.proxy.registerBlock((Block)zonePlanBlock);
        requesterBlock = (BlockRequester)CompatHooks.INSTANCE.getBlock(BlockRequester.class);
        requesterBlock.func_149663_c("requester");
        CoreProxy.proxy.registerBlock((Block)requesterBlock);
        redstoneChipset = new ItemRedstoneChipset();
        redstoneChipset.func_77655_b("redstoneChipset");
        CoreProxy.proxy.registerItem(redstoneChipset);
        redstoneChipset.registerItemStacks();
        redstoneBoard = new ItemRedstoneBoard();
        redstoneBoard.func_77655_b("redstone_board");
        CoreProxy.proxy.registerItem(redstoneBoard);
        redstoneCrystal = new ItemBuildCraft().func_77655_b("redstoneCrystal");
        CoreProxy.proxy.registerItem(redstoneCrystal);
        OreDictionary.registerOre((String)"redstoneCrystal", (ItemStack)new ItemStack(redstoneCrystal));
        robotItem = new ItemRobot().func_77655_b("robot");
        CoreProxy.proxy.registerItem(robotItem);
        RedstoneBoardRegistry.instance = new ImplRedstoneBoardRegistry();
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotPickerNBT.instance, 20.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotCarrierNBT.instance, 10.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotLumberjackNBT.instance, 10.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotHarvesterNBT.instance, 10.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotMinerNBT.instance, 10.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotFluidCarrierNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotPlanterNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotFarmerNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotLeaveCutterNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotButcherNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotShovelmanNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotCrafterNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotDeliveryNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotPumpNBT.instance, 5.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotKnightNBT.instance, 1.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotBomberNBT.instance, 1.0f);
        RedstoneBoardRegistry.instance.registerBoardClass(BoardRobotBuilderNBT.instance, 0.5f);
        StatementManager.registerActionProvider(new RobotsActionProvider());
        StatementManager.registerTriggerProvider(new RobotsTriggerProvider());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-SILICON", new ChannelHandler[]{new BuildCraftChannelHandler(), new PacketHandlerSilicon()});
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        CoreProxy.proxy.registerTileEntity(TileLaser.class, "net.minecraft.src.buildcraft.factory.TileLaser");
        CoreProxy.proxy.registerTileEntity(TileAssemblyTable.class, "net.minecraft.src.buildcraft.factory.TileAssemblyTable");
        CoreProxy.proxy.registerTileEntity(TileAdvancedCraftingTable.class, "net.minecraft.src.buildcraft.factory.TileAssemblyAdvancedWorkbench");
        CoreProxy.proxy.registerTileEntity(TileIntegrationTable.class, "net.minecraft.src.buildcraft.factory.TileIntegrationTable");
        CoreProxy.proxy.registerTileEntity(TileChargingTable.class, "net.minecraft.src.buildcraft.factory.TileChargingTable");
        CoreProxy.proxy.registerTileEntity(TileZonePlan.class, "net.minecraft.src.buildcraft.commander.TileZonePlan");
        CoreProxy.proxy.registerTileEntity(TileRequester.class, "net.minecraft.src.buildcraft.commander.TileRequester");
        BuilderAPI.schematicRegistry.registerSchematicBlock((Block)laserBlock, SchematicRotateMeta.class, new int[]{2, 5, 3, 4}, true);
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftSilicon.loadRecipes();
        }
        SiliconProxy.proxy.registerRenderers();
    }

    public static void loadRecipes() {
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)laserBlock), "ORR", "DDR", "ORR", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 0), "ORO", "ODO", "OGO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), "dustRedstone", Character.valueOf('D'), "gemDiamond", Character.valueOf('G'), "gearDiamond");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 1), "OWO", "OCO", "ORO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('R'), new ItemStack((Item)redstoneChipset, 1, 0));
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 2), "ORO", "OCO", "OGO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), new ItemStack((Item)redstoneChipset, 1, 0), Character.valueOf('G'), "gearDiamond");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)assemblyTableBlock, 1, 3), "ORO", "OCO", "OGO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), new ItemStack((Item)redstoneChipset, 1, 0), Character.valueOf('G'), "gearGold");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)zonePlanBlock, 1, 0), "IRI", "GMG", "IDI", Character.valueOf('M'), Items.field_151148_bJ, Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), "gearGold", Character.valueOf('D'), "gearDiamond", Character.valueOf('I'), "ingotIron");
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Block)requesterBlock, 1, 0), "IPI", "GCG", "IRI", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('G'), "gearIron", Character.valueOf('I'), "ingotIron");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:redstoneChipset", Math.round(100000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.RED.getStack(), "dustRedstone");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:ironChipset", Math.round(200000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.IRON.getStack(), "dustRedstone", "ingotIron");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:goldChipset", Math.round(400000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.GOLD.getStack(), "dustRedstone", "ingotGold");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:diamondChipset", Math.round(800000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.DIAMOND.getStack(), "dustRedstone", "gemDiamond");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:emeraldChipset", Math.round(1200000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.EMERALD.getStack(), "dustRedstone", "gemEmerald");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:pulsatingChipset", Math.round(400000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.PULSATING.getStack(2), "dustRedstone", Items.field_151079_bi);
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:quartzChipset", Math.round(600000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.QUARTZ.getStack(), "dustRedstone", "gemQuartz");
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:compChipset", Math.round(600000.0f * chipsetCostMultiplier), ItemRedstoneChipset.Chipset.COMP.getStack(), "dustRedstone", Items.field_151132_bS);
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("buildcraft:redstoneCrystal", 10000000, new ItemStack(redstoneCrystal), new ItemStack(Blocks.field_150451_bX));
        CoreProxy.proxy.addCraftingRecipe(new ItemStack((Item)redstoneBoard), "PPP", "PRP", "PPP", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Items.field_151121_aF);
        CoreProxy.proxy.addCraftingRecipe(new ItemStack(robotItem), "PPP", "PRP", "C C", Character.valueOf('P'), "ingotIron", Character.valueOf('R'), redstoneCrystal, Character.valueOf('C'), ItemRedstoneChipset.Chipset.DIAMOND.getStack());
        BuildcraftRecipeRegistry.assemblyTable.addRecipe(new BoardRecipe("buildcraft:redstoneBoard"));
        BuildcraftRecipeRegistry.integrationTable.addRecipe(new RobotIntegrationRecipe("buildcraft:robotIntegration"));
    }

    @Mod.EventHandler
    public void processRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileLaser.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAssemblyTable.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileAdvancedCraftingTable.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileIntegrationTable.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!mapping.name.equals("BuildCraft|Silicon:null")) continue;
            if (mapping.type == GameRegistry.Type.ITEM) {
                mapping.remap(Item.func_150898_a((Block)assemblyTableBlock));
                continue;
            }
            mapping.remap((Block)assemblyTableBlock);
        }
    }

    static {
        triggerRobotSleep = new TriggerRobotSleep();
        actionRobotGotoStation = new ActionRobotGotoStation();
        actionRobotWakeUp = new ActionRobotWakeUp();
        actionRobotWorkInArea = new ActionRobotWorkInArea();
        actionRobotFilter = new ActionRobotFilter();
        actionRobotAllowCraft = new ActionStationAllowCraft();
        actionStationRequestItems = new ActionStationRequestItems();
        actionStationAcceptItems = new ActionStationAcceptItemsInv();
        actionStationProvideItems = new ActionStationProvideItems();
        actionStationAcceptFluids = new ActionStationAcceptFluids();
        actionStationProvideFluids = new ActionStationProvideFluids();
        actionStationForbidRobot = new ActionStationForbidRobot();
        actionStationDropInPipe = new ActionStationAcceptItemsPipe();
        actionStationMachineRequestItems = new ActionStationRequestItemsMachine();
        chipsetCostMultiplier = 1.0f;
    }
}

