/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.gates;

import buildcraft.api.gates.IGateExpansion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class GateExpansions {
    private static final Map<String, IGateExpansion> expansions = new HashMap<String, IGateExpansion>();
    private static final ArrayList<IGateExpansion> expansionIDs = new ArrayList();

    private GateExpansions() {
    }

    public static void registerExpansion(IGateExpansion expansion) {
        GateExpansions.registerExpansion(expansion.getUniqueIdentifier(), expansion);
    }

    public static void registerExpansion(String identifier, IGateExpansion expansion) {
        expansions.put(identifier, expansion);
        expansionIDs.add(expansion);
    }

    public static IGateExpansion getExpansion(String identifier) {
        return expansions.get(identifier);
    }

    public static Set<IGateExpansion> getExpansions() {
        HashSet<IGateExpansion> set = new HashSet<IGateExpansion>();
        set.addAll(expansionIDs);
        return set;
    }

    public static IGateExpansion getExpansionByID(int id) {
        return expansionIDs.get(id);
    }

    public static int getExpansionID(IGateExpansion expansion) {
        return expansionIDs.indexOf(expansion);
    }
}

