/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftCore;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.blueprints.BlueprintId;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class TileBlueprintLibrary
extends TileBuildCraft
implements IInventory,
ICommandReceiver {
    private static final int PROGRESS_TIME = 100;
    private static final int CHUNK_SIZE = 16384;
    public SimpleInventory inv = new SimpleInventory(4, "Blueprint Library", 1);
    public int progressIn = 0;
    public int progressOut = 0;
    public ArrayList<BlueprintId> currentPage;
    public int selected = -1;
    public EntityPlayer uploadingPlayer = null;
    public EntityPlayer downloadingPlayer = null;
    public int pageId = 0;
    private BlueprintId blueprintDownloadId;
    private byte[] blueprintDownload;

    public void refresh() {
        if (this.field_145850_b.field_72995_K) {
            BuildCraftBuilders.clientDB.refresh();
            this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.refresh();
    }

    public void setCurrentPage(ArrayList<BlueprintId> newPage) {
        this.currentPage = newPage;
        this.selected = -1;
    }

    public void pageNext() {
        if (this.pageId < BuildCraftBuilders.clientDB.getPageNumber() - 1) {
            ++this.pageId;
        }
        this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
    }

    public void pagePrev() {
        if (this.pageId > 0) {
            --this.pageId;
        }
        this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
    }

    public void deleteSelectedBpt() {
        if (this.selected != -1) {
            BuildCraftBuilders.clientDB.deleteBlueprint(this.currentPage.get(this.selected));
            if (this.pageId > BuildCraftBuilders.clientDB.getPageNumber() - 1 && this.pageId > 0) {
                --this.pageId;
            }
            this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = this.inv.func_70298_a(i, j);
        if (i == 0 && this.func_70301_a(0) == null) {
            this.progressIn = 0;
        }
        if (i == 2 && this.func_70301_a(2) == null) {
            this.progressOut = 0;
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        if (i == 0) {
            this.progressIn = this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemBlueprint ? 1 : 0;
        }
        if (i == 2) {
            this.progressOut = this.func_70301_a(2) != null && this.func_70301_a(2).func_77973_b() instanceof ItemBlueprint ? 1 : 0;
        }
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.progressIn > 0 && this.progressIn < 100) {
            ++this.progressIn;
        }
        if (this.progressOut > 0 && this.progressOut < 100) {
            this.progressOut = this.selected == -1 ? ++this.progressOut : 1;
        }
        if (this.progressIn == 100 && this.func_70301_a(1) == null) {
            this.func_70299_a(1, this.func_70301_a(0));
            this.func_70299_a(0, null);
            final BlueprintBase bpt = ItemBlueprint.loadBlueprint(this.func_70301_a(1));
            if (bpt != null && this.uploadingPlayer != null) {
                BuildCraftCore.instance.sendToPlayer(this.uploadingPlayer, new PacketCommand(this, "downloadBlueprintToClient", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        bpt.id.writeData(data);
                        Utils.writeByteArray(data, bpt.getData());
                    }
                }));
                this.uploadingPlayer = null;
            }
        }
        if (this.progressOut == 100 && this.func_70301_a(3) == null) {
            BuildCraftCore.instance.sendToPlayer(this.downloadingPlayer, new PacketCommand(this, "requestSelectedBlueprint", null));
            this.progressOut = 0;
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient()) {
            if ("requestSelectedBlueprint".equals(command)) {
                if (this.isOutputConsistent()) {
                    if (this.selected > -1 && this.selected < this.currentPage.size()) {
                        final BlueprintBase bpt = BuildCraftBuilders.clientDB.load(this.currentPage.get(this.selected));
                        final byte[] bptData = bpt.getData();
                        final int chunks = (bptData.length + 16384 - 1) / 16384;
                        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadServerBegin", new CommandWriter(){

                            @Override
                            public void write(ByteBuf data) {
                                bpt.id.writeData(data);
                                data.writeShort(chunks);
                            }
                        }));
                        int i = 0;
                        while (i < chunks) {
                            final int chunk = i++;
                            final int start = 16384 * chunk;
                            final int length = Math.min(16384, bptData.length - start);
                            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadServerChunk", new CommandWriter(){

                                @Override
                                public void write(ByteBuf data) {
                                    data.writeShort(chunk);
                                    data.writeShort(length);
                                    data.writeBytes(bptData, start, length);
                                }
                            }));
                        }
                        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadServerEnd", null));
                    } else {
                        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "uploadNothingToServer", null));
                    }
                }
            } else if ("downloadBlueprintToClient".equals(command)) {
                BlueprintId id = new BlueprintId();
                id.readData(stream);
                byte[] data = Utils.readByteArray(stream);
                try {
                    NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])data, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                    BlueprintBase bpt = BlueprintBase.loadBluePrint(nbt);
                    bpt.setData(data);
                    bpt.id = id;
                    BuildCraftBuilders.clientDB.add(bpt);
                    this.setCurrentPage(BuildCraftBuilders.clientDB.getPage(this.pageId));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (side.isServer()) {
            if ("uploadNothingToServer".equals(command)) {
                this.func_70299_a(3, this.func_70301_a(2));
                this.func_70299_a(2, null);
                this.downloadingPlayer = null;
            } else if ("uploadServerBegin".equals(command)) {
                this.blueprintDownloadId = new BlueprintId();
                this.blueprintDownloadId.readData(stream);
                this.blueprintDownload = new byte[16384 * stream.readUnsignedShort()];
            } else if ("uploadServerChunk".equals(command)) {
                int start = stream.readUnsignedShort() * 16384;
                int length = stream.readUnsignedShort();
                if (this.blueprintDownload != null) {
                    stream.readBytes(this.blueprintDownload, start, length);
                } else {
                    stream.skipBytes(length);
                }
            } else if ("uploadServerEnd".equals(command)) {
                try {
                    NBTTagCompound nbt = CompressedStreamTools.func_152457_a((byte[])this.blueprintDownload, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                    BlueprintBase bpt = BlueprintBase.loadBluePrint(nbt);
                    bpt.setData(this.blueprintDownload);
                    bpt.id = this.blueprintDownloadId;
                    BuildCraftBuilders.serverDB.add(bpt);
                    this.func_70299_a(3, bpt.getStack());
                    this.func_70299_a(2, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.blueprintDownloadId = null;
                this.blueprintDownload = null;
                this.downloadingPlayer = null;
            }
        }
    }

    public void selectBlueprint(int index) {
        this.selected = index;
    }

    private boolean isOutputConsistent() {
        if (this.selected == -1 || this.func_70301_a(2) == null) {
            return false;
        }
        return this.func_70301_a(2).func_77973_b() instanceof ItemBlueprintStandard && this.currentPage.get((int)this.selected).kind == BlueprintId.Kind.Blueprint || this.func_70301_a(2).func_77973_b() instanceof ItemBlueprintTemplate && this.currentPage.get((int)this.selected).kind == BlueprintId.Kind.Template;
    }
}

