/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftCore;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.Position;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.ResourceId;
import buildcraft.api.robots.StackRequest;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.TilePathMarker;
import buildcraft.core.Box;
import buildcraft.core.LaserData;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.RecursiveBlueprintBuilder;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.fluids.Tank;
import buildcraft.core.fluids.TankManager;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.robots.ResourceIdRequest;
import buildcraft.core.robots.RobotRegistry;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileBuilder
extends TileAbstractBuilder
implements IHasWork,
IFluidHandler,
IRequestProvider,
IControllable {
    private static int POWER_ACTIVATION = 500;
    public Box box = new Box();
    public PathIterator currentPathIterator;
    public Tank[] fluidTanks = new Tank[]{new Tank("fluid1", 8000, this), new Tank("fluid2", 8000, this), new Tank("fluid3", 8000, this), new Tank("fluid4", 8000, this)};
    public TankManager<Tank> fluidTank = new TankManager(this.fluidTanks);
    private SimpleInventory inv = new SimpleInventory(28, "Builder", 64);
    private BptBuilderBase currentBuilder;
    private RecursiveBlueprintBuilder recursiveBuilder;
    private LinkedList<BlockIndex> path;
    private ArrayList<ItemStack> requiredToBuild;
    private NBTTagCompound initNBT = null;
    private boolean done = true;
    private boolean isBuilding = false;

    public TileBuilder() {
        this.box.kind = Box.Kind.STRIPES;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.initNBT != null) {
            this.iterateBpt(true);
            if (this.initNBT.func_74764_b("iterator")) {
                BlockIndex bi;
                BlockIndex expectedTo = new BlockIndex(this.initNBT.func_74775_l("iterator"));
                while (!this.done && this.currentBuilder != null && this.currentPathIterator != null && !(bi = new BlockIndex((int)this.currentPathIterator.ix, (int)this.currentPathIterator.iy, (int)this.currentPathIterator.iz)).equals(expectedTo)) {
                    this.iterateBpt(true);
                }
            }
            if (this.currentBuilder != null) {
                this.currentBuilder.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), this);
            }
            this.initNBT = null;
        }
        this.box.kind = Box.Kind.STRIPES;
        for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
            block2: for (int y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
                for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                    TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
                    if (!(tile instanceof TilePathMarker)) continue;
                    this.path = ((TilePathMarker)tile).getPath();
                    for (BlockIndex b : this.path) {
                        this.field_145850_b.func_147468_f(b.x, b.y, b.z);
                        BuildCraftBuilders.pathMarkerBlock.func_149697_b(this.field_145850_b, b.x, b.y, b.z, 0, 0);
                    }
                    continue block2;
                }
            }
        }
        if (this.path != null && this.pathLasers.size() == 0) {
            this.createLasersForPath();
            this.sendNetworkUpdate();
        }
        this.iterateBpt(false);
    }

    public void createLasersForPath() {
        this.pathLasers = new LinkedList();
        BlockIndex previous = null;
        for (BlockIndex b : this.path) {
            if (previous != null) {
                LaserData laser = new LaserData(new Position((double)previous.x + 0.5, (double)previous.y + 0.5, (double)previous.z + 0.5), new Position((double)b.x + 0.5, (double)b.y + 0.5, (double)b.z + 0.5));
                this.pathLasers.add(laser);
            }
            previous = b;
        }
    }

    public BlueprintBase instanciateBlueprint() {
        BlueprintBase bpt = null;
        try {
            bpt = ItemBlueprint.loadBlueprint(this.func_70301_a(0));
        }
        catch (Throwable t) {
            this.func_70299_a(0, null);
            t.printStackTrace();
            return null;
        }
        return bpt;
    }

    @Deprecated
    public BptBuilderBase instanciateBluePrintBuilder(int x, int y, int z, ForgeDirection o) {
        BlueprintBase bpt = this.instanciateBlueprint();
        if (bpt == null) {
            return null;
        }
        if ((bpt = bpt.adjustToWorld(this.field_145850_b, x, y, z, o)) != null) {
            if (this.func_70301_a(0).func_77973_b() instanceof ItemBlueprintStandard) {
                return new BptBuilderBlueprint((Blueprint)bpt, this.field_145850_b, x, y, z);
            }
            if (this.func_70301_a(0).func_77973_b() instanceof ItemBlueprintTemplate) {
                return new BptBuilderTemplate(bpt, this.field_145850_b, x, y, z);
            }
        }
        return null;
    }

    public void iterateBpt(boolean forceIterate) {
        if ((this.func_70301_a(0) == null || !(this.func_70301_a(0).func_77973_b() instanceof ItemBlueprint)) && this.box.isInitialized()) {
            if (this.currentBuilder != null) {
                this.currentBuilder = null;
            }
            if (this.box.isInitialized()) {
                this.box.reset();
            }
            if (this.currentPathIterator != null) {
                this.currentPathIterator = null;
            }
            this.updateRequirements();
            this.sendNetworkUpdate();
            return;
        }
        if (this.currentBuilder == null || this.currentBuilder.isDone(this) || forceIterate) {
            if (this.path != null && this.path.size() > 1) {
                if (this.currentPathIterator == null) {
                    Iterator<BlockIndex> it = this.path.iterator();
                    BlockIndex start = (BlockIndex)it.next();
                    this.currentPathIterator = new PathIterator(start, it, ForgeDirection.values()[this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)].getOpposite());
                }
                if (this.currentBuilder != null && this.currentBuilder.isDone(this)) {
                    this.currentBuilder.postProcessing(this.field_145850_b);
                }
                this.currentBuilder = this.currentPathIterator.next();
                if (this.currentBuilder != null) {
                    this.box.reset();
                    this.box.initialize(this.currentBuilder);
                    this.sendNetworkUpdate();
                }
                if (this.currentBuilder == null) {
                    this.currentPathIterator = this.currentPathIterator.iterate();
                }
                this.done = this.currentPathIterator == null;
                this.updateRequirements();
            } else {
                if (this.currentBuilder != null && this.currentBuilder.isDone(this)) {
                    this.currentBuilder.postProcessing(this.field_145850_b);
                    this.currentBuilder = this.recursiveBuilder.nextBuilder();
                    this.updateRequirements();
                } else {
                    BlueprintBase bpt = this.instanciateBlueprint();
                    if (bpt != null) {
                        this.recursiveBuilder = new RecursiveBlueprintBuilder(bpt, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.values()[this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)].getOpposite());
                        this.currentBuilder = this.recursiveBuilder.nextBuilder();
                        this.updateRequirements();
                    }
                }
                if (this.currentBuilder == null) {
                    this.done = true;
                } else {
                    this.box.initialize(this.currentBuilder);
                    this.sendNetworkUpdate();
                    this.done = false;
                }
            }
        }
        if (this.done && this.func_70301_a(0) != null) {
            boolean dropBlueprint = true;
            for (int i = 1; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) != null) continue;
                this.func_70299_a(i, this.func_70301_a(0));
                dropBlueprint = false;
                break;
            }
            if (dropBlueprint) {
                InvUtils.dropItems(this.func_145831_w(), this.func_70301_a(0), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.func_70299_a(0, null);
            this.box.reset();
        }
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack result = this.inv.func_70298_a(i, j);
        if (!this.field_145850_b.field_72995_K && i == 0) {
            BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "clearItemRequirements", null), this.field_145850_b);
            this.iterateBpt(false);
        }
        return result;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inv.func_70299_a(i, itemstack);
        if (!this.field_145850_b.field_72995_K && i == 0) {
            this.iterateBpt(false);
            this.done = false;
        }
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public String func_145825_b() {
        return "Builder";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
        }
        if (nbttagcompound.func_74764_b("path")) {
            this.path = new LinkedList();
            NBTTagList list = nbttagcompound.func_150295_c("path", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.path.add(new BlockIndex(list.func_150305_b(i)));
            }
        }
        this.done = nbttagcompound.func_74767_n("done");
        this.fluidTank.readFromNBT(nbttagcompound);
        this.initNBT = (NBTTagCompound)nbttagcompound.func_74775_l("bptBuilder").func_74737_b();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbttagcompound.func_74782_a("box", (NBTBase)boxStore);
        }
        if (this.path != null) {
            NBTTagList list = new NBTTagList();
            for (BlockIndex i : this.path) {
                NBTTagCompound c = new NBTTagCompound();
                i.writeTo(c);
                list.func_74742_a((NBTBase)c);
            }
            nbttagcompound.func_74782_a("path", (NBTBase)list);
        }
        nbttagcompound.func_74757_a("done", this.done);
        this.fluidTank.writeToNBT(nbttagcompound);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.currentBuilder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.currentBuilder.saveBuildStateToNBT(builderCpt, this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        if (this.currentPathIterator != null) {
            NBTTagCompound iteratorNBT = new NBTTagCompound();
            new BlockIndex((int)this.currentPathIterator.ix, (int)this.currentPathIterator.iy, (int)this.currentPathIterator.iz).writeTo(iteratorNBT);
            bptNBT.func_74782_a("iterator", (NBTBase)iteratorNBT);
        }
        nbttagcompound.func_74782_a("bptBuilder", (NBTBase)bptNBT);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.currentBuilder != null) {
            this.currentBuilder.removeDoneBuilders(this);
        }
        if ((this.currentBuilder == null || this.currentBuilder.isDone(this)) && this.box.isInitialized()) {
            this.box.reset();
            this.sendNetworkUpdate();
            return;
        }
        this.iterateBpt(false);
        if (this.mode != IControllable.Mode.Off) {
            if (this.func_145831_w().func_72912_H().func_76077_q() == WorldSettings.GameType.CREATIVE) {
                this.build();
            } else if (this.getBattery().getEnergyStored() > POWER_ACTIVATION) {
                this.build();
            }
        }
        if (!this.isBuilding && this.isBuildingBlueprint()) {
            this.updateRequirements();
        }
        this.isBuilding = this.isBuildingBlueprint();
        if (this.done) {
            return;
        }
        if (this.getBattery().getEnergyStored() < 25) {
            return;
        }
    }

    @Override
    public boolean hasWork() {
        return !this.done;
    }

    public boolean isBuildingBlueprint() {
        return this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemBlueprint;
    }

    public Collection<ItemStack> getNeededItems() {
        return this.requiredToBuild;
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        super.receiveCommand(command, side, sender, stream);
        if (side.isClient()) {
            if ("clearItemRequirements".equals(command)) {
                this.requiredToBuild = null;
            } else if ("setItemRequirements".equals(command)) {
                int size = stream.readUnsignedShort();
                this.requiredToBuild = new ArrayList();
                for (int i = 0; i < size; ++i) {
                    ItemStack stack = Utils.readStack(stream);
                    stack.field_77994_a = Math.min(999, stream.readUnsignedShort());
                    this.requiredToBuild.add(stack);
                }
            }
        } else if (side.isServer()) {
            EntityPlayer player = (EntityPlayer)sender;
            if ("eraseFluidTank".equals(command)) {
                int id = stream.readInt();
                if (id < 0 || id >= this.fluidTanks.length) {
                    return;
                }
                if (this.func_70300_a(player) && player.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 64.0) {
                    this.fluidTanks[id].setFluid(null);
                    this.sendNetworkUpdate();
                }
            }
        }
    }

    private BuildCraftPacket getItemRequirementsPacket(final ArrayList<ItemStack> items) {
        if (items != null) {
            return new PacketCommand(this, "setItemRequirements", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeShort(items.size());
                    if (items != null) {
                        for (ItemStack rb : items) {
                            Utils.writeStack(data, rb);
                            data.writeShort(rb.field_77994_a);
                        }
                    }
                }
            });
        }
        return new PacketCommand(this, "clearItemRequirements", null);
    }

    @Override
    public boolean isBuildingMaterialSlot(int i) {
        return i != 0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() instanceof ItemBlueprint;
        }
        return true;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box renderBox = new Box(this).extendToEncompass(this.box);
        for (LaserData l : this.pathLasers) {
            renderBox = renderBox.extendToEncompass(l.head);
            renderBox = renderBox.extendToEncompass(l.tail);
        }
        return renderBox.expand(50).getBoundingBox();
    }

    public void build() {
        if (this.currentBuilder != null && this.currentBuilder.buildNextSlot(this.field_145850_b, this, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.updateRequirements();
        }
    }

    public void updateRequirements() {
        ArrayList<ItemStack> reqCopy = null;
        if (this.currentBuilder instanceof BptBuilderBlueprint) {
            this.currentBuilder.initialize();
            reqCopy = ((BptBuilderBlueprint)this.currentBuilder).neededItems;
        }
        for (EntityPlayer p : this.guiWatchers) {
            BuildCraftCore.instance.sendToPlayer(p, this.getItemRequirementsPacket(reqCopy));
        }
    }

    public void updateRequirements(EntityPlayer caller) {
        ArrayList<ItemStack> reqCopy = null;
        if (this.currentBuilder instanceof BptBuilderBlueprint) {
            this.currentBuilder.initialize();
            reqCopy = ((BptBuilderBlueprint)this.currentBuilder).neededItems;
        }
        BuildCraftCore.instance.sendToPlayer(caller, this.getItemRequirementsPacket(reqCopy));
    }

    public BptBuilderBase getBlueprint() {
        if (this.currentBuilder != null) {
            return this.currentBuilder;
        }
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean drainBuild(FluidStack fluidStack, boolean realDrain) {
        for (Tank tank : this.fluidTanks) {
            if (tank.getFluidType() != fluidStack.getFluid()) continue;
            return tank.getFluidAmount() >= fluidStack.amount && tank.drain((int)fluidStack.amount, (boolean)realDrain).amount > 0;
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Fluid fluid = resource.getFluid();
        Tank emptyTank = null;
        for (Tank tank : this.fluidTanks) {
            Fluid type = tank.getFluidType();
            if (type == fluid) {
                int used = tank.fill(resource, doFill);
                if (used > 0 && doFill) {
                    this.sendNetworkUpdate();
                }
                return used;
            }
            if (emptyTank != null || !tank.isEmpty()) continue;
            emptyTank = tank;
        }
        if (emptyTank != null) {
            int used = emptyTank.fill(resource, doFill);
            if (used > 0 && doFill) {
                this.sendNetworkUpdate();
            }
            return used;
        }
        return 0;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        boolean emptyAvailable = false;
        for (Tank tank : this.fluidTanks) {
            Fluid type = tank.getFluidType();
            if (type == fluid) {
                return !tank.isFull();
            }
            if (emptyAvailable) continue;
            emptyAvailable = tank.isEmpty();
        }
        return emptyAvailable;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.fluidTank.getTankInfo(from);
    }

    @Override
    public int getNumberOfRequests() {
        if (this.currentBuilder == null) {
            return 0;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return 0;
        }
        BptBuilderBlueprint bpt = (BptBuilderBlueprint)this.currentBuilder;
        return bpt.neededItems.size();
    }

    @Override
    public StackRequest getAvailableRequest(int i) {
        if (this.currentBuilder == null) {
            return null;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return null;
        }
        BptBuilderBlueprint bpt = (BptBuilderBlueprint)this.currentBuilder;
        if (bpt.neededItems.size() <= i) {
            return null;
        }
        ItemStack requirement = bpt.neededItems.get(i);
        int qty = this.quantityMissing(requirement);
        if (qty <= 0) {
            return null;
        }
        StackRequest request = new StackRequest();
        request.index = i;
        request.requester = this;
        request.stack = requirement;
        return request;
    }

    @Override
    public boolean takeRequest(int i, EntityRobotBase robot) {
        if (this.currentBuilder == null) {
            return false;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return false;
        }
        return RobotRegistry.getRegistry(this.field_145850_b).take((ResourceId)new ResourceIdRequest(this, i), robot);
    }

    @Override
    public ItemStack provideItemsForRequest(int i, ItemStack stack) {
        if (this.currentBuilder == null) {
            return stack;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return stack;
        }
        BptBuilderBlueprint bpt = (BptBuilderBlueprint)this.currentBuilder;
        if (bpt.neededItems.size() <= i) {
            return stack;
        }
        ItemStack requirement = bpt.neededItems.get(i);
        int qty = this.quantityMissing(requirement);
        if (qty <= 0) {
            return stack;
        }
        ItemStack toAdd = stack.func_77946_l();
        if (qty < toAdd.field_77994_a) {
            toAdd.field_77994_a = qty;
        }
        ITransactor t = Transactor.getTransactorFor(this);
        ItemStack added = t.add(toAdd, ForgeDirection.UNKNOWN, true);
        if (added.field_77994_a >= stack.field_77994_a) {
            return null;
        }
        stack.field_77994_a -= added.field_77994_a;
        return stack;
    }

    private int quantityMissing(ItemStack requirement) {
        int left = requirement.field_77994_a;
        for (IInvSlot slot : InventoryIterator.getIterable(this)) {
            if (slot.getStackInSlot() == null || !StackHelper.isMatchingItem(requirement, slot.getStackInSlot())) continue;
            if (slot.getStackInSlot().field_77994_a >= left) {
                return 0;
            }
            left -= slot.getStackInSlot().field_77994_a;
        }
        return left;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        this.box.writeData(stream);
        this.fluidTank.writeData(stream);
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.box.readData(stream);
        this.fluidTank.readData(stream);
    }

    private class PathIterator {
        public Iterator<BlockIndex> currentIterator;
        public double cx;
        public double cy;
        public double cz;
        public float ix;
        public float iy;
        public float iz;
        public BlockIndex to;
        public double lastDistance;
        AxisAlignedBB oldBoundingBox = null;
        ForgeDirection o = null;

        public PathIterator(BlockIndex from, Iterator<BlockIndex> it, ForgeDirection initialDir) {
            this.to = it.next();
            this.currentIterator = it;
            double dx = this.to.x - from.x;
            double dy = this.to.y - from.y;
            double dz = this.to.z - from.z;
            double size = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.cx = dx / size / 10.0;
            this.cy = dy / size / 10.0;
            this.cz = dz / size / 10.0;
            this.ix = from.x;
            this.iy = from.y;
            this.iz = from.z;
            this.lastDistance = (this.ix - (float)this.to.x) * (this.ix - (float)this.to.x) + (this.iy - (float)this.to.y) * (this.iy - (float)this.to.y) + (this.iz - (float)this.to.z) * (this.iz - (float)this.to.z);
            this.o = dx == 0.0 && dz == 0.0 ? initialDir : (Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST) : (dz > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH));
        }

        public BptBuilderBase next() {
            int newZ;
            int newY;
            int newX;
            BptBuilderBase bpt;
            while ((bpt = TileBuilder.this.instanciateBluePrintBuilder(newX = Math.round(this.ix), newY = Math.round(this.iy), newZ = Math.round(this.iz), this.o)) != null) {
                AxisAlignedBB boundingBox = bpt.getBoundingBox();
                if (this.oldBoundingBox == null || !this.collision(this.oldBoundingBox, boundingBox)) {
                    this.oldBoundingBox = boundingBox;
                    if (bpt != null) {
                        return bpt;
                    }
                }
                this.ix = (float)((double)this.ix + this.cx);
                this.iy = (float)((double)this.iy + this.cy);
                this.iz = (float)((double)this.iz + this.cz);
                double distance = (this.ix - (float)this.to.x) * (this.ix - (float)this.to.x) + (this.iy - (float)this.to.y) * (this.iy - (float)this.to.y) + (this.iz - (float)this.to.z) * (this.iz - (float)this.to.z);
                if (distance > this.lastDistance) {
                    return null;
                }
                this.lastDistance = distance;
            }
            return null;
        }

        public PathIterator iterate() {
            if (this.currentIterator.hasNext()) {
                PathIterator next = new PathIterator(this.to, this.currentIterator, this.o);
                next.oldBoundingBox = this.oldBoundingBox;
                return next;
            }
            return null;
        }

        public boolean collision(AxisAlignedBB left, AxisAlignedBB right) {
            if (left.field_72336_d < right.field_72340_a || left.field_72340_a > right.field_72336_d) {
                return false;
            }
            if (left.field_72337_e < right.field_72338_b || left.field_72338_b > right.field_72337_e) {
                return false;
            }
            return !(left.field_72334_f < right.field_72339_c) && !(left.field_72339_c > right.field_72334_f);
        }
    }
}

