/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.blueprints;

import buildcraft.api.core.ISerializable;
import buildcraft.core.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;

public final class BlueprintId
implements Comparable<BlueprintId>,
ISerializable {
    public byte[] uniqueId;
    public String name = "";
    public Kind kind = Kind.Blueprint;
    public String completeId;

    public void generateUniqueId(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] id = digest.digest(data);
            this.uniqueId = id;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(NBTTagCompound nbt) {
        nbt.func_74773_a("uniqueBptId", this.uniqueId);
        nbt.func_74778_a("name", this.name);
        nbt.func_74774_a("kind", (byte)this.kind.ordinal());
    }

    public void read(NBTTagCompound nbt) {
        this.uniqueId = nbt.func_74770_j("uniqueBptId");
        this.name = nbt.func_74779_i("name");
        this.kind = Kind.values()[nbt.func_74771_c("kind")];
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlueprintId) {
            return Arrays.equals(this.uniqueId, ((BlueprintId)obj).uniqueId);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(ArrayUtils.addAll((byte[])this.uniqueId, (byte[])this.name.getBytes()));
    }

    public String getCompleteId() {
        if (this.completeId == null) {
            this.completeId = this.uniqueId.length > 0 ? this.name + '-' + BlueprintId.toString(this.uniqueId) : this.name;
        }
        return this.completeId;
    }

    public String toString() {
        return this.getCompleteId();
    }

    private static char toHex(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        return (char)(87 + i);
    }

    private static int fromHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return c - 87;
    }

    @Override
    public int compareTo(BlueprintId o) {
        return this.getCompleteId().compareTo(o.getCompleteId());
    }

    public static String toString(byte[] bytes) {
        char[] ret = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int val = bytes[i] + 128;
            ret[i * 2] = BlueprintId.toHex(val >> 4);
            ret[i * 2 + 1] = BlueprintId.toHex(val & 0xF);
        }
        return new String(ret);
    }

    public static byte[] toBytes(String suffix) {
        byte[] result = new byte[suffix.length() / 2];
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)((byte)BlueprintId.fromHex(suffix.charAt(i * 2 + 1)) + (byte)(BlueprintId.fromHex(suffix.charAt(i * 2)) << 4));
            int n = i++;
            result[n] = (byte)(result[n] - 128);
        }
        return result;
    }

    @Override
    public void readData(ByteBuf stream) {
        this.uniqueId = Utils.readByteArray(stream);
        this.name = Utils.readUTF(stream);
        this.kind = Kind.values()[stream.readUnsignedByte()];
    }

    @Override
    public void writeData(ByteBuf stream) {
        Utils.writeByteArray(stream, this.uniqueId);
        Utils.writeUTF(stream, this.name);
        stream.writeByte(this.kind.ordinal());
    }

    public static enum Kind {
        Template,
        Blueprint;

    }
}

