/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IBox;
import buildcraft.api.core.IZone;
import buildcraft.builders.TileMarker;
import buildcraft.builders.TilePathMarker;
import buildcraft.core.Box;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.ZonePlan;
import buildcraft.core.utils.NBTUtils;
import buildcraft.core.utils.StringUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemMapLocation
extends ItemBuildCraft {
    public IIcon clean;
    public IIcon spot;
    public IIcon area;
    public IIcon path;
    public IIcon zone;

    public ItemMapLocation() {
        super(CreativeTabBuildCraft.ITEMS);
    }

    public int getItemStackLimit(ItemStack stack) {
        return NBTUtils.getItemData(stack).func_74764_b("kind") ? 1 : 16;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (cpt.func_74764_b("kind")) {
            switch (cpt.func_74771_c("kind")) {
                case 0: {
                    int x = cpt.func_74762_e("x");
                    int y = cpt.func_74762_e("y");
                    int z = cpt.func_74762_e("z");
                    ForgeDirection side = ForgeDirection.values()[cpt.func_74771_c("side")];
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + ", " + side + "}"));
                    break;
                }
                case 1: {
                    int x = cpt.func_74762_e("xMin");
                    int y = cpt.func_74762_e("yMin");
                    int z = cpt.func_74762_e("zMin");
                    int xLength = cpt.func_74762_e("xMax") - x + 1;
                    int yLength = cpt.func_74762_e("yMax") - y + 1;
                    int zLength = cpt.func_74762_e("zMax") - z + 1;
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + "} + {" + xLength + " x " + yLength + " x " + zLength + "}"));
                    break;
                }
                case 2: {
                    NBTTagList pathNBT = cpt.func_150295_c("path", 10);
                    BlockIndex first = new BlockIndex(pathNBT.func_150305_b(0));
                    int x = first.x;
                    int y = first.y;
                    int z = first.z;
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + "} + " + pathNBT.func_74745_c() + " elements"));
                    break;
                }
            }
        }
        if (cpt.func_74764_b("kind")) {
            // empty if block
        }
    }

    public IIcon func_77650_f(ItemStack stack) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (!cpt.func_74764_b("kind")) {
            this.field_77791_bV = this.clean;
        } else {
            switch (cpt.func_74771_c("kind")) {
                case 0: {
                    this.field_77791_bV = this.spot;
                    break;
                }
                case 1: {
                    this.field_77791_bV = this.area;
                    break;
                }
                case 2: {
                    this.field_77791_bV = this.path;
                    break;
                }
                case 3: {
                    this.field_77791_bV = this.zone;
                }
            }
        }
        return this.field_77791_bV;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.clean = par1IconRegister.func_94245_a("buildcraft:map_clean");
        this.spot = par1IconRegister.func_94245_a("buildcraft:map_spot");
        this.area = par1IconRegister.func_94245_a("buildcraft:map_area");
        this.path = par1IconRegister.func_94245_a("buildcraft:map_path");
        this.zone = par1IconRegister.func_94245_a("buildcraft:map_zone");
        RedstoneBoardRegistry.instance.registerIcons(par1IconRegister);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer par2EntityPlayer, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        TileEntity tile = world.func_147438_o(x, y, z);
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (tile instanceof TilePathMarker) {
            cpt.func_74774_a("kind", (byte)2);
            TilePathMarker pathTile = (TilePathMarker)tile;
            NBTTagList pathNBT = new NBTTagList();
            for (BlockIndex index : pathTile.getPath()) {
                NBTTagCompound nbt = new NBTTagCompound();
                index.writeTo(nbt);
                pathNBT.func_74742_a((NBTBase)nbt);
            }
            cpt.func_74782_a("path", (NBTBase)pathNBT);
        } else if (tile instanceof TileMarker) {
            cpt.func_74774_a("kind", (byte)1);
            TileMarker areaTile = (TileMarker)tile;
            cpt.func_74768_a("xMin", areaTile.xMin());
            cpt.func_74768_a("yMin", areaTile.yMin());
            cpt.func_74768_a("zMin", areaTile.zMin());
            cpt.func_74768_a("xMax", areaTile.xMax());
            cpt.func_74768_a("yMax", areaTile.yMax());
            cpt.func_74768_a("zMax", areaTile.zMax());
        } else {
            cpt.func_74774_a("kind", (byte)0);
            cpt.func_74774_a("side", (byte)side);
            cpt.func_74768_a("x", x);
            cpt.func_74768_a("y", y);
            cpt.func_74768_a("z", z);
        }
        return true;
    }

    public static BlockIndex getBlockIndex(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 0) {
            int x = cpt.func_74762_e("x");
            int y = cpt.func_74762_e("y");
            int z = cpt.func_74762_e("z");
            return new BlockIndex(x, y, z);
        }
        return null;
    }

    public static IBox getBox(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 1) {
            int xMin = cpt.func_74762_e("xMin");
            int yMin = cpt.func_74762_e("yMin");
            int zMin = cpt.func_74762_e("zMin");
            int xMax = cpt.func_74762_e("xMax");
            int yMax = cpt.func_74762_e("yMax");
            int zMax = cpt.func_74762_e("zMax");
            return new Box(xMin, yMin, zMin, xMax, yMax, zMax);
        }
        return null;
    }

    public static ForgeDirection getSide(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 0) {
            return ForgeDirection.values()[cpt.func_74771_c("side")];
        }
        return ForgeDirection.UNKNOWN;
    }

    public static IZone getZone(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 3) {
            ZonePlan plan = new ZonePlan();
            plan.readFromNBT(cpt);
            return plan;
        }
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 1) {
            return ItemMapLocation.getBox(item);
        }
        return null;
    }

    public static void setZone(ItemStack item, ZonePlan plan) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        cpt.func_74774_a("kind", (byte)3);
        plan.writeToNBT(cpt);
    }
}

