/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IInvSlot;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.builders.BuildingSlotIterator;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.utils.BlockUtils;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BptBuilderTemplate
extends BptBuilderBase {
    private LinkedList<BuildingSlotBlock> buildList = new LinkedList();
    private BuildingSlotIterator iterator;

    public BptBuilderTemplate(BlueprintBase bluePrint, World world, int x, int y, int z) {
        super(bluePrint, world, x, y, z);
    }

    @Override
    protected void internalInit() {
        BuildingSlotBlock b;
        SchematicBlockBase slot;
        int zCoord;
        int yCoord;
        int xCoord;
        int k;
        int i;
        int j;
        if (this.blueprint.excavate) {
            for (j = this.blueprint.sizeY - 1; j >= 0; --j) {
                for (i = 0; i < this.blueprint.sizeX; ++i) {
                    for (k = 0; k < this.blueprint.sizeZ; ++k) {
                        xCoord = i + this.x - this.blueprint.anchorX;
                        yCoord = j + this.y - this.blueprint.anchorY;
                        zCoord = k + this.z - this.blueprint.anchorZ;
                        if (yCoord < 0 || yCoord >= this.context.world.func_72800_K() || (slot = this.blueprint.contents[i][j][k]) != null || this.clearedLocations.contains(new BlockIndex(xCoord, yCoord, zCoord))) continue;
                        b = new BuildingSlotBlock();
                        b.schematic = null;
                        b.x = xCoord;
                        b.y = yCoord;
                        b.z = zCoord;
                        b.mode = BuildingSlotBlock.Mode.ClearIfInvalid;
                        b.buildStage = 0;
                        this.buildList.add(b);
                    }
                }
            }
        }
        for (j = 0; j < this.blueprint.sizeY; ++j) {
            for (i = 0; i < this.blueprint.sizeX; ++i) {
                for (k = 0; k < this.blueprint.sizeZ; ++k) {
                    xCoord = i + this.x - this.blueprint.anchorX;
                    yCoord = j + this.y - this.blueprint.anchorY;
                    zCoord = k + this.z - this.blueprint.anchorZ;
                    if (yCoord < 0 || yCoord >= this.context.world.func_72800_K() || (slot = this.blueprint.contents[i][j][k]) == null || this.builtLocations.contains(new BlockIndex(xCoord, yCoord, zCoord))) continue;
                    b = new BuildingSlotBlock();
                    b.schematic = slot;
                    b.x = xCoord;
                    b.y = yCoord;
                    b.z = zCoord;
                    b.mode = BuildingSlotBlock.Mode.Build;
                    b.buildStage = 1;
                    this.buildList.add(b);
                }
            }
        }
        this.iterator = new BuildingSlotIterator(this.buildList);
    }

    private void checkDone() {
        this.done = this.buildList.size() == 0;
    }

    @Override
    public BuildingSlot reserveNextBlock(World world) {
        return null;
    }

    @Override
    public BuildingSlot getNextBlock(World world, TileAbstractBuilder inv) {
        if (this.buildList.size() != 0) {
            BuildingSlotBlock slot = this.internalGetNextBlock(world, inv);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
        }
        this.checkDone();
        return null;
    }

    private BuildingSlotBlock internalGetNextBlock(World world, TileAbstractBuilder builder) {
        BuildingSlotBlock result = null;
        IInvSlot firstSlotToConsume = null;
        for (IInvSlot invSlot : InventoryIterator.getIterable(builder, ForgeDirection.UNKNOWN)) {
            ItemStack stack;
            if (!builder.isBuildingMaterialSlot(invSlot.getIndex()) || (stack = invSlot.getStackInSlot()) == null || stack.field_77994_a <= 0) continue;
            firstSlotToConsume = invSlot;
            break;
        }
        this.iterator.startIteration();
        while (this.iterator.hasNext()) {
            BuildingSlotBlock slot = this.iterator.next();
            if (slot.buildStage > this.buildList.getFirst().buildStage) {
                this.iterator.reset();
                return null;
            }
            if (BlockUtils.isUnbreakableBlock(world, slot.x, slot.y, slot.z)) {
                this.iterator.remove();
                if (slot.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                    this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                    continue;
                }
                this.builtLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                continue;
            }
            if (slot.mode == BuildingSlotBlock.Mode.ClearIfInvalid) {
                if (BuildCraftAPI.isSoftBlock(world, slot.x, slot.y, slot.z)) {
                    this.iterator.remove();
                    this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                    continue;
                }
                if (!this.canDestroy(builder, this.context, slot)) continue;
                this.consumeEnergyToDestroy(builder, slot);
                this.createDestroyItems(slot);
                result = slot;
                this.iterator.remove();
                this.clearedLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                break;
            }
            if (slot.mode != BuildingSlotBlock.Mode.Build) continue;
            if (!BuildCraftAPI.isSoftBlock(world, slot.x, slot.y, slot.z)) {
                this.iterator.remove();
                this.builtLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
                continue;
            }
            if (!builder.consumeEnergy(240) || firstSlotToConsume == null) continue;
            slot.addStackConsumed(firstSlotToConsume.decreaseStackInSlot(1));
            result = slot;
            this.iterator.remove();
            this.builtLocations.add(new BlockIndex(slot.x, slot.y, slot.z));
            break;
        }
        return result;
    }
}

