/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.slots.IPhantomSlot;
import buildcraft.core.gui.tooltips.IToolTipProvider;
import buildcraft.core.gui.tooltips.ToolTip;
import buildcraft.core.gui.tooltips.ToolTipLine;
import buildcraft.core.gui.widgets.Widget;
import buildcraft.core.render.RenderUtils;
import buildcraft.core.utils.SessionVars;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class GuiBuildCraft
extends GuiContainer {
    public static final ResourceLocation LEDGER_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/ledger.png");
    public final LedgerManager ledgerManager = new LedgerManager(this);
    public final TileEntity tile;
    public final BuildCraftContainer container;
    public ResourceLocation texture;

    public GuiBuildCraft(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super((Container)container);
        this.container = container;
        this.texture = texture;
        this.tile = inventory instanceof TileEntity ? (TileEntity)inventory : null;
        this.initLedgers(inventory);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    protected void initLedgers(IInventory inventory) {
    }

    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)left, (float)top, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o() == null) {
            this.drawToolTips(this.container.getWidgets(), mouseX, mouseY);
            this.drawToolTips(this.field_146292_n, mouseX, mouseY);
            this.drawToolTips(this.field_147002_h.field_75151_b, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    private void drawToolTips(Collection<?> objects, int mouseX, int mouseY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible() || (tips = provider.getToolTip()) == null) continue;
            boolean mouseOver = provider.isMouseOver(mouseX, mouseY);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            this.drawToolTips(tips, mouseX, mouseY);
        }
    }

    public void drawFluid(FluidStack fluid, int x, int y, int width, int height, int maxCapacity) {
        int i;
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        IIcon icon = fluid.getFluid().getIcon(fluid);
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtils.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        int fullX = width / 16;
        int fullY = height / 16;
        int lastX = width - fullX * 16;
        int lastY = height - fullY * 16;
        int level = fluid.amount * height / maxCapacity;
        int fullLvl = (height - level) / 16;
        int lastLvl = height - level - fullLvl * 16;
        for (i = 0; i < fullX; ++i) {
            for (int j = 0; j < fullY; ++j) {
                if (j < fullLvl) continue;
                this.drawCutIcon(icon, x + i * 16, y + j * 16, 16, 16, j == fullLvl ? lastLvl : 0);
            }
        }
        for (i = 0; i < fullX; ++i) {
            this.drawCutIcon(icon, x + i * 16, y + fullY * 16, 16, lastY, fullLvl == fullY ? lastLvl : 0);
        }
        for (i = 0; i < fullY; ++i) {
            if (i < fullLvl) continue;
            this.drawCutIcon(icon, x + fullX * 16, y + i * 16, lastX, 16, i == fullLvl ? lastLvl : 0);
        }
        this.drawCutIcon(icon, x + fullX * 16, y + fullY * 16, lastX, lastY, fullLvl == fullY ? lastLvl : 0);
    }

    private void drawCutIcon(IIcon icon, int x, int y, int width, int height, int cut) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)cut));
        tess.func_78374_a((double)x, (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)cut));
        tess.func_78381_a();
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int mX = mouseX - this.field_147003_i;
        int mY = mouseY - this.field_147009_r;
        for (Widget widget : this.container.getWidgets()) {
            if (widget.hidden) continue;
            this.bindTexture(this.texture);
            widget.draw(this, this.field_147003_i, this.field_147009_r, mX, mY);
        }
    }

    protected void func_146979_b(int par1, int par2) {
        this.drawLedgers(par1, par2);
    }

    protected void drawLedgers(int x, int y) {
        this.ledgerManager.drawLedgers(x, y);
    }

    public void drawCenteredString(String string, int xCenter, int yCenter, int textColor) {
        this.field_146289_q.func_78276_b(string, xCenter - this.field_146289_q.func_78256_a(string) / 2, yCenter - this.field_146289_q.field_78288_b / 2, textColor);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_146999_f);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_146289_q.func_78256_a(string)) / 2;
    }

    private boolean isMouseOverSlot(Slot slot, int mouseX, int mouseY) {
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        int realMouseX = mouseX - left;
        int realMouseY = mouseY - top;
        return realMouseX >= slot.field_75223_e - 1 && realMouseX < slot.field_75223_e + 16 + 1 && realMouseY >= slot.field_75221_f - 1 && realMouseY < slot.field_75221_f + 16 + 1;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        int mX = mouseX - this.field_147003_i;
        int mY = mouseY - this.field_147009_r;
        for (Widget widget : this.container.getWidgets()) {
            if (widget.hidden || !widget.isMouseOver(mX, mY) || !widget.handleMouseClick(mX, mY, mouseButton)) continue;
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.ledgerManager.handleMouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long time) {
        int mX = mouseX - this.field_147003_i;
        int mY = mouseY - this.field_147009_r;
        for (Widget widget : this.container.getWidgets()) {
            if (widget.hidden) continue;
            widget.handleMouseMove(mX, mY, mouseButton, time);
        }
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (mouseButton == 1 && slot instanceof IPhantomSlot) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, mouseButton, time);
    }

    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);
        int mX = mouseX - this.field_147003_i;
        int mY = mouseY - this.field_147009_r;
        for (Widget widget : this.container.getWidgets()) {
            if (widget.hidden) continue;
            widget.handleMouseRelease(mX, mY, eventType);
        }
    }

    public Slot func_146975_c(int x, int y) {
        for (int slotIndex = 0; slotIndex < this.field_147002_h.field_75151_b.size(); ++slotIndex) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(slotIndex);
            if (!this.isMouseOverSlot(slot, x, y)) continue;
            return slot;
        }
        return null;
    }

    public void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    private void drawToolTips(ToolTip toolTips, int mouseX, int mouseY) {
        if (toolTips.size() > 0) {
            int y;
            int left = this.field_147003_i;
            int top = this.field_147009_r;
            int length = 0;
            Iterator iterator = toolTips.iterator();
            while (iterator.hasNext()) {
                ToolTipLine tip = (ToolTipLine)iterator.next();
                y = this.field_146289_q.func_78256_a(tip.text);
                if (y <= length) continue;
                length = y;
            }
            int x = mouseX - left + 12;
            y = mouseY - top - 12;
            int var14 = 8;
            if (toolTips.size() > 1) {
                var14 += 2 + (toolTips.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            GuiBuildCraft.field_146296_j.field_77023_b = 300.0f;
            int var15 = -267386864;
            this.func_73733_a(x - 3, y - 4, x + length + 3, y - 3, var15, var15);
            this.func_73733_a(x - 3, y + var14 + 3, x + length + 3, y + var14 + 4, var15, var15);
            this.func_73733_a(x - 3, y - 3, x + length + 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x - 4, y - 3, x - 3, y + var14 + 3, var15, var15);
            this.func_73733_a(x + length + 3, y - 3, x + length + 4, y + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x + length + 2, y - 3 + 1, x + length + 3, y + var14 + 3 - 1, var16, var17);
            this.func_73733_a(x - 3, y - 3, x + length + 3, y - 3 + 1, var16, var16);
            this.func_73733_a(x - 3, y + var14 + 2, x + length + 3, y + var14 + 3, var17, var17);
            Iterator iterator2 = toolTips.iterator();
            while (iterator2.hasNext()) {
                ToolTipLine tip = (ToolTipLine)iterator2.next();
                String line = tip.text;
                line = tip.color == -1 ? "\u00a77" + line : "\u00a7" + Integer.toHexString(tip.color) + line;
                this.field_146289_q.func_78261_a(line, x, y, -1);
                y += 10 + tip.getSpacing();
            }
            this.field_73735_i = 0.0f;
            GuiBuildCraft.field_146296_j.field_77023_b = 0.0f;
        }
    }

    public BuildCraftContainer getContainer() {
        return this.container;
    }

    protected abstract class Ledger {
        public int currentShiftX = 0;
        public int currentShiftY = 0;
        protected int overlayColor = 0xFFFFFF;
        protected int limitWidth = 128;
        protected int maxWidth = 124;
        protected int minWidth;
        protected int currentWidth = this.minWidth = 24;
        protected int maxHeight = 24;
        protected int minHeight;
        protected int currentHeight = this.minHeight = 24;
        private boolean open;

        protected Ledger() {
        }

        public void update() {
            if (this.open && this.currentWidth < this.maxWidth) {
                this.currentWidth += 4;
            } else if (!this.open && this.currentWidth > this.minWidth) {
                this.currentWidth -= 4;
            }
            if (this.open && this.currentHeight < this.maxHeight) {
                this.currentHeight += 4;
            } else if (!this.open && this.currentHeight > this.minHeight) {
                this.currentHeight -= 4;
            }
        }

        public int getHeight() {
            return this.currentHeight;
        }

        public abstract void draw(int var1, int var2);

        public abstract String getTooltip();

        public boolean handleMouseClicked(int x, int y, int mouseButton) {
            return false;
        }

        public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
            return mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
        }

        public void setFullyOpen() {
            this.open = true;
            this.currentWidth = this.maxWidth;
            this.currentHeight = this.maxHeight;
        }

        public void toggleOpen() {
            if (this.open) {
                this.open = false;
                SessionVars.setOpenedLedger(null);
            } else {
                this.open = true;
                SessionVars.setOpenedLedger(this.getClass());
            }
        }

        public boolean isVisible() {
            return true;
        }

        public boolean isOpen() {
            return this.open;
        }

        protected boolean isFullyOpened() {
            return this.currentWidth >= this.maxWidth;
        }

        protected void drawBackground(int x, int y) {
            RenderUtils.setGLColorFromInt(this.overlayColor);
            GuiBuildCraft.this.field_146297_k.field_71446_o.func_110577_a(LEDGER_TEXTURE);
            GuiBuildCraft.this.func_73729_b(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
            GuiBuildCraft.this.func_73729_b(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            GuiBuildCraft.this.func_73729_b(x, y, 0, 0, 4, 4);
            GuiBuildCraft.this.func_73729_b(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        protected void drawIcon(IIcon icon, int x, int y) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBuildCraft.this.func_94065_a(x, y, icon, 16, 16);
        }
    }

    protected class LedgerManager {
        protected ArrayList<Ledger> ledgers = new ArrayList();
        private GuiBuildCraft gui;

        public LedgerManager(GuiBuildCraft gui) {
            this.gui = gui;
        }

        public void add(Ledger ledger) {
            this.ledgers.add(ledger);
            if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
                ledger.setFullyOpen();
            }
        }

        public void insert(Ledger ledger) {
            this.ledgers.add(this.ledgers.size() - 1, ledger);
        }

        protected Ledger getAtPosition(int mX, int mY) {
            int xShift = (this.gui.field_146294_l - this.gui.field_146999_f) / 2 + this.gui.field_146999_f;
            int yShift = (this.gui.field_146295_m - this.gui.field_147000_g) / 2 + 8;
            for (int i = 0; i < this.ledgers.size(); ++i) {
                Ledger ledger = this.ledgers.get(i);
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY, xShift, yShift)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
            return null;
        }

        protected void drawLedgers(int mouseX, int mouseY) {
            int xPos = 8;
            for (Ledger ledger : this.ledgers) {
                ledger.update();
                if (!ledger.isVisible()) continue;
                ledger.draw(GuiBuildCraft.this.field_146999_f, xPos);
                xPos += ledger.getHeight();
            }
            Ledger ledger = this.getAtPosition(mouseX, mouseY);
            if (ledger != null) {
                int startX = mouseX - (this.gui.field_146294_l - this.gui.field_146999_f) / 2 + 12;
                int startY = mouseY - (this.gui.field_146295_m - this.gui.field_147000_g) / 2 - 12;
                String tooltip = ledger.getTooltip();
                int textWidth = GuiBuildCraft.this.field_146289_q.func_78256_a(tooltip);
                GuiBuildCraft.this.func_73733_a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
                GuiBuildCraft.this.field_146289_q.func_78261_a(tooltip, startX, startY, -1);
            }
        }

        public void handleMouseClicked(int x, int y, int mouseButton) {
            Ledger ledger;
            if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
                for (Ledger other : this.ledgers) {
                    if (other == ledger || !other.isOpen()) continue;
                    other.toggleOpen();
                }
                ledger.toggleOpen();
            }
        }
    }
}

