/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.api.core.IInvSlot;
import java.util.Iterator;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

class InventoryIteratorSided
implements Iterable<IInvSlot> {
    private final ISidedInventory inv;
    private final int side;

    InventoryIteratorSided(ISidedInventory inv, ForgeDirection side) {
        this.inv = inv;
        this.side = side.ordinal();
    }

    @Override
    public Iterator<IInvSlot> iterator() {
        return new Iterator<IInvSlot>(){
            int[] slots;
            int index;
            {
                this.slots = InventoryIteratorSided.this.inv.func_94128_d(InventoryIteratorSided.this.side);
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.slots != null ? this.index < this.slots.length : false;
            }

            @Override
            public IInvSlot next() {
                InvSlot invSlot;
                if (this.slots != null) {
                    int n = this.index++;
                    invSlot = new InvSlot(this.slots[n]);
                } else {
                    invSlot = null;
                }
                return invSlot;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported.");
            }
        };
    }

    private class InvSlot
    implements IInvSlot {
        private int slot;

        public InvSlot(int slot) {
            this.slot = slot;
        }

        @Override
        public ItemStack getStackInSlot() {
            return InventoryIteratorSided.this.inv.func_70301_a(this.slot);
        }

        @Override
        public void setStackInSlot(ItemStack stack) {
            InventoryIteratorSided.this.inv.func_70299_a(this.slot, stack);
        }

        @Override
        public boolean canPutStackInSlot(ItemStack stack) {
            return InventoryIteratorSided.this.inv.func_102007_a(this.slot, stack, InventoryIteratorSided.this.side);
        }

        @Override
        public boolean canTakeStackFromSlot(ItemStack stack) {
            return InventoryIteratorSided.this.inv.func_102008_b(this.slot, stack, InventoryIteratorSided.this.side);
        }

        @Override
        public ItemStack decreaseStackInSlot(int amount) {
            return InventoryIteratorSided.this.inv.func_70298_a(this.slot, amount);
        }

        @Override
        public int getIndex() {
            return this.slot;
        }
    }
}

