/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.api.core.ISerializable;
import buildcraft.core.network.BuildCraftPacket;
import io.netty.buffer.ByteBuf;

public class PacketUpdate
extends BuildCraftPacket {
    public int posX;
    public int posY;
    public int posZ;
    public ByteBuf stream;
    public ISerializable payload;
    private int packetId;

    public PacketUpdate() {
    }

    public PacketUpdate(int packetId, ISerializable payload) {
        this(packetId, 0, 0, 0, payload);
    }

    public PacketUpdate(int packetId, int posX, int posY, int posZ, ISerializable payload) {
        this(packetId);
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.payload = payload;
    }

    public PacketUpdate(int packetId) {
        this.packetId = packetId;
        this.isChunkDataPacket = true;
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte(this.packetId);
        data.writeInt(this.posX);
        data.writeShort(this.posY);
        data.writeInt(this.posZ);
        if (this.payload != null) {
            this.payload.writeData(data);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        this.packetId = data.readByte();
        this.posX = data.readInt();
        this.posY = data.readShort();
        this.posZ = data.readInt();
        this.stream = data;
    }

    @Override
    public int getID() {
        return this.packetId;
    }
}

