/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.core.StackAtPosition;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.IBuildingItemsProvider;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class RenderBuildingItems {
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };

    public RenderBuildingItems() {
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }

    public void render(TileEntity tile, double x, double y, double z) {
        IBuildingItemsProvider provider = (IBuildingItemsProvider)tile;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)(-tile.field_145851_c), (double)(-tile.field_145848_d), (double)(-tile.field_145849_e));
        if (provider.getBuilders() != null) {
            for (BuildingItem i : provider.getBuilders()) {
                this.doRenderItem(i, 1.0f);
            }
        }
        GL11.glPopMatrix();
    }

    private void doRenderItem(BuildingItem i, float light) {
        if (i == null) {
            return;
        }
        i.displayUpdate();
        for (StackAtPosition s : i.getStacks()) {
            if (!s.display) continue;
            float renderScale = 0.7f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)s.pos.x), (float)((float)s.pos.y), (float)((float)s.pos.z));
            GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
            GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
            this.dummyEntityItem.func_92058_a(s.stack);
            this.customRenderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }
    }
}

