/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.InventoryCopy;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.core.robots.AIRobotCraftGeneric;
import buildcraft.core.robots.AIRobotGotoStation;
import buildcraft.core.robots.AIRobotGotoStationAndLoad;
import buildcraft.core.robots.AIRobotSearchStation;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.IStationFilter;
import buildcraft.core.robots.ResourceIdAssemblyTable;
import buildcraft.core.robots.ResourceIdBlock;
import buildcraft.core.robots.RobotRegistry;
import buildcraft.silicon.BlockLaserTable;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.statements.ActionRobotFilter;
import buildcraft.silicon.statements.ActionStationAllowCraft;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotCraftAssemblyTable
extends AIRobotCraftGeneric {
    private CraftingResult<ItemStack> expectedResult;
    private DockingStation stationFound;
    private TileAssemblyTable table;
    private boolean craftStarted = false;
    private ArrayList<ArrayStackFilter> requirements;
    private int waitedTime = 0;

    public AIRobotCraftAssemblyTable(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotCraftAssemblyTable(EntityRobotBase iRobot, CraftingResult craftingResult) {
        super(iRobot);
        this.expectedResult = craftingResult;
    }

    @Override
    public void start() {
        this.requirements = this.tryCraft();
        this.startDelegateAI(new AIRobotSearchStation(this.robot, new StationAssemblyTableFilter(), this.robot.getZoneToWork()));
    }

    @Override
    public void update() {
        if (this.table != null) {
            if (!this.craftStarted) {
                if (this.requirements.size() != 0) {
                    this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, new ReqStackFilter(), this.robot.getZoneToWork()));
                    return;
                }
                if (this.robot.getDockingStation() != this.stationFound) {
                    this.startDelegateAI(new AIRobotGotoStation(this.robot, this.stationFound));
                    return;
                }
                ITransactor trans = Transactor.getTransactorFor(this.table);
                for (IInvSlot s : InventoryIterator.getIterable(this.robot)) {
                    if (s.getStackInSlot() == null) continue;
                    ItemStack added = trans.add(s.getStackInSlot(), ForgeDirection.UNKNOWN, true);
                    if (added.field_77994_a == 0) {
                        this.terminate();
                        continue;
                    }
                    if (added.field_77994_a == s.getStackInSlot().field_77994_a) {
                        s.setStackInSlot(null);
                        continue;
                    }
                    s.getStackInSlot().field_77994_a -= added.field_77994_a;
                }
                RobotRegistry.getRegistry(this.robot.field_70170_p).take((ResourceId)new ResourceIdAssemblyTable(this.table), this.robot);
                this.table.planOutput(this.expectedResult.recipe);
                this.craftStarted = true;
            } else {
                ++this.waitedTime;
                if (InvUtils.getItem(this.robot, new ArrayStackFilter((ItemStack)this.expectedResult.crafted)) != null) {
                    this.crafted = true;
                    this.terminate();
                } else if (this.waitedTime > 7200) {
                    this.terminate();
                }
            }
        } else {
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchStation) {
            if (!ai.success()) {
                this.crafted = false;
                this.terminate();
            } else {
                this.stationFound = ((AIRobotSearchStation)ai).targetStation;
                this.table = this.getUsableAssemblyTable(new BlockIndex(this.stationFound.x(), this.stationFound.y(), this.stationFound.z()));
                if (this.table == null) {
                    this.terminate();
                    return;
                }
                BlockIndex index = new BlockIndex(this.table);
                if (!this.robot.getRegistry().take((ResourceId)new ResourceIdBlock(index), this.robot)) {
                    this.terminate();
                }
                if (!this.stationFound.take(this.robot)) {
                    this.terminate();
                }
            }
        } else if (ai instanceof AIRobotGotoStationAndLoad) {
            if (!ai.success()) {
                this.terminate();
            } else {
                this.requirements = this.tryCraft();
            }
        }
    }

    @Override
    public ItemStack receiveItem(ItemStack stack) {
        if (StackHelper.isMatchingItem(stack, (ItemStack)this.expectedResult.crafted)) {
            ITransactor robotTransactor = Transactor.getTransactorFor((Object)this.robot);
            ItemStack added = robotTransactor.add(stack, ForgeDirection.UNKNOWN, true);
            stack.field_77994_a -= added.field_77994_a;
            return stack;
        }
        return stack;
    }

    protected ArrayList<ArrayStackFilter> tryCraft() {
        Object[] items = this.expectedResult.usedItems.toArray();
        ArrayList<ArrayStackFilter> result = new ArrayList<ArrayStackFilter>();
        InventoryCopy inv = new InventoryCopy(this.robot);
        for (Object tmp : items) {
            ArrayStackFilter filter;
            if (tmp == null) continue;
            int qty = 0;
            if (tmp instanceof ItemStack) {
                ItemStack stack = (ItemStack)tmp;
                qty = stack.field_77994_a;
                filter = new ArrayStackFilter(stack);
            } else {
                ArrayList stacks = (ArrayList)tmp;
                qty = ((ItemStack)stacks.get((int)0)).field_77994_a;
                filter = new ArrayStackFilter(stacks.toArray(new ItemStack[stacks.size()]));
            }
            for (IInvSlot s : InventoryIterator.getIterable(inv)) {
                if (!filter.matches(s.getStackInSlot())) continue;
                ItemStack removed = s.decreaseStackInSlot(qty);
                qty -= removed.field_77994_a;
                if (removed.field_77994_a != 0) continue;
                break;
            }
            if (qty <= 0) continue;
            result.add(filter);
        }
        return result;
    }

    private TileAssemblyTable getUsableAssemblyTable(BlockIndex b) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockIndex index = new BlockIndex(b.x + dir.offsetX, b.y + dir.offsetY, b.z + dir.offsetZ);
            if (this.robot.getRegistry().isTaken(new ResourceIdBlock(index))) continue;
            Block nearbyBlock = this.robot.field_70170_p.func_147439_a(index.x, index.y, index.z);
            int nearbyMeta = this.robot.field_70170_p.func_72805_g(index.x, index.y, index.z);
            if (!(nearbyBlock instanceof BlockLaserTable) || nearbyMeta != 0) continue;
            TileAssemblyTable f = (TileAssemblyTable)this.robot.field_70170_p.func_147438_o(index.x, index.y, index.z);
            return f;
        }
        return null;
    }

    private class ReqStackFilter
    implements IStackFilter {
        private ReqStackFilter() {
        }

        @Override
        public boolean matches(ItemStack stack) {
            for (ArrayStackFilter s : AIRobotCraftAssemblyTable.this.requirements) {
                if (!s.matches(stack)) continue;
                return true;
            }
            return false;
        }
    }

    private class StationAssemblyTableFilter
    implements IStationFilter {
        private StationAssemblyTableFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            if (!ActionRobotFilter.canInteractWithItem(station, new ArrayStackFilter((ItemStack)((AIRobotCraftAssemblyTable)AIRobotCraftAssemblyTable.this).expectedResult.crafted), ActionStationAllowCraft.class)) {
                return false;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (AIRobotCraftAssemblyTable.this.getUsableAssemblyTable(new BlockIndex(station.x(), station.y(), station.z())) == null) continue;
                return true;
            }
            return false;
        }
    }
}

