/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.robots.AIRobotSearchAndGotoStation;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.robots.IStationFilter;
import buildcraft.silicon.statements.ActionStationInputItems;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.gates.StatementSlot;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotGotoStationToUnload
extends AIRobot {
    private boolean found = false;
    private IZone zone;

    public AIRobotGotoStationToUnload(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStationToUnload(EntityRobotBase iRobot, IZone iZone) {
        super(iRobot);
        this.zone = iZone;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotSearchAndGotoStation(this.robot, new StationInventory(), this.zone));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoStation) {
            this.found = ((AIRobotSearchAndGotoStation)ai).targetStation != null;
            this.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.found;
    }

    private class StationInventory
    implements IStationFilter {
        private StationInventory() {
        }

        @Override
        public boolean matches(DockingStation station) {
            Pipe pipe = station.getPipe().pipe;
            for (IInvSlot robotSlot : InventoryIterator.getIterable(AIRobotGotoStationToUnload.this.robot, ForgeDirection.UNKNOWN)) {
                if (robotSlot.getStackInSlot() == null) continue;
                for (StatementSlot s : new ActionIterator(pipe)) {
                    if (!(s.statement instanceof ActionStationInputItems) || !((ActionStationInputItems)s.statement).insert(station, (EntityRobot)AIRobotGotoStationToUnload.this.robot, s, robotSlot, false)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

