/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.robots.IBlockFilter;
import buildcraft.core.utils.PathFinding;
import buildcraft.core.utils.PathFindingJob;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AIRobotSearchBlock
extends AIRobot {
    public BlockIndex blockFound;
    public LinkedList<BlockIndex> path;
    private PathFinding blockScanner = null;
    private PathFindingJob blockScannerJob;
    private IBlockFilter pathFound;
    private int stopBefore = 0;

    public AIRobotSearchBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchBlock(EntityRobotBase iRobot, IBlockFilter iPathFound) {
        super(iRobot);
        this.pathFound = iPathFound;
        this.stopBefore = 0;
    }

    @Override
    public void start() {
        this.blockScanner = new PathFinding(this.robot.field_70170_p, new BlockIndex((Entity)this.robot), this.pathFound, 64.0f, this.robot.getZoneToWork());
        this.blockScannerJob = new PathFindingJob(this.blockScanner);
        this.blockScannerJob.start();
    }

    @Override
    public void update() {
        if (this.blockScannerJob == null) {
            this.abort();
            return;
        }
        if (this.blockScannerJob.isDone()) {
            this.path = this.blockScanner.getResult();
            if (this.path != null && this.path.size() > 0) {
                this.blockFound = this.path.removeLast();
            } else {
                this.path = null;
            }
            this.terminate();
        }
    }

    @Override
    public void end() {
        if (this.blockScannerJob != null) {
            this.blockScannerJob.terminate();
        }
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.func_74782_a("blockFound", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = new BlockIndex(nbt.func_74775_l("blockFound"));
        }
    }
}

