/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.filters.SimpleFluidFilter;
import buildcraft.core.robots.DockingStation;
import buildcraft.silicon.statements.ActionRobotFilter;
import buildcraft.silicon.statements.ActionStationAcceptFluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class AIRobotUnloadFluids
extends AIRobot {
    private int unloaded = 0;
    private int waitedCycles = 0;

    public AIRobotUnloadFluids(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public void update() {
        ++this.waitedCycles;
        if (this.waitedCycles > 40) {
            int previousUnloaded = this.unloaded;
            this.doLoad();
            if (this.unloaded == previousUnloaded) {
                this.terminate();
            } else {
                this.waitedCycles = 0;
            }
        }
    }

    private void doLoad() {
        if (this.robot.getDockingStation() != null) {
            DockingStation station = (DockingStation)this.robot.getDockingStation();
            if (!ActionRobotFilter.canInteractWithFluid(station, new SimpleFluidFilter(this.robot.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid), ActionStationAcceptFluids.class)) {
                return;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int filled;
                TileEntity nearbyTile = this.robot.field_70170_p.func_147438_o(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
                if (nearbyTile == null || !(nearbyTile instanceof IFluidHandler)) continue;
                IFluidHandler handler = (IFluidHandler)nearbyTile;
                FluidStack drainable = this.robot.drain(ForgeDirection.UNKNOWN, 1000, false);
                if (drainable == null || (filled = handler.fill(station.side, drainable = drainable.copy(), true)) <= 0) continue;
                drainable.amount = filled;
                this.robot.drain(ForgeDirection.UNKNOWN, drainable, true);
                this.unloaded += filled;
                return;
            }
        }
    }

    @Override
    public int getEnergyCost() {
        return 20;
    }

    @Override
    public boolean success() {
        return this.unloaded > 0;
    }
}

