/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftSilicon;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IZone;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IDockingStation;
import buildcraft.core.DefaultProps;
import buildcraft.core.LaserData;
import buildcraft.core.RFBattery;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.robots.AIRobotMain;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.EntityRobotEnergyFX;
import buildcraft.core.robots.RobotRegistry;
import buildcraft.core.utils.NBTUtils;
import buildcraft.core.utils.Utils;
import buildcraft.silicon.statements.ActionRobotWorkInArea;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.gates.StatementSlot;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Date;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class EntityRobot
extends EntityRobotBase
implements IEntityAdditionalSpawnData,
IInventory,
IFluidHandler,
ICommandReceiver {
    public static final ResourceLocation ROBOT_BASE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_base.png");
    public static final ResourceLocation ROBOT_BUILDER = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_builder.png");
    public static final ResourceLocation ROBOT_TRANSPORT = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_picker.png");
    public static final ResourceLocation ROBOT_FACTORY = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_factory.png");
    private static ResourceLocation defaultTexture = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_base.png");
    public SafeTimeTracker scanForTasks = new SafeTimeTracker(40L, 10L);
    public LaserData laser = new LaserData();
    public IDockingStation linkedDockingStation;
    public BlockIndex linkedDockingStationIndex;
    public ForgeDirection linkedDockingStationSide;
    public BlockIndex currentDockingStationIndex;
    public ForgeDirection currentDockingStationSide;
    public boolean isDocked = false;
    public NBTTagCompound originalBoardNBT;
    public RedstoneBoardRobot board;
    public AIRobotMain mainAI;
    public ItemStack itemInUse;
    public float itemAngle1 = 0.0f;
    public float itemAngle2 = 0.0f;
    public boolean itemActive = false;
    public float itemActiveStage = 0.0f;
    public long lastUpdateTime = 0L;
    private DockingStation currentDockingStation;
    private boolean needsUpdate = false;
    private ItemStack[] inv = new ItemStack[4];
    private FluidStack tank;
    private int maxFluid = 4000;
    private String boardID;
    private ResourceLocation texture;
    private WeakHashMap<Entity, Boolean> unreachableEntities = new WeakHashMap();
    private NBTTagList stackRequestNBT;
    private RFBattery battery = new RFBattery(100000, 100000, 0);
    private boolean firstUpdateDone = false;
    private long robotId = Long.MAX_VALUE;
    private int energySpendPerCycle = 0;
    private float energyFX = 0.0f;
    private int steamDx = 0;
    private int steamDy = -1;
    private int steamDz = 0;

    public EntityRobot(World world, NBTTagCompound boardNBT) {
        this(world);
        this.originalBoardNBT = boardNBT;
        this.board = (RedstoneBoardRobot)RedstoneBoardRegistry.instance.getRedstoneBoard(boardNBT).create(boardNBT, this);
        this.field_70180_af.func_75692_b(16, (Object)this.board.getNBTHandler().getID());
        if (!world.field_72995_K) {
            this.mainAI = new AIRobotMain(this);
            this.mainAI.start();
        }
    }

    public EntityRobot(World world) {
        super(world);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70158_ak = true;
        this.laser.isVisible = false;
        this.field_70144_Y = 1.0f;
        this.field_70130_N = 0.25f;
        this.field_70131_O = 0.25f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.setNullBoundingBox();
        this.field_70156_m = false;
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.func_110163_bv();
        this.field_70180_af.func_75682_a(12, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(13, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(14, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(15, (Object)0);
        this.field_70180_af.func_75682_a(16, (Object)"");
        this.field_70180_af.func_75682_a(17, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(18, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    protected void updateDataClient() {
        this.laser.tail.x = this.field_70180_af.func_111145_d(12);
        this.laser.tail.y = this.field_70180_af.func_111145_d(13);
        this.laser.tail.z = this.field_70180_af.func_111145_d(14);
        this.laser.isVisible = this.field_70180_af.func_75683_a(15) == 1;
        RedstoneBoardNBT<?> boardNBT = RedstoneBoardRegistry.instance.getRedstoneBoard(this.field_70180_af.func_75681_e(16));
        if (boardNBT != null) {
            this.texture = ((RedstoneBoardRobotNBT)boardNBT).getRobotTexture();
        }
        this.itemAngle1 = this.field_70180_af.func_111145_d(17);
        this.itemAngle2 = this.field_70180_af.func_111145_d(18);
        this.energySpendPerCycle = this.field_70180_af.func_75679_c(19);
    }

    protected void updateDataServer() {
        this.field_70180_af.func_75692_b(12, (Object)Float.valueOf((float)this.laser.tail.x));
        this.field_70180_af.func_75692_b(13, (Object)Float.valueOf((float)this.laser.tail.y));
        this.field_70180_af.func_75692_b(14, (Object)Float.valueOf((float)this.laser.tail.z));
        this.field_70180_af.func_75692_b(15, (Object)((byte)(this.laser.isVisible ? 1 : 0)));
        this.field_70180_af.func_75692_b(17, (Object)Float.valueOf(this.itemAngle1));
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.itemAngle2));
        this.field_70180_af.func_75692_b(19, (Object)this.energySpendPerCycle);
    }

    protected void init() {
        if (this.field_70170_p.field_72995_K) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "requestInitialization", null));
        }
    }

    public void setLaserDestination(float x, float y, float z) {
        if ((double)x != this.laser.tail.x || (double)y != this.laser.tail.y || (double)z != this.laser.tail.z) {
            this.laser.tail.x = x;
            this.laser.tail.y = y;
            this.laser.tail.z = z;
            this.needsUpdate = true;
        }
    }

    public void showLaser() {
        if (!this.laser.isVisible) {
            this.laser.isVisible = true;
            this.needsUpdate = true;
        }
    }

    public void hideLaser() {
        if (this.laser.isVisible) {
            this.laser.isVisible = false;
            this.needsUpdate = true;
        }
    }

    protected void firstUpdate() {
        if (this.stackRequestNBT != null) {
            // empty if block
        }
        if (!this.field_70170_p.field_72995_K) {
            this.getRegistry().registerRobot(this);
        }
    }

    public void func_70030_z() {
        if (!this.firstUpdateDone) {
            this.firstUpdate();
            this.firstUpdateDone = true;
        }
        if (!this.field_70170_p.field_72995_K && this.needsUpdate) {
            this.updateDataServer();
            this.needsUpdate = false;
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateDataClient();
            this.energyFX += (float)this.energySpendPerCycle;
            if (this.energyFX >= 100.0f) {
                this.energyFX = 0.0f;
                this.spawnEnergyFX();
            }
        }
        if (this.currentDockingStation != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70165_t = (float)this.currentDockingStation.x() + 0.5f + (float)this.currentDockingStation.side().offsetX * 0.5f;
            this.field_70163_u = (float)this.currentDockingStation.y() + 0.5f + (float)this.currentDockingStation.side().offsetY * 0.5f;
            this.field_70161_v = (float)this.currentDockingStation.z() + 0.5f + (float)this.currentDockingStation.side().offsetZ * 0.5f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.linkedDockingStation == null) {
                this.linkedDockingStation = RobotRegistry.getRegistry(this.field_70170_p).getStation(this.linkedDockingStationIndex.x, this.linkedDockingStationIndex.y, this.linkedDockingStationIndex.z, this.linkedDockingStationSide);
                if (this.linkedDockingStation == null || this.linkedDockingStation.robotTaking() != this) {
                    this.func_70106_y();
                    return;
                }
            }
            if (this.currentDockingStationIndex != null && this.currentDockingStation == null) {
                this.currentDockingStation = (DockingStation)RobotRegistry.getRegistry(this.field_70170_p).getStation(this.currentDockingStationIndex.x, this.currentDockingStationIndex.y, this.currentDockingStationIndex.z, this.currentDockingStationSide);
            }
            if (this.linkedDockingStation != null) {
                this.mainAI.cycle();
                if (this.energySpendPerCycle != this.mainAI.getActiveAI().getEnergyCost()) {
                    this.energySpendPerCycle = this.mainAI.getActiveAI().getEnergyCost();
                    this.needsUpdate = true;
                }
                if (this.battery.getEnergyStored() <= 0) {
                    this.func_70106_y();
                }
            }
        }
        super.func_70030_z();
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnEnergyFX() {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityRobotEnergyFX(this.field_70170_p, this.field_70165_t + (double)this.steamDx * 0.25, this.field_70163_u + (double)this.steamDy * 0.25, this.field_70161_v + (double)this.steamDz * 0.25, (double)this.steamDx * 0.05, (double)this.steamDy * 0.05, (double)this.steamDz * 0.05, (float)this.energySpendPerCycle * 0.075f < 1.0f ? 1.0f : (float)this.energySpendPerCycle * 0.075f));
    }

    public void setRegularBoundingBox() {
        this.field_70130_N = 0.5f;
        this.field_70131_O = 0.5f;
        if (this.laser.isVisible) {
            this.field_70121_D.field_72340_a = Math.min(this.field_70165_t, this.laser.tail.x);
            this.field_70121_D.field_72338_b = Math.min(this.field_70163_u, this.laser.tail.y);
            this.field_70121_D.field_72339_c = Math.min(this.field_70161_v, this.laser.tail.z);
            this.field_70121_D.field_72336_d = Math.max(this.field_70165_t, this.laser.tail.x);
            this.field_70121_D.field_72337_e = Math.max(this.field_70163_u, this.laser.tail.y);
            this.field_70121_D.field_72334_f = Math.max(this.field_70161_v, this.laser.tail.z);
            this.field_70121_D.field_72340_a -= 1.0;
            this.field_70121_D.field_72338_b -= 1.0;
            this.field_70121_D.field_72339_c -= 1.0;
            this.field_70121_D.field_72336_d += 1.0;
            this.field_70121_D.field_72337_e += 1.0;
            this.field_70121_D.field_72334_f += 1.0;
        } else {
            this.field_70121_D.field_72340_a = this.field_70165_t - 0.25;
            this.field_70121_D.field_72338_b = this.field_70163_u - 0.25;
            this.field_70121_D.field_72339_c = this.field_70161_v - 0.25;
            this.field_70121_D.field_72336_d = this.field_70165_t + 0.25;
            this.field_70121_D.field_72337_e = this.field_70163_u + 0.25;
            this.field_70121_D.field_72334_f = this.field_70161_v + 0.25;
        }
    }

    public void setNullBoundingBox() {
        this.field_70130_N = 0.0f;
        this.field_70131_O = 0.0f;
        this.field_70121_D.field_72340_a = this.field_70165_t;
        this.field_70121_D.field_72338_b = this.field_70163_u;
        this.field_70121_D.field_72339_c = this.field_70161_v;
        this.field_70121_D.field_72336_d = this.field_70165_t;
        this.field_70121_D.field_72337_e = this.field_70163_u;
        this.field_70121_D.field_72334_f = this.field_70161_v;
    }

    private void iterateBehaviorDocked() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.setNullBoundingBox();
    }

    public void writeSpawnData(ByteBuf data) {
    }

    public void readSpawnData(ByteBuf data) {
        this.init();
    }

    public ItemStack func_70694_bm() {
        return this.itemInUse;
    }

    public void func_70062_b(int i, ItemStack itemstack) {
    }

    public ItemStack[] func_70035_c() {
        return new ItemStack[0];
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public void func_70612_e(float par1, float par2) {
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
    }

    public boolean func_70617_f_() {
        return false;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTTagCompound linkedStationNBT = new NBTTagCompound();
        NBTTagCompound linkedStationIndexNBT = new NBTTagCompound();
        this.linkedDockingStationIndex.writeTo(linkedStationIndexNBT);
        linkedStationNBT.func_74782_a("index", (NBTBase)linkedStationIndexNBT);
        linkedStationNBT.func_74774_a("side", (byte)this.linkedDockingStationSide.ordinal());
        nbt.func_74782_a("linkedStation", (NBTBase)linkedStationNBT);
        if (this.currentDockingStationIndex != null) {
            NBTTagCompound currentStationNBT = new NBTTagCompound();
            NBTTagCompound currentStationIndexNBT = new NBTTagCompound();
            this.currentDockingStationIndex.writeTo(currentStationIndexNBT);
            currentStationNBT.func_74782_a("index", (NBTBase)currentStationIndexNBT);
            currentStationNBT.func_74774_a("side", (byte)this.currentDockingStationSide.ordinal());
            nbt.func_74782_a("currentStation", (NBTBase)currentStationNBT);
        }
        NBTTagCompound nbtLaser = new NBTTagCompound();
        this.laser.writeToNBT(nbtLaser);
        nbt.func_74782_a("laser", (NBTBase)nbtLaser);
        NBTTagCompound batteryNBT = new NBTTagCompound();
        this.battery.writeToNBT(batteryNBT);
        nbt.func_74782_a("battery", (NBTBase)batteryNBT);
        if (this.itemInUse != null) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.itemInUse.func_77955_b(itemNBT);
            nbt.func_74782_a("itemInUse", (NBTBase)itemNBT);
            nbt.func_74757_a("itemActive", this.itemActive);
        }
        for (int i = 0; i < this.inv.length; ++i) {
            NBTTagCompound stackNbt = new NBTTagCompound();
            if (this.inv[i] == null) continue;
            nbt.func_74782_a("inv[" + i + "]", (NBTBase)this.inv[i].func_77955_b(stackNbt));
        }
        nbt.func_74782_a("originalBoardNBT", (NBTBase)this.originalBoardNBT);
        NBTTagCompound ai = new NBTTagCompound();
        this.mainAI.writeToNBT(ai);
        nbt.func_74782_a("mainAI", (NBTBase)ai);
        if (this.mainAI.getDelegateAI() != this.board) {
            NBTTagCompound boardNBT = new NBTTagCompound();
            this.board.writeToNBT(boardNBT);
            nbt.func_74782_a("board", (NBTBase)boardNBT);
        }
        nbt.func_74772_a("robotId", this.robotId);
        if (this.tank != null) {
            NBTTagCompound tankNBT = new NBTTagCompound();
            this.tank.writeToNBT(tankNBT);
            nbt.func_74782_a("tank", (NBTBase)tankNBT);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        NBTTagCompound linkedStationNBT = nbt.func_74775_l("linkedStation");
        this.linkedDockingStationIndex = new BlockIndex(linkedStationNBT.func_74775_l("index"));
        this.linkedDockingStationSide = ForgeDirection.values()[linkedStationNBT.func_74771_c("side")];
        if (nbt.func_74764_b("currentStation")) {
            NBTTagCompound currentStationNBT = nbt.func_74775_l("currentStation");
            this.currentDockingStationIndex = new BlockIndex(currentStationNBT.func_74775_l("index"));
            this.currentDockingStationSide = ForgeDirection.values()[currentStationNBT.func_74771_c("side")];
        }
        this.laser.readFromNBT(nbt.func_74775_l("laser"));
        this.battery.readFromNBT(nbt.func_74775_l("battery"));
        if (nbt.func_74764_b("itemInUse")) {
            this.itemInUse = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("itemInUse"));
            this.itemActive = nbt.func_74767_n("itemActive");
        }
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("inv[" + i + "]"));
        }
        this.originalBoardNBT = nbt.func_74775_l("originalBoardNBT");
        NBTTagCompound ai = nbt.func_74775_l("mainAI");
        this.mainAI = (AIRobotMain)AIRobot.loadAI(ai, this);
        this.board = nbt.func_74764_b("board") ? (RedstoneBoardRobot)AIRobot.loadAI(nbt.func_74775_l("board"), this) : (RedstoneBoardRobot)this.mainAI.getDelegateAI();
        this.field_70180_af.func_75692_b(16, (Object)this.board.getNBTHandler().getID());
        this.stackRequestNBT = nbt.func_150295_c("stackRequests", 10);
        if (nbt.func_74764_b("robotId")) {
            this.robotId = nbt.func_74763_f("robotId");
        }
        this.tank = nbt.func_74764_b("tank") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("tank")) : null;
        this.func_110163_bv();
    }

    @Override
    public void dock(IDockingStation station) {
        this.currentDockingStation = (DockingStation)station;
        this.setSteamDirection(this.currentDockingStation.side.offsetX, this.currentDockingStation.side.offsetY, this.currentDockingStation.side.offsetZ);
        this.currentDockingStationIndex = this.currentDockingStation.index();
        this.currentDockingStationSide = this.currentDockingStation.side();
    }

    @Override
    public void undock() {
        if (this.currentDockingStation != null) {
            this.currentDockingStation.release(this);
            this.currentDockingStation = null;
            this.setSteamDirection(0, -1, 0);
            this.currentDockingStationIndex = null;
            this.currentDockingStationSide = null;
        }
    }

    @Override
    public DockingStation getDockingStation() {
        return this.currentDockingStation;
    }

    public void setMainStation(IDockingStation iStation) {
        DockingStation station = (DockingStation)iStation;
        if (this.linkedDockingStation != null && this.linkedDockingStation != station) {
            ((DockingStation)this.linkedDockingStation).unsafeRelease(this);
        }
        this.linkedDockingStation = station;
        this.linkedDockingStationIndex = this.linkedDockingStation.index();
        this.linkedDockingStationSide = this.linkedDockingStation.side();
    }

    public ItemStack func_71124_b(int var1) {
        return null;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.inv[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        ItemStack result = this.inv[var1].func_77979_a(var2);
        if (this.inv[var1].field_77994_a == 0) {
            this.inv[var1] = null;
        }
        this.updateClientSlot(var1);
        return result;
    }

    public ItemStack func_70304_b(int var1) {
        return this.inv[var1].func_77979_a(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inv[var1] = var2;
        this.updateClientSlot(var1);
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public void updateClientSlot(final int slot) {
        BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "clientSetInventory", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeShort(slot);
                Utils.writeStack(data, EntityRobot.this.inv[slot]);
            }
        }), this.field_70170_p);
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return this.inv[var1] == null || this.inv[var1].func_77969_a(var2) && this.inv[var1].func_77985_e() && this.inv[var1].field_77994_a + var2.field_77994_a <= this.inv[var1].func_77973_b().getItemStackLimit(this.inv[var1]);
    }

    @Override
    public boolean isMoving() {
        return this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0;
    }

    @Override
    public void setItemInUse(ItemStack stack) {
        this.itemInUse = stack;
        BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "clientSetItemInUse", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                Utils.writeStack(data, EntityRobot.this.itemInUse);
            }
        }), this.field_70170_p);
    }

    private void setSteamDirection(final int x, final int y, final int z) {
        if (!this.field_70170_p.field_72995_K) {
            BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "setSteamDirection", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeInt(x);
                    data.writeShort(y);
                    data.writeInt(z);
                }
            }), this.field_70170_p);
        } else {
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            v.func_72432_b();
            this.steamDx = (int)v.field_72450_a;
            this.steamDy = (int)v.field_72448_b;
            this.steamDz = (int)v.field_72449_c;
        }
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient()) {
            if ("clientSetItemInUse".equals(command)) {
                this.itemInUse = Utils.readStack(stream);
            } else if ("clientSetInventory".equals(command)) {
                int slot = stream.readUnsignedShort();
                this.inv[slot] = Utils.readStack(stream);
            } else if ("initialize".equals(command)) {
                this.itemInUse = Utils.readStack(stream);
                this.itemActive = stream.readBoolean();
            } else if ("setItemActive".equals(command)) {
                this.itemActive = stream.readBoolean();
                this.itemActiveStage = 0.0f;
                this.lastUpdateTime = new Date().getTime();
                if (!this.itemActive) {
                    this.setSteamDirection(0, -1, 0);
                }
            } else if ("setSteamDirection".equals(command)) {
                this.setSteamDirection(stream.readInt(), stream.readShort(), stream.readInt());
            }
        } else if (side.isServer()) {
            EntityPlayer p = (EntityPlayer)sender;
            if ("requestInitialization".equals(command)) {
                BuildCraftCore.instance.sendToPlayer(p, new PacketCommand(this, "initialize", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        Utils.writeStack(data, EntityRobot.this.itemInUse);
                        data.writeBoolean(EntityRobot.this.itemActive);
                    }
                }));
                int i = 0;
                while (i < this.inv.length) {
                    final int j = i++;
                    BuildCraftCore.instance.sendToPlayer(p, new PacketCommand(this, "clientSetInventory", new CommandWriter(){

                        @Override
                        public void write(ByteBuf data) {
                            data.writeShort(j);
                            Utils.writeStack(data, EntityRobot.this.inv[j]);
                        }
                    }));
                }
                if (this.currentDockingStation != null) {
                    this.setSteamDirection(this.currentDockingStation.side.offsetX, this.currentDockingStation.side.offsetY, this.currentDockingStation.side.offsetZ);
                } else {
                    this.setSteamDirection(0, -1, 0);
                }
            }
        }
    }

    public void func_70606_j(float par1) {
    }

    public boolean func_70097_a(DamageSource par1, float par2) {
        return false;
    }

    @Override
    public void aimItemAt(int x, int y, int z) {
        this.itemAngle1 = (float)Math.atan2((double)z - Math.floor(this.field_70161_v), (double)x - Math.floor(this.field_70165_t));
        this.itemAngle2 = 0.0f;
        if (Math.floor(this.field_70163_u) < (double)y) {
            this.itemAngle2 = -0.7853982f;
            if (Math.floor(this.field_70165_t) == (double)x && Math.floor(this.field_70161_v) == (double)z) {
                this.itemAngle2 -= 0.7853982f;
            }
        } else if (Math.floor(this.field_70163_u) > (double)y) {
            this.itemAngle2 = 1.5707964f;
            if (Math.floor(this.field_70165_t) == (double)x && Math.floor(this.field_70161_v) == (double)z) {
                this.itemAngle2 += 0.7853982f;
            }
        }
        int xComp = (int)Math.floor(this.field_70165_t);
        int yComp = (int)Math.floor(this.field_70163_u);
        int zComp = (int)Math.floor(this.field_70161_v);
        this.setSteamDirection(xComp - x, yComp - y, zComp - z);
        this.updateDataServer();
    }

    @Override
    public void setItemActive(final boolean isActive) {
        if (isActive != this.itemActive) {
            this.itemActive = isActive;
            BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "setItemActive", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeBoolean(isActive);
                }
            }), this.field_70170_p);
        }
    }

    @Override
    public RedstoneBoardRobot getBoard() {
        return this.board;
    }

    @Override
    public IDockingStation getLinkedStation() {
        return this.linkedDockingStation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.battery.getEnergyStored();
    }

    @Override
    public RFBattery getBattery() {
        return this.battery;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public AIRobot getOverridingAI() {
        return this.mainAI.getOverridingAI();
    }

    public void overrideAI(AIRobot ai) {
        this.mainAI.setOverridingAI(ai);
    }

    public void attackTargetEntityWithCurrentItem(Entity par1Entity) {
        ItemStack stack = this.itemInUse;
        if (par1Entity.func_70075_an() && !par1Entity.func_85031_j((Entity)this)) {
            this.func_130011_c(par1Entity);
            boolean flag2 = par1Entity.func_70097_a((DamageSource)new EntityDamageSource("robot", (Entity)this), 2.0f);
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)par1Entity);
            ItemStack itemstack = this.itemInUse;
            Entity object = par1Entity;
            if (itemstack != null && object instanceof EntityLivingBase) {
                itemstack.func_77973_b().func_77644_a(itemstack, (EntityLivingBase)object, (EntityLivingBase)this);
            }
        }
    }

    @Override
    public IZone getZoneToWork() {
        if (this.linkedDockingStation instanceof DockingStation) {
            for (StatementSlot s : new ActionIterator(((DockingStation)this.linkedDockingStation).getPipe().pipe)) {
                IZone zone;
                if (!(s.statement instanceof ActionRobotWorkInArea) || (zone = ActionRobotWorkInArea.getArea(s)) == null) continue;
                return zone;
            }
        }
        return null;
    }

    @Override
    public boolean containsItems() {
        for (ItemStack element : this.inv) {
            if (element == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFreeSlot() {
        for (ItemStack element : this.inv) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unreachableEntityDetected(Entity entity) {
        this.unreachableEntities.put(entity, true);
    }

    @Override
    public boolean isKnownUnreachable(Entity entity) {
        return this.unreachableEntities.containsKey(entity);
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.mainAI != null) {
                this.mainAI.abort();
            }
            ItemStack robotStack = new ItemStack(BuildCraftSilicon.robotItem);
            NBTUtils.getItemData(robotStack).func_74782_a("board", (NBTBase)this.originalBoardNBT);
            this.func_70099_a(robotStack, 0.0f);
            this.getRegistry().killRobot(this);
        }
        super.func_70106_y();
    }

    @Override
    public void onChunkUnload() {
        this.getRegistry().unloadRobot(this);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity par1Entity) {
    }

    public void func_70108_f(Entity par1Entity) {
    }

    public void setUniqueRobotId(long iRobotId) {
        this.robotId = iRobotId;
    }

    @Override
    public long getRobotId() {
        return this.robotId;
    }

    @Override
    public RobotRegistry getRegistry() {
        return RobotRegistry.getRegistry(this.field_70170_p);
    }

    @Override
    public void releaseResources() {
        this.getRegistry().releaseResources(this);
    }

    public ItemStack receiveItem(TileEntity tile, ItemStack stack) {
        if (this.currentDockingStation != null && this.currentDockingStation.index().nextTo(new BlockIndex(tile)) && this.mainAI != null) {
            return this.mainAI.getActiveAI().receiveItem(stack);
        }
        return stack;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int result = 0;
        if (this.tank == null) {
            this.tank = new FluidStack(resource.getFluid(), 0);
        }
        if (this.tank.amount + resource.amount <= this.maxFluid) {
            result = resource.amount;
            if (doFill) {
                this.tank.amount += resource.amount;
            }
        } else {
            result = this.maxFluid - this.tank.amount;
            if (doFill) {
                this.tank.amount = this.maxFluid;
            }
        }
        if (this.tank != null && this.tank.amount == 0) {
            this.tank = null;
        }
        return result;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.tank != null && this.tank.fluidID == resource.fluidID) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack result = null;
        if (this.tank == null) {
            result = null;
        } else if (this.tank.amount <= maxDrain) {
            result = this.tank.copy();
            if (doDrain) {
                this.tank = null;
            }
        } else {
            result = this.tank.copy();
            result.amount = maxDrain;
            if (doDrain) {
                this.tank.amount -= maxDrain;
            }
        }
        if (this.tank != null && this.tank.amount == 0) {
            this.tank = null;
        }
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank == null || this.tank.amount == 0 || this.tank.amount < this.maxFluid && this.tank.fluidID == fluid.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank != null && this.tank.amount != 0 && this.tank.fluidID == fluid.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.tank, this.maxFluid)};
    }
}

