/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IDockingStation;
import buildcraft.api.robots.IRobotRegistry;
import buildcraft.api.robots.ResourceId;
import buildcraft.core.robots.DockingStation;
import buildcraft.core.robots.EntityRobot;
import buildcraft.core.robots.StationIndex;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.ChunkEvent;

public class RobotRegistry
extends WorldSavedData
implements IRobotRegistry {
    public static HashMap<Integer, RobotRegistry> registries = new HashMap();
    protected World world;
    private long nextRobotID = Long.MIN_VALUE;
    private HashMap<Long, EntityRobot> robotsLoaded = new HashMap();
    private HashMap<ResourceId, Long> resourcesTaken = new HashMap();
    private HashMap<Long, HashSet<ResourceId>> resourcesTakenByRobot = new HashMap();
    private HashMap<StationIndex, IDockingStation> stations = new HashMap();
    private HashMap<Long, HashSet<StationIndex>> stationsTakenByRobot = new HashMap();

    public RobotRegistry(String id) {
        super(id);
    }

    @Override
    public long getNextRobotId() {
        long result = this.nextRobotID++;
        return result;
    }

    @Override
    public void registerRobot(EntityRobotBase robot) {
        this.func_76185_a();
        if (robot.getRobotId() == Long.MAX_VALUE) {
            ((EntityRobot)robot).setUniqueRobotId(this.getNextRobotId());
        }
        this.robotsLoaded.put(robot.getRobotId(), (EntityRobot)robot);
    }

    @Override
    public void killRobot(EntityRobotBase robot) {
        this.func_76185_a();
        this.releaseResources(robot, true);
        this.robotsLoaded.remove(robot.getRobotId());
    }

    @Override
    public void unloadRobot(EntityRobotBase robot) {
        this.func_76185_a();
        this.releaseResources(robot, false, true);
        this.robotsLoaded.remove(robot.getRobotId());
    }

    @Override
    public EntityRobot getLoadedRobot(long id) {
        if (this.robotsLoaded.containsKey(id)) {
            return this.robotsLoaded.get(id);
        }
        return null;
    }

    @Override
    public synchronized boolean isTaken(ResourceId resourceId) {
        return this.robotIdTaking(resourceId) != Long.MAX_VALUE;
    }

    @Override
    public synchronized long robotIdTaking(ResourceId resourceId) {
        if (!this.resourcesTaken.containsKey(resourceId)) {
            return Long.MAX_VALUE;
        }
        long robotId = this.resourcesTaken.get(resourceId);
        if (this.robotsLoaded.containsKey(robotId) && !this.robotsLoaded.get((Object)Long.valueOf((long)robotId)).field_70128_L) {
            return robotId;
        }
        this.release(resourceId);
        return Long.MAX_VALUE;
    }

    @Override
    public synchronized EntityRobot robotTaking(ResourceId resourceId) {
        long robotId = this.robotIdTaking(resourceId);
        if (robotId == Long.MAX_VALUE || !this.robotsLoaded.containsKey(robotId)) {
            return null;
        }
        return this.robotsLoaded.get(robotId);
    }

    @Override
    public synchronized boolean take(ResourceId resourceId, EntityRobotBase robot) {
        this.func_76185_a();
        return this.take(resourceId, robot.getRobotId());
    }

    @Override
    public synchronized boolean take(ResourceId resourceId, long robotId) {
        if (resourceId == null) {
            return false;
        }
        this.func_76185_a();
        if (!this.resourcesTaken.containsKey(resourceId)) {
            this.resourcesTaken.put(resourceId, robotId);
            if (!this.resourcesTakenByRobot.containsKey(robotId)) {
                this.resourcesTakenByRobot.put(robotId, new HashSet());
            }
            this.resourcesTakenByRobot.get(robotId).add(resourceId);
            resourceId.taken(robotId);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void release(ResourceId resourceId) {
        if (resourceId == null) {
            return;
        }
        this.func_76185_a();
        if (this.resourcesTaken.containsKey(resourceId)) {
            long robotId = this.resourcesTaken.get(resourceId);
            this.resourcesTakenByRobot.get(this.resourcesTaken.get(resourceId)).remove(resourceId);
            this.resourcesTaken.remove(resourceId);
            resourceId.released(robotId);
        }
    }

    @Override
    public synchronized void releaseResources(EntityRobotBase robot) {
        this.releaseResources(robot, false);
    }

    private synchronized void releaseResources(EntityRobotBase robot, boolean forceAll) {
        this.releaseResources(robot, forceAll, false);
    }

    private synchronized void releaseResources(EntityRobotBase robot, boolean forceAll, boolean resetMainLink) {
        this.func_76185_a();
        if (this.resourcesTakenByRobot.containsKey(robot.getRobotId())) {
            HashSet resourceSet = (HashSet)this.resourcesTakenByRobot.get(robot.getRobotId()).clone();
            for (ResourceId id : resourceSet) {
                this.release(id);
            }
            this.resourcesTakenByRobot.remove(robot.getRobotId());
        }
        if (this.stationsTakenByRobot.containsKey(robot.getRobotId())) {
            HashSet stationSet = (HashSet)this.stationsTakenByRobot.get(robot.getRobotId()).clone();
            for (StationIndex s : stationSet) {
                DockingStation d = (DockingStation)this.stations.get(s);
                if (d == null) continue;
                if (!d.canRelease()) {
                    if (forceAll) {
                        d.unsafeRelease(robot);
                        continue;
                    }
                    if (!resetMainLink || !d.isMainStation() || d.robotIdTaking() != robot.getRobotId()) continue;
                    d.invalidateRobotTakingEntity();
                    continue;
                }
                d.unsafeRelease(robot);
            }
            if (forceAll) {
                this.stationsTakenByRobot.remove(robot.getRobotId());
            }
        }
    }

    @Override
    public synchronized IDockingStation getStation(int x, int y, int z, ForgeDirection side) {
        StationIndex index = new StationIndex(side, x, y, z);
        if (this.stations.containsKey(index)) {
            return this.stations.get(index);
        }
        return null;
    }

    @Override
    public synchronized Collection<IDockingStation> getStations() {
        return this.stations.values();
    }

    @Override
    public synchronized void registerStation(IDockingStation station) {
        this.func_76185_a();
        StationIndex index = new StationIndex(station);
        if (this.stations.containsKey(index)) {
            throw new InvalidParameterException("Station " + index + " already registerd");
        }
        this.stations.put(index, station);
    }

    @Override
    public synchronized void removeStation(IDockingStation station) {
        this.func_76185_a();
        StationIndex index = new StationIndex(station);
        if (this.stations.containsKey(index)) {
            if (station.robotTaking() != null) {
                station.robotTaking().func_70106_y();
            } else if (station.robotIdTaking() != Long.MAX_VALUE) {
                this.stationsTakenByRobot.get(station.robotIdTaking()).remove(index);
            }
            this.stations.remove(index);
        }
    }

    @Override
    public synchronized void take(IDockingStation station, long robotId) {
        if (!this.stationsTakenByRobot.containsKey(robotId)) {
            this.stationsTakenByRobot.put(robotId, new HashSet());
        }
        this.stationsTakenByRobot.get(robotId).add(new StationIndex(station));
    }

    @Override
    public synchronized void release(IDockingStation station, long robotId) {
        if (this.stationsTakenByRobot.containsKey(robotId)) {
            this.stationsTakenByRobot.get(robotId).remove(new StationIndex(station));
        }
    }

    public static synchronized RobotRegistry getRegistry(World world) {
        if (!registries.containsKey(world.field_73011_w.field_76574_g) || RobotRegistry.registries.get((Object)Integer.valueOf((int)world.field_73011_w.field_76574_g)).world != world) {
            RobotRegistry newRegistry = (RobotRegistry)world.perWorldStorage.func_75742_a(RobotRegistry.class, "robotRegistry");
            if (newRegistry == null) {
                newRegistry = new RobotRegistry("robotRegistry");
                world.perWorldStorage.func_75745_a("robotRegistry", (WorldSavedData)newRegistry);
            }
            newRegistry.world = world;
            for (IDockingStation d : newRegistry.stations.values()) {
                ((DockingStation)d).world = world;
            }
            MinecraftForge.EVENT_BUS.register((Object)newRegistry);
            registries.put(world.field_73011_w.field_76574_g, newRegistry);
            return newRegistry;
        }
        return registries.get(world.field_73011_w.field_76574_g);
    }

    public synchronized void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74772_a("nextRobotID", this.nextRobotID);
        NBTTagList resourceList = new NBTTagList();
        for (Map.Entry<ResourceId, Long> e : this.resourcesTaken.entrySet()) {
            NBTTagCompound cpt = new NBTTagCompound();
            NBTTagCompound resourceId = new NBTTagCompound();
            e.getKey().writeToNBT(resourceId);
            cpt.func_74782_a("resourceId", (NBTBase)resourceId);
            cpt.func_74772_a("robotId", e.getValue().longValue());
            resourceList.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("resourceList", (NBTBase)resourceList);
        NBTTagList stationList = new NBTTagList();
        for (Map.Entry<StationIndex, IDockingStation> e : this.stations.entrySet()) {
            NBTTagCompound cpt = new NBTTagCompound();
            e.getValue().writeToNBT(cpt);
            stationList.func_74742_a((NBTBase)cpt);
        }
        nbt.func_74782_a("stationList", (NBTBase)stationList);
    }

    public synchronized void func_76184_a(NBTTagCompound nbt) {
        this.nextRobotID = nbt.func_74763_f("nextRobotID");
        NBTTagList resourceList = nbt.func_150295_c("resourceList", 10);
        for (int i = 0; i < resourceList.func_74745_c(); ++i) {
            NBTTagCompound cpt = resourceList.func_150305_b(i);
            ResourceId resourceId = ResourceId.load(cpt.func_74775_l("resourceId"));
            long robotId = cpt.func_74763_f("robotId");
            this.take(resourceId, robotId);
        }
        NBTTagList stationList = nbt.func_150295_c("stationList", 10);
        for (int i = 0; i < stationList.func_74745_c(); ++i) {
            NBTTagCompound cpt = stationList.func_150305_b(i);
            DockingStation station = new DockingStation();
            station.readFromNBT(cpt);
            this.registerStation(station);
            if (station.linkedId() == Long.MAX_VALUE) continue;
            this.take(station, station.linkedId());
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload e) {
        if (e.world == this.world) {
            for (EntityRobot robot : new ArrayList<EntityRobot>(this.robotsLoaded.values())) {
                if (e.world.field_72996_f.contains(robot)) continue;
                robot.onChunkUnload();
            }
        }
    }
}

